/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.datagen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.objects.Registration;
import net.silentchaos512.scalinghealth.world.HeartCrystalPlacement;
import net.silentchaos512.scalinghealth.world.PowerCrystalPlacement;

public class WorldGenGenerator
extends DatapackBuiltinEntriesProvider {
    private static final RuleTest replaceStone = new TagMatchTest(BlockTags.f_144266_);
    private static final RuleTest replaceDeepslate = new TagMatchTest(BlockTags.f_144267_);
    private static final ConfiguredFeature<?, ?> heartCrystalStoneFeature = WorldGenGenerator.ore((Block)Registration.HEART_CRYSTAL_ORE.get(), replaceStone, 4);
    private static final ConfiguredFeature<?, ?> heartCrystalDeepslateFeature = WorldGenGenerator.ore((Block)Registration.DEEPSLATE_HEART_CRYSTAL_ORE.get(), replaceDeepslate, 4);
    private static final ConfiguredFeature<?, ?> powerCrystalStoneFeature = WorldGenGenerator.ore((Block)Registration.POWER_CRYSTAL_ORE.get(), replaceStone, 3);
    private static final ConfiguredFeature<?, ?> powerCrystalDeepslateFeature = WorldGenGenerator.ore((Block)Registration.DEEPSLATE_POWER_CRYSTAL_ORE.get(), replaceDeepslate, 4);
    private static final ResourceKey<ConfiguredFeature<?, ?>> heartCrystalStoneName = WorldGenGenerator.configuredFeature(ScalingHealth.getId("heart_crystal_stone_ore"));
    private static final ResourceKey<ConfiguredFeature<?, ?>> heartCrystalDeepslateName = WorldGenGenerator.configuredFeature(ScalingHealth.getId("heart_crystal_stone_deepslate"));
    private static final ResourceKey<ConfiguredFeature<?, ?>> powerCrystalStoneName = WorldGenGenerator.configuredFeature(ScalingHealth.getId("power_crystal_stone_ore"));
    private static final ResourceKey<ConfiguredFeature<?, ?>> powerCrystalDeepslateName = WorldGenGenerator.configuredFeature(ScalingHealth.getId("power_crystal_stone_deepslate"));
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_256911_, ctx -> {
        ctx.m_255272_(heartCrystalStoneName, heartCrystalStoneFeature);
        ctx.m_255272_(heartCrystalDeepslateName, heartCrystalDeepslateFeature);
        ctx.m_255272_(powerCrystalStoneName, powerCrystalStoneFeature);
        ctx.m_255272_(powerCrystalDeepslateName, powerCrystalDeepslateFeature);
    }).m_254916_(Registries.f_256988_, ctx -> {
        PlacedFeature heartCrystalStonePlaced = WorldGenGenerator.placed(WorldGenGenerator.holderFeature((BootstapContext<PlacedFeature>)ctx, heartCrystalStoneName), (PlacementModifier)HeartCrystalPlacement.INSTANCE, 100, 1);
        PlacedFeature heartCrystalDeepslatePlaced = WorldGenGenerator.placed(WorldGenGenerator.holderFeature((BootstapContext<PlacedFeature>)ctx, heartCrystalDeepslateName), (PlacementModifier)HeartCrystalPlacement.INSTANCE, 64, 2);
        PlacedFeature powerCrystalStonePlaced = WorldGenGenerator.placed(WorldGenGenerator.holderFeature((BootstapContext<PlacedFeature>)ctx, powerCrystalStoneName), (PlacementModifier)PowerCrystalPlacement.INSTANCE, 100, 1);
        PlacedFeature powerCrystalDeepslatePlaced = WorldGenGenerator.placed(WorldGenGenerator.holderFeature((BootstapContext<PlacedFeature>)ctx, powerCrystalDeepslateName), (PlacementModifier)PowerCrystalPlacement.INSTANCE, 64, 1);
        ctx.m_255272_(WorldGenGenerator.placedFeature(heartCrystalStoneName.m_135782_()), (Object)heartCrystalStonePlaced);
        ctx.m_255272_(WorldGenGenerator.placedFeature(heartCrystalDeepslateName.m_135782_()), (Object)heartCrystalDeepslatePlaced);
        ctx.m_255272_(WorldGenGenerator.placedFeature(powerCrystalStoneName.m_135782_()), (Object)powerCrystalStonePlaced);
        ctx.m_255272_(WorldGenGenerator.placedFeature(powerCrystalDeepslateName.m_135782_()), (Object)powerCrystalDeepslatePlaced);
    }).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, ctx -> {
        Holder<PlacedFeature> heartCrystalStone = WorldGenGenerator.holderPlaced((BootstapContext<BiomeModifier>)ctx, heartCrystalStoneName.m_135782_());
        Holder<PlacedFeature> heartCrystalDeepslate = WorldGenGenerator.holderPlaced((BootstapContext<BiomeModifier>)ctx, heartCrystalDeepslateName.m_135782_());
        Holder<PlacedFeature> powerCrystalStone = WorldGenGenerator.holderPlaced((BootstapContext<BiomeModifier>)ctx, powerCrystalStoneName.m_135782_());
        Holder<PlacedFeature> powerCrystalDeepslate = WorldGenGenerator.holderPlaced((BootstapContext<BiomeModifier>)ctx, powerCrystalDeepslateName.m_135782_());
        HolderSet.Named isOverworldTag = ctx.m_255420_(Registries.f_256952_).m_254956_(BiomeTags.f_215817_);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier ores = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)isOverworldTag, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{heartCrystalStone, heartCrystalDeepslate, powerCrystalStone, powerCrystalDeepslate}), GenerationStep.Decoration.UNDERGROUND_ORES);
        ctx.m_255272_(WorldGenGenerator.biomeModifier(ScalingHealth.getId("sh_ores")), (Object)ores);
    });

    public WorldGenGenerator(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider(), BUILDER, Set.of("scalinghealth"));
    }

    public static ConfiguredFeature<?, ?> ore(Block block, RuleTest replacing, int size) {
        return new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(replacing, block.m_49966_(), size));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> configuredFeature(ResourceLocation name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)name);
    }

    protected static ResourceKey<PlacedFeature> placedFeature(ResourceLocation name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)name);
    }

    protected static ResourceKey<BiomeModifier> biomeModifier(ResourceLocation name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)name);
    }

    public static PlacedFeature placed(Holder<ConfiguredFeature<?, ?>> feature, PlacementModifier config, int height, int count) {
        return new PlacedFeature(feature, WorldGenGenerator.placements(height, count, config));
    }

    public static List<PlacementModifier> placements(int height, int count, PlacementModifier config) {
        return ImmutableList.of((Object)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)height)), (Object)InSquarePlacement.m_191715_(), (Object)CountPlacement.m_191628_((int)count), (Object)BiomeFilter.m_191561_(), (Object)config);
    }

    public static Holder<ConfiguredFeature<?, ?>> holderFeature(BootstapContext<PlacedFeature> ctx, ResourceKey<ConfiguredFeature<?, ?>> location) {
        return ctx.m_255420_(Registries.f_256911_).m_255043_(location);
    }

    public static Holder<PlacedFeature> holderPlaced(BootstapContext<BiomeModifier> ctx, ResourceLocation location) {
        return ctx.m_255420_(Registries.f_256988_).m_255043_(WorldGenGenerator.placedFeature(location));
    }
}

