/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.datagen;

import net.minecraft.data.DataGenerator;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.silentchaos512.scalinghealth.objects.Registration;

public class EnglishLocalization
extends LanguageProvider {
    public EnglishLocalization(DataGenerator gen) {
        super(gen.getPackOutput(), "scalinghealth", "en_us");
    }

    protected void addTranslations() {
        this.noPost("blight", "Blight %s");
        this.add("blight", "killedByPlayer", "Blight %s was killed by %s!");
        this.add((Block)Registration.HEART_CRYSTAL_ORE.get(), "Heart Crystal Ore");
        this.add((Block)Registration.POWER_CRYSTAL_ORE.get(), "Power Crystal Ore");
        this.add((Block)Registration.DEEPSLATE_HEART_CRYSTAL_ORE.get(), "Deepslate Heart Crystal Ore");
        this.add((Block)Registration.DEEPSLATE_POWER_CRYSTAL_ORE.get(), "Deepslate Power Crystal Ore");
        this.addCommand("outOfBounds", "Value must be between %s and %s");
        this.addCommand("valueOverMax", "%s / %s");
        this.addCommand("playerName", "Player: %s");
        this.addCommand("playerName.inDimension", "(in dimension %s)");
        this.addCommand("difficulty.area", "Area Difficulty: %s");
        this.addCommand("difficulty.player", "Player Difficulty: %s");
        this.addCommand("difficulty.server", "Server Difficulty: %s");
        this.addCommand("health.actual", "Actual Health: %s");
        this.addCommand("health.heartCrystals", "Heart Crystals: %s");
        this.addCommand("health.heartCrystals.values", "%d (%s health)");
        this.addCommand("power.actual", "Actual Attack Damage: %s");
        this.addCommand("power.powerCrystals", "Power Crystals: %s");
        this.addCommand("power.powerCrystals.values", "%d (%s damage)");
        this.addCommand("recalculate.start", "Recalculating difficulty for all entities! This may take some time...");
        this.addCommand("recalculate.finish", "Recalculate finished! Processed %d entities.");
        this.add((MobEffect)Registration.BANDAGED.get(), "Bandaged");
        this.add((Item)Registration.BANDAGES.get(), "Bandages");
        this.add((Item)Registration.HEART_CRYSTAL_SHARD.get(), "Heart Crystal Shard");
        this.add((Item)Registration.CURSED_HEART.get(), "Cursed Heart");
        this.add((Item)Registration.ENCHANTED_HEART.get(), "Enchanted Heart");
        this.add((Item)Registration.CHANCE_HEART.get(), "Chance Heart");
        this.addItem("difficulty_changer.effectDesc", "Difficulty %s");
        this.addItem("stat_booster.notEnoughXP", "You need %d XP levels to use this.");
        this.add((Item)Registration.HEART_CRYSTAL.get(), "Heart Crystal");
        this.addItem("heart_crystal.desc", "Increases maximum health");
        this.add((Item)Registration.HEART_DUST.get(), "Heart Dust");
        this.addItem("healing_item.value", "Restores %d%% of your health over %d seconds.");
        this.addItem("healing_item.howToUse", "Use for %d seconds to apply.");
        this.add((Item)Registration.MEDKIT.get(), "Medkit");
        this.add((Item)Registration.POWER_CRYSTAL.get(), "Power Crystal");
        this.addItem("power_crystal.desc", "Increases base attack damage");
        this.add((Item)Registration.POWER_CRYSTAL_SHARD.get(), "Power Crystal Shard");
        this.noPost("itemGroup", "Scaling Health");
        this.add("key", "difficultyMeter", "Difficulty Meter Toggle");
        this.add("misc", "difficultyMeterText", "DIFFICULTY");
        this.add("misc", "sleepWarning", "[Scaling Health] Warning: Sleeping will change your difficulty.");
        this.add("misc", "afkmessage", "You are now afk, you will gain less difficulty with time.");
        this.addSubtitle("cursed_heart_use", "Cursed Heart used");
        this.addSubtitle("enchanted_heart_use", "Enchanted Heart used");
        this.addSubtitle("heart_crystal_use", "Heart Crystal used");
        this.addSubtitle("player_died", "Somebody died (LOL)");
        this.addDiffMode("average", "Average");
        this.addDiffMode("extrema", "Extrema");
        this.addDiffMode("distance", "Distance");
        this.addDiffMode("distance_and_time", "Distance and Time");
        this.addDiffMode("server_wide", "Server Wide");
        this.noPre("tab", "Scaling Health");
    }

    private void addDiffMode(String post, String translation) {
        this.noPre("modes.difficulty." + post, translation);
    }

    private void addSubtitle(String post, String translation) {
        this.noPre("subtitle." + post, translation);
    }

    private void addItem(String post, String translation) {
        this.add("item", post, translation);
    }

    private void addCommand(String post, String translation) {
        this.add("command", post, translation);
    }

    private void noPre(String post, String translation) {
        this.add("scalinghealth." + post, translation);
    }

    private void noPost(String pre, String translation) {
        this.add(pre + ".scalinghealth", translation);
    }

    private void add(String pre, String post, String translation) {
        this.add(pre + ".scalinghealth." + post, translation);
    }
}

