/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.silentchaos512.scalinghealth.capability.DifficultySourceCapability;
import net.silentchaos512.scalinghealth.capability.IDifficultySource;
import net.silentchaos512.scalinghealth.command.ModCommands;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;

public final class DifficultyCommand {
    private DifficultyCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"sh_difficulty").requires(source -> source.m_6761_(2));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(DifficultyCommand::runGetDifficulty))).then(Commands.m_82127_((String)"server").executes(DifficultyCommand::runGetServerDifficulty))).executes(context -> DifficultyCommand.getDifficultySingle((CommandContext<CommandSourceStack>)context, (Player)((CommandSourceStack)context.getSource()).m_81375_())));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(DifficultyCommand::runSetDifficulty)))).then(Commands.m_82127_((String)"server").then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(DifficultyCommand::runSetServerDifficulty))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(DifficultyCommand::runAddDifficulty)))).then(Commands.m_82127_((String)"server").then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(DifficultyCommand::runAddServerDifficulty))));
        dispatcher.register(builder);
    }

    private static int runGetDifficulty(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
            DifficultyCommand.getDifficultySingle(context, (Player)player);
        }
        return 1;
    }

    private static int getDifficultySingle(CommandContext<CommandSourceStack> context, Player player) {
        IDifficultySource source = SHDifficulty.source((ICapabilityProvider)player);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ModCommands.playerNameText(player), true);
        double maxDifficulty = SHDifficulty.maxValue();
        float difficulty = source.getDifficulty();
        MutableComponent playerValues = ModCommands.valueText(difficulty, maxDifficulty);
        MutableComponent playerText = DifficultyCommand.text("player", playerValues).m_130940_(ChatFormatting.YELLOW);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> playerText, true);
        double areaDifficulty = SHDifficulty.areaDifficulty(player.m_9236_(), player.m_20183_());
        MutableComponent areaValues = ModCommands.valueText(areaDifficulty, maxDifficulty);
        MutableComponent areaText = DifficultyCommand.text("area", areaValues).m_130940_(ChatFormatting.YELLOW);
        MutableComponent modeText = Component.m_237113_((String)" (").m_7220_((Component)Component.m_237115_((String)("scalinghealth.modes.difficulty." + SHDifficulty.areaMode().getName())).m_130940_(ChatFormatting.GRAY)).m_130946_(")");
        areaText.m_7220_((Component)modeText);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> areaText, true);
        return 1;
    }

    private static int runGetServerDifficulty(CommandContext<CommandSourceStack> context) {
        IDifficultySource source = DifficultySourceCapability.getOverworldCap().orElseGet(DifficultySourceCapability::new);
        double difficulty = source.getDifficulty();
        double maxDifficulty = SHDifficulty.maxValue();
        MutableComponent textValues = ModCommands.valueText(difficulty, maxDifficulty);
        MutableComponent textDifficulty = DifficultyCommand.text("server", textValues).m_130940_(ChatFormatting.YELLOW);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> textDifficulty, true);
        return 1;
    }

    private static int runSetDifficulty(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        float amount = FloatArgumentType.getFloat(context, (String)"amount");
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
            SHDifficulty.source((ICapabilityProvider)player).setDifficulty(amount);
        }
        return 1;
    }

    private static int runSetServerDifficulty(CommandContext<CommandSourceStack> context) {
        float amount = FloatArgumentType.getFloat(context, (String)"amount");
        DifficultySourceCapability.getOverworldCap().orElseGet(DifficultySourceCapability::new).setDifficulty(amount);
        return 1;
    }

    private static int runAddDifficulty(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        float amount = FloatArgumentType.getFloat(context, (String)"amount");
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"targets")) {
            SHDifficulty.source((ICapabilityProvider)player).addDifficulty(amount);
        }
        return 1;
    }

    private static int runAddServerDifficulty(CommandContext<CommandSourceStack> context) {
        float amount = FloatArgumentType.getFloat(context, (String)"amount");
        DifficultySourceCapability.getOverworldCap().orElseGet(DifficultySourceCapability::new).addDifficulty(amount);
        return 1;
    }

    private static MutableComponent text(String key, Object ... args) {
        return Component.m_237110_((String)("command.scalinghealth.difficulty." + key), (Object[])args);
    }
}

