/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.client.gui.health;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.scalinghealth.client.gui.health.AbsorptionIconStyle;
import net.silentchaos512.scalinghealth.client.gui.health.HeartIconStyle;
import net.silentchaos512.scalinghealth.config.SHConfig;

class HeartsInfo {
    float health;
    int healthInt;
    int previousHealthInt;
    float maxHealth = 20.0f;
    float absorption;
    int absorptionInt;
    int rowsUsedInHud;
    int rowHeight;
    boolean recentlyHurtHighlight;
    boolean hardcoreMode;
    private final int[] lowHealthBob = new int[10];
    private int regenTimer;
    Supplier<HeartIconStyle> heartStyle;
    Supplier<AbsorptionIconStyle> absorptionStyle;
    private final Random random;
    int scaledWindowWidth;
    int scaledWindowHeight;

    HeartsInfo() {
        this.heartStyle = SHConfig.CLIENT.heartIconStyle;
        this.absorptionStyle = SHConfig.CLIENT.absorptionIconStyle;
        this.random = new Random();
    }

    void update() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        int updateCounter = ClientTicks.ticksInGame();
        this.random.setSeed(updateCounter * 312871);
        this.scaledWindowWidth = mc.m_91268_().m_85445_();
        this.scaledWindowHeight = mc.m_91268_().m_85446_();
        this.health = player.m_21223_();
        this.previousHealthInt = this.healthInt;
        this.healthInt = Mth.m_14167_((float)this.health);
        this.maxHealth = player.m_21233_();
        this.absorption = player.m_6103_();
        this.absorptionInt = Mth.m_14167_((float)this.absorption);
        this.rowsUsedInHud = this.absorptionInt > 0 ? 2 : 1;
        this.rowHeight = this.rowsUsedInHud + 9;
        this.recentlyHurtHighlight = player.f_19802_ / 3 % 2 == 1;
        this.hardcoreMode = player.m_9236_().m_6106_().m_5466_();
        for (int i = 0; i < this.lowHealthBob.length; ++i) {
            this.lowHealthBob[i] = this.random.nextInt(2);
        }
        this.regenTimer = player.m_21023_(MobEffects.f_19605_) ? updateCounter % 20 : -1;
    }

    private boolean hasLowHealth() {
        return this.health <= this.maxHealth / 5.0f;
    }

    int getCustomHeartRowCount(int healthAmount) {
        return this.heartStyle.get() == HeartIconStyle.REPLACE_ALL ? Mth.m_14167_((float)((float)healthAmount / 20.0f)) : healthAmount / 20;
    }

    int getActualRow(int renderRowIndex) {
        return renderRowIndex + (this.heartStyle.get() == HeartIconStyle.REPLACE_ALL ? 0 : 1);
    }

    int getHeartsInRows(int actualRow) {
        return Math.min((this.healthInt - 20 * actualRow) / 2, 10);
    }

    int offsetHeartPosY(int xIndex, int initialY) {
        int y = initialY;
        if (xIndex == this.regenTimer) {
            y -= 2;
        }
        if (this.hasLowHealth()) {
            y += this.lowHealthBob[Mth.m_14045_((int)xIndex, (int)0, (int)(this.lowHealthBob.length - 1))];
        }
        return y;
    }

    int offsetAbsorptionPosY(int xIndex, int initialY) {
        int y = initialY - 10;
        if (xIndex == this.regenTimer - 10) {
            y -= 2;
        }
        return y;
    }

    int getHeartTanks() {
        return this.healthInt / 20;
    }

    int getMaxHeartTanks() {
        return (int)this.maxHealth / 20;
    }

    int getHeartTankRowCount() {
        return Mth.m_14167_((float)((float)this.getHeartTanks() / 20.0f));
    }

    int getMaxHeartTankRowCount() {
        return Mth.m_14167_((float)((float)this.getMaxHeartTanks() / 20.0f));
    }

    int getFilledHeartTanksInRow(int row) {
        return Math.min(this.getHeartTanks() - 20 * row, 20);
    }

    int getAllHeartTanksInRow(int row) {
        return Math.min(this.getMaxHeartTanks() - 20 * row, 20);
    }
}

