/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.client.gui.health;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.scalinghealth.client.gui.TextureSlice;
import net.silentchaos512.scalinghealth.client.gui.health.AbsorptionIconStyle;
import net.silentchaos512.scalinghealth.client.gui.health.HealthTextColor;
import net.silentchaos512.scalinghealth.client.gui.health.HealthTextStyle;
import net.silentchaos512.scalinghealth.client.gui.health.HeartIconStyle;
import net.silentchaos512.scalinghealth.client.gui.health.HeartsInfo;
import net.silentchaos512.scalinghealth.config.SHConfig;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.MathUtils;

public final class HeartDisplayHandler
extends Screen {
    public static final HeartDisplayHandler INSTANCE = new HeartDisplayHandler((Component)Component.m_237119_());
    private static final float COLOR_CHANGE_PERIOD = 150.0f;
    private static final ResourceLocation VANILLA_ICONS = new ResourceLocation("textures/gui/icons.png");
    private static final ResourceLocation SH_ICONS = new ResourceLocation("scalinghealth", "textures/gui/hud.png");
    private static final TextureSlice TANK_SHINE = new TextureSlice(SH_ICONS, 44, 0, 5, 5);
    private static final TextureSlice TANK_OUTLINE = new TextureSlice(SH_ICONS, 44, 5, 5, 5);
    private static final TextureSlice TANK_FULL = new TextureSlice(SH_ICONS, 44, 10, 5, 5);
    private static final TextureSlice TANK_EMPTY = new TextureSlice(SH_ICONS, 44, 15, 5, 5);
    private final HeartsInfo info = new HeartsInfo();

    private HeartDisplayHandler(Component title) {
        super(title);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onHealthBar(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() != VanillaGuiOverlay.PLAYER_HEALTH.type()) {
            return;
        }
        if (this.info.heartStyle.get() == HeartIconStyle.VANILLA) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.f_91072_.m_105295_().m_46409_()) {
            if (SHConfig.CLIENT.healthTextStyle.get() != HealthTextStyle.DISABLED) {
                mc.m_91307_().m_6180_("scalinghealthRenderHealthText");
                this.renderHealthText(mc, event.getGuiGraphics(), this.info.health, this.info.maxHealth, -91 + (Integer)SHConfig.CLIENT.healthTextOffsetX.get(), -38 + (Integer)SHConfig.CLIENT.healthTextOffsetY.get(), (HealthTextStyle)((Object)SHConfig.CLIENT.healthTextStyle.get()), (HealthTextColor)((Object)SHConfig.CLIENT.healthTextColorStyle.get()));
                mc.m_91307_().m_7238_();
            }
            if (SHConfig.CLIENT.absorptionTextStyle.get() != HealthTextStyle.DISABLED && player.m_6103_() > 0.0f) {
                mc.m_91307_().m_6180_("scalinghealthRenderAbsorptionText");
                this.renderHealthText(mc, event.getGuiGraphics(), player.m_6103_(), 0.0f, -91 + (Integer)SHConfig.CLIENT.absorptionTextOffsetX.get(), -49 + (Integer)SHConfig.CLIENT.absorptionTextOffsetY.get(), (HealthTextStyle)((Object)SHConfig.CLIENT.absorptionTextStyle.get()), HealthTextColor.SOLID);
                mc.m_91307_().m_7238_();
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onHealthDraw(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() != VanillaGuiOverlay.PLAYER_HEALTH.type() || this.info.heartStyle.get() == HeartIconStyle.VANILLA || Minecraft.m_91087_().f_91066_.f_92062_ || !HeartDisplayHandler.getGui().shouldDrawSurvivalElements()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        event.setCanceled(true);
        mc.m_91307_().m_6180_("scalinghealthRenderHearts");
        this.renderHearts((RenderGuiOverlayEvent)event, mc, (Player)player);
        mc.m_91307_().m_7238_();
    }

    private void renderHearts(RenderGuiOverlayEvent event, Minecraft mc, Player player) {
        AbsorptionIconStyle absorptionIconStyle;
        boolean anythingDrawn;
        int y;
        GuiGraphics graphics = event.getGuiGraphics();
        this.info.update();
        RenderSystem.enableBlend();
        float absorb = Mth.m_14167_((float)player.m_6103_());
        int left = this.info.scaledWindowWidth / 2 - 91;
        int top = this.info.scaledWindowHeight - HeartDisplayHandler.getGui().leftHeight;
        HeartDisplayHandler.getGui().leftHeight += this.info.rowsUsedInHud * this.info.rowHeight;
        if (this.info.rowHeight != 10) {
            HeartDisplayHandler.getGui().leftHeight += 10 - this.info.rowHeight;
        }
        this.drawVanillaElements(graphics, left, top);
        int potionOffset = this.info.hardcoreMode ? 27 : 0;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SH_ICONS);
        int rowCount = this.info.getCustomHeartRowCount(this.info.healthInt);
        int maxHealthRows = this.info.getCustomHeartRowCount((int)player.m_21233_());
        for (int row = Math.max(0, rowCount - 2); row < rowCount; ++row) {
            int y2;
            boolean anythingDrawn2;
            int j;
            int actualRow = this.info.getActualRow(row);
            int renderHearts = this.info.getHeartsInRows(actualRow);
            int rowColor = HeartDisplayHandler.getColorForRow(row, false);
            for (j = 0; j < renderHearts; ++j) {
                y = this.info.offsetHeartPosY(j, top);
                this.blitWithColor(graphics, left + 8 * j, y, 0, potionOffset, 9, 9, rowColor);
            }
            boolean bl = anythingDrawn2 = j > 0;
            if (this.info.healthInt % 2 == 1 && renderHearts < 10) {
                y2 = this.info.offsetHeartPosY(j, top);
                this.blitWithColor(graphics, left + 8 * renderHearts, y2, 9, potionOffset, 9, 9, rowColor);
                anythingDrawn2 = true;
            }
            if (!((Boolean)SHConfig.CLIENT.lastHeartOutline.get()).booleanValue() || !anythingDrawn2 || row != maxHealthRows - 1) continue;
            j = (int)Math.ceil(player.m_21233_() % 20.0f / 2.0f) - 1;
            if (j < 0) {
                j += 10;
            }
            y2 = this.info.offsetHeartPosY(j, top);
            int color = (Integer)SHConfig.CLIENT.lastHeartOutlineColor.get();
            this.blitWithColor(graphics, left + 8 * j, y2, 17, 9, 9, 9, color);
        }
        for (int i = 0; i < 10 && (double)i < Math.ceil((float)this.info.healthInt / 2.0f); ++i) {
            int y3 = this.info.offsetHeartPosY(i, top);
            if (HeartDisplayHandler.showEffectHearts(player)) {
                int color = HeartDisplayHandler.effectHeartColor(player);
                this.blitWithColor(graphics, left + 8 * i, y3, 0, 54, 9, 9, color);
            }
            if (this.info.hardcoreMode) continue;
            this.blitWithColor(graphics, left + 8 * i, y3, 17, 0, 9, 9, -855638017);
        }
        if (this.info.getMaxHeartTanks() > 0 && ((Boolean)SHConfig.CLIENT.heartTanks.get()).booleanValue()) {
            int tankRows = this.info.getHeartTankRowCount();
            int maxTankRows = this.info.getMaxHeartTankRowCount();
            for (int row = 0; row < maxTankRows; ++row) {
                int x;
                int filledTanksInRow = this.info.getFilledHeartTanksInRow(row);
                int allTanksInRow = this.info.getAllHeartTanksInRow(row);
                int rowColor = HeartDisplayHandler.getColorForRow(row, false);
                top -= 4;
                HeartDisplayHandler.getGui().leftHeight += 4;
                for (x = 0; x < allTanksInRow; ++x) {
                    if (x < filledTanksInRow) {
                        TANK_FULL.blit(graphics, left + 4 * x, top, rowColor);
                        continue;
                    }
                    TANK_EMPTY.blit(graphics, left + 4 * x, top, 0xFFFFFF);
                }
                boolean bl = anythingDrawn = x > 0;
                if (!((Boolean)SHConfig.CLIENT.lastHeartOutline.get()).booleanValue() || !anythingDrawn || row != maxTankRows - 1) continue;
                x = (int)Math.ceil(allTanksInRow) - 1;
                if (x < 0) {
                    x += 20;
                }
                TANK_OUTLINE.blit(graphics, left + 4 * x, top, (Integer)SHConfig.CLIENT.lastHeartOutlineColor.get());
            }
        }
        if ((absorptionIconStyle = (AbsorptionIconStyle)((Object)SHConfig.CLIENT.absorptionIconStyle.get())) != AbsorptionIconStyle.VANILLA) {
            int i;
            int absorbCeil = (int)Math.ceil(absorb);
            rowCount = (int)Math.ceil(absorb / 20.0f);
            int texX = 17;
            int texY = absorptionIconStyle == AbsorptionIconStyle.SHIELD ? 45 : 54;
            for (i = 0; i < 10 && (float)i < absorb / 2.0f; ++i) {
                y = this.info.offsetAbsorptionPosY(i, top);
                this.blitWithColor(graphics, left + 8 * i, y, texX, texY, 9, 9, 0xFFFFFF);
            }
            texX = absorptionIconStyle == AbsorptionIconStyle.SHIELD ? 26 : 0;
            texY = absorptionIconStyle == AbsorptionIconStyle.SHIELD ? 0 : potionOffset;
            for (i = Math.max(0, rowCount - 2); i < rowCount; ++i) {
                int y4;
                int x;
                int renderHearts = Math.min((absorbCeil - 20 * i) / 2, 10);
                int rowColor = HeartDisplayHandler.getColorForRow(i, true);
                for (x = 0; x < renderHearts; ++x) {
                    y4 = this.info.offsetAbsorptionPosY(x, top);
                    this.blitWithColor(graphics, left + 8 * x, y4, texX, texY, 9, 9, rowColor);
                }
                boolean bl = anythingDrawn = x > 0;
                if (absorbCeil % 2 != 1 || renderHearts >= 10) continue;
                y4 = this.info.offsetAbsorptionPosY(x, top);
                this.blitWithColor(graphics, left + 8 * renderHearts, y4, texX + 9, texY, 9, 9, rowColor);
                anythingDrawn = true;
            }
            for (i = 0; i < 10 && (float)i < absorb / 2.0f; ++i) {
                y = this.info.offsetAbsorptionPosY(i, top);
                if (absorptionIconStyle == AbsorptionIconStyle.SHIELD) {
                    this.blitWithColor(graphics, left + 8 * i, y, 17, 36, 9, 9, 0xFFFFFF);
                } else if (absorptionIconStyle == AbsorptionIconStyle.GOLD_OUTLINE) {
                    this.blitWithColor(graphics, left + 8 * i, y, 17, 27, 9, 9, 0xFFFFFF);
                }
                if (this.info.hardcoreMode && absorptionIconStyle != AbsorptionIconStyle.SHIELD) continue;
                this.blitWithColor(graphics, left + 8 * i, y, 17, 0, 9, 9, -855638017);
            }
        }
    }

    private void drawVanillaElements(GuiGraphics graphics, int left, int top) {
        int iStart;
        int textureX = this.info.recentlyHurtHighlight ? 25 : 16;
        int textureY = 9 * (this.info.hardcoreMode ? 5 : 0);
        int margin = 16;
        float healthMax = Math.min(this.info.maxHealth, 20.0f);
        float absorbRemaining = this.info.absorption;
        float healthTotal = this.info.healthInt + this.info.absorptionInt;
        for (int i = iStart = Mth.m_14167_((float)((healthMax + (float)(this.info.absorptionStyle.get() == AbsorptionIconStyle.VANILLA ? this.info.absorptionInt : 0)) / 2.0f)) - 1; i >= 0; --i) {
            int row = Mth.m_14167_((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = this.info.offsetHeartPosY(i, top - row * this.info.rowHeight);
            graphics.m_280218_(VANILLA_ICONS, x, y, textureX, textureY, 9, 9);
            if (this.info.recentlyHurtHighlight) {
                if (i * 2 + 1 < this.info.previousHealthInt) {
                    graphics.m_280218_(VANILLA_ICONS, x, y, margin + 54, textureY, 9, 9);
                } else if (i * 2 + 1 == this.info.previousHealthInt) {
                    graphics.m_280218_(VANILLA_ICONS, x, y, margin + 63, textureY, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f && this.info.absorptionStyle.get() == AbsorptionIconStyle.VANILLA) {
                if (MathUtils.doublesEqual((double)absorbRemaining, (double)this.info.absorption) && MathUtils.doublesEqual((double)(this.info.absorption % 2.0f), (double)1.0)) {
                    graphics.m_280218_(VANILLA_ICONS, x, y, margin + 153, textureY, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                if ((float)(i * 2 + 1) < healthTotal) {
                    graphics.m_280218_(VANILLA_ICONS, x, y, margin + 144, textureY, 9, 9);
                }
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < this.info.healthInt) {
                graphics.m_280218_(VANILLA_ICONS, x, y, margin + 36, textureY, 9, 9);
                continue;
            }
            if (i * 2 + 1 != this.info.healthInt) continue;
            graphics.m_280218_(VANILLA_ICONS, x, y, margin + 45, textureY, 9, 9);
        }
    }

    private void renderHealthText(Minecraft mc, GuiGraphics graphics, float current, float max, int offsetX, int offsetY, HealthTextStyle style, HealthTextColor styleColor) {
        float scale = (float)style.getScale();
        int left = (int)((float)(this.info.scaledWindowWidth / 2 + offsetX) / scale);
        int top = (int)(((float)(this.info.scaledWindowHeight + offsetY) + 1.0f / scale) / scale);
        mc.m_91307_().m_6180_("shTextPreDraw");
        String healthString = style.textFor(current, max);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int stringWidth = fontRenderer.m_92895_(healthString);
        float divisor = max == 0.0f ? current : max;
        int color = switch (styleColor) {
            case HealthTextColor.TRANSITION -> Color.blend((int)((Integer)SHConfig.CLIENT.healthTextEmptyColor.get()), (int)((Integer)SHConfig.CLIENT.healthTextFullColor.get()), (float)(current / divisor));
            case HealthTextColor.PSYCHEDELIC -> java.awt.Color.HSBtoRGB((float)ClientTicks.ticksInGame() % 150.0f / 150.0f, 0.55f * current / divisor, 1.0f);
            default -> (Integer)SHConfig.CLIENT.healthTextFullColor.get();
        };
        mc.m_91307_().m_7238_();
        mc.m_91307_().m_6180_("shTextDraw");
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        stack.m_85841_(scale, scale, 1.0f);
        graphics.m_280488_(this.f_96547_, healthString, left - stringWidth - 2, top, color);
        stack.m_85849_();
        mc.m_91307_().m_7238_();
    }

    private void blitWithColor(GuiGraphics graphics, int x, int y, int textureX, int textureY, int width, int height, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a <= 0.0f) {
            a = 1.0f;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        graphics.m_280246_(r, g, b, a);
        graphics.m_280218_(SH_ICONS, x, y, textureX, textureY, width, height);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static int getColorForRow(int row, boolean absorption) {
        List<Integer> colors = absorption ? SHConfig.CLIENT.absorptionHeartColors.get() : SHConfig.CLIENT.heartColors.get();
        int index = (Boolean)SHConfig.CLIENT.heartColorLooping.get() != false ? row % colors.size() : MathUtils.clamp((int)row, (int)0, (int)(colors.size() - 1));
        return colors.get(index);
    }

    private static boolean showEffectHearts(Player player) {
        return player.m_21023_(MobEffects.f_19614_) || player.m_21023_(MobEffects.f_19615_);
    }

    private static int effectHeartColor(Player player) {
        if (player.m_21023_(MobEffects.f_19615_)) {
            return 6700615;
        }
        if (player.m_21023_(MobEffects.f_19614_)) {
            return 5149489;
        }
        return 0xFFFFFF;
    }

    public static ForgeGui getGui() {
        return (ForgeGui)Minecraft.m_91087_().f_91065_;
    }
}

