/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.client.gui.health;

import net.silentchaos512.scalinghealth.config.SHConfig;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HealthTextStyle {
    DISABLED(1.0f){

        @Override
        public String textFor(float current, float max) {
            return "";
        }
    }
    ,
    ROWS(0.65f){

        @Override
        public String textFor(float current, float max) {
            return (int)Math.ceil(current / 20.0f) + "x";
        }
    }
    ,
    HEALTH_AND_MAX(0.5f){

        @Override
        public String textFor(float current, float max) {
            if (max == 0.0f) {
                return HEALTH_ONLY.textFor(current, max);
            }
            return Math.round(current) + "/" + Math.round(max);
        }
    }
    ,
    HEALTH_ONLY(0.5f){

        @Override
        public String textFor(float current, float max) {
            return String.valueOf(Math.round(current));
        }
    };

    private final float scale;

    private HealthTextStyle(float scale) {
        this.scale = scale;
    }

    public abstract String textFor(float var1, float var2);

    public double getScale() {
        return (double)this.scale * (Double)SHConfig.CLIENT.healthTextScale.get();
    }
}

