/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.MathUtils;

public class ColoredParticle
extends SingleQuadParticle {
    private static final List<ResourceLocation> TEXTURES = IntStream.range(0, 4).boxed().map(k -> new ResourceLocation("scalinghealth", "textures/particle/generic" + k + ".png")).collect(Collectors.toList());
    private static final int[] FRAMES = new int[]{0, 1, 2, 3, 2, 1, 0};

    public ColoredParticle(ClientLevel worldIn, Color color, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.f_107225_ = 16;
        this.f_107219_ = false;
        this.m_107253_(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void m_5744_(VertexConsumer builder, Camera info, float v) {
        int frame = FRAMES.length * this.f_107224_ / this.f_107225_;
        int textureIndex = FRAMES[MathUtils.clamp((int)frame, (int)0, (int)(FRAMES.length - 1))];
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURES.get(textureIndex));
        super.m_5744_(builder, info, v);
    }

    protected float m_5970_() {
        return 0.0f;
    }

    protected float m_5952_() {
        return 1.0f;
    }

    protected float m_5951_() {
        return 0.0f;
    }

    protected float m_5950_() {
        return 1.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public record Factory(Color color) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ColoredParticle(worldIn, this.color, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

