/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.capability.IDifficultySource;
import net.silentchaos512.scalinghealth.capability.IPlayerData;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;

public class PlayerDataCapability
implements IPlayerData,
ICapabilitySerializable<CompoundTag> {
    public static Capability<IPlayerData> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerData>(){});
    public static ResourceLocation NAME = ScalingHealth.getId("player_data");
    private static final String NBT_HEART_CRYSTALS = "HeartCrystals";
    private static final String NBT_POWER_CRYSTALS = "PowerCrystals";
    private final LazyOptional<IPlayerData> holder = LazyOptional.of(() -> this);
    private boolean afk = false;
    private int timeAfk = 0;
    private BlockPos lastPos;
    private int heartCrystals;
    private int powerCrystals;

    @Override
    public int getBonusHearts(Player player) {
        return SHPlayers.clampedHpFromHeartCrystals(this.getHeartCrystals()) + SHPlayers.fullHeartsFromXp(player.f_36078_);
    }

    @Override
    public int getHeartCrystals() {
        return this.heartCrystals;
    }

    @Override
    public void setHeartCrystals(Player player, int amount) {
        this.heartCrystals = SHPlayers.clampExtraHearts(amount);
        ModifierHandler.setMaxHealth((LivingEntity)player, this.getModifiedHealth(player), AttributeModifier.Operation.ADDITION);
    }

    @Override
    public int getPowerCrystals() {
        return this.powerCrystals;
    }

    @Override
    public void setPowerCrystalCount(Player player, int amount) {
        this.powerCrystals = SHPlayers.clampPowerCrystals(amount);
        ModifierHandler.addAttackDamage((LivingEntity)player, this.getAttackDamageModifier(), AttributeModifier.Operation.ADDITION);
    }

    @Override
    public void updateStats(Player player) {
        ModifierHandler.setMaxHealth((LivingEntity)player, this.getModifiedHealth(player), AttributeModifier.Operation.ADDITION);
        ModifierHandler.addAttackDamage((LivingEntity)player, this.getAttackDamageModifier(), AttributeModifier.Operation.ADDITION);
    }

    @Override
    public void tick(Player player) {
        if (player.m_9236_().m_46467_() % 20L == 0L && !player.m_9236_().f_46443_) {
            this.checkPlayerIdle(player);
            if (player instanceof ServerPlayer) {
                IPlayerData.sendUpdatePacketTo(player);
            }
        }
    }

    private void checkPlayerIdle(Player player) {
        if (SHDifficulty.areaDifficulty(player.m_9236_(), player.m_20183_()) >= SHDifficulty.maxValue()) {
            return;
        }
        if (player.m_20183_().equals((Object)this.lastPos)) {
            ++this.timeAfk;
        } else {
            this.afk = false;
            this.timeAfk = 0;
        }
        this.lastPos = player.m_20183_();
        if ((double)this.timeAfk > SHDifficulty.timeBeforeAfk() && !this.afk) {
            this.afk = true;
            if (SHDifficulty.afkMessage()) {
                player.m_213846_((Component)Component.m_237115_((String)"misc.scalinghealth.afkmessage"));
            }
        }
        if (this.afk) {
            IDifficultySource data = SHDifficulty.source((ICapabilityProvider)player);
            float changePerSec = (float)SHDifficulty.changePerSecond();
            data.addDifficulty(-changePerSec * (float)(1.0 - SHDifficulty.idleModifier()));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.holder);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_HEART_CRYSTALS, this.heartCrystals);
        nbt.m_128405_(NBT_POWER_CRYSTALS, this.powerCrystals);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.heartCrystals = nbt.m_128451_(NBT_HEART_CRYSTALS);
        this.powerCrystals = nbt.m_128451_(NBT_POWER_CRYSTALS);
    }

    public static boolean canAttachTo(ICapabilityProvider entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        try {
            if (entity.getCapability(INSTANCE).isPresent()) {
                return false;
            }
        }
        catch (NullPointerException ex) {
            ScalingHealth.LOGGER.error("Failed to get capabilities from {}", (Object)entity);
            return false;
        }
        return true;
    }
}

