/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.capability;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkDirection;
import net.silentchaos512.scalinghealth.event.PlayerBonusRegenHandler;
import net.silentchaos512.scalinghealth.network.ClientSyncMessage;
import net.silentchaos512.scalinghealth.network.Network;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.config.SHItems;
import net.silentchaos512.scalinghealth.utils.config.SHPlayers;

public interface IPlayerData {
    public int getBonusHearts(Player var1);

    public int getHeartCrystals();

    public void setHeartCrystals(Player var1, int var2);

    public int getPowerCrystals();

    public void setPowerCrystalCount(Player var1, int var2);

    public void updateStats(Player var1);

    public void tick(Player var1);

    default public void addHeartCrystals(Player player, int amount) {
        this.setHeartCrystals(player, this.getHeartCrystals() + amount);
    }

    default public void addPowerCrystal(Player player) {
        this.setPowerCrystalCount(player, this.getPowerCrystals() + 1);
    }

    default public void addPowerCrystals(Player player, int amount) {
        this.setPowerCrystalCount(player, this.getPowerCrystals() + amount);
    }

    default public int getModifiedHealth(Player player) {
        return 2 * SHPlayers.clampExtraHearts(this.getBonusHearts(player)) + SHPlayers.startingHealth() - 20;
    }

    default public double getAttackDamageModifier() {
        return (double)this.getPowerCrystals() * SHItems.powerCrystalIncreaseAmount();
    }

    public static void sendUpdatePacketTo(Player player) {
        Level world = player.m_9236_();
        BlockPos pos = player.m_20183_();
        ClientSyncMessage msg = new ClientSyncMessage(SHDifficulty.source((ICapabilityProvider)player).getDifficulty(), SHDifficulty.source((ICapabilityProvider)world).getDifficulty(), (float)SHDifficulty.areaDifficulty(world, pos), PlayerBonusRegenHandler.getTimerForPlayer(player), SHDifficulty.locationMultiplier(world, pos), player.f_36078_);
        ServerPlayer playerMP = (ServerPlayer)player;
        Network.channel.sendTo((Object)msg, playerMP.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

