/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.capability.IDifficultyAffected;
import net.silentchaos512.scalinghealth.config.SHConfig;
import net.silentchaos512.scalinghealth.event.DifficultyEvents;
import net.silentchaos512.scalinghealth.utils.MobDifficultyHandler;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;
import net.silentchaos512.scalinghealth.utils.config.SHMobs;

public class DifficultyAffectedCapability
implements IDifficultyAffected,
ICapabilitySerializable<CompoundTag> {
    public static Capability<IDifficultyAffected> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDifficultyAffected>(){});
    public static ResourceLocation NAME = ScalingHealth.getId("difficulty_affected");
    private static final String NBT_BLIGHT = "Blight";
    private static final String NBT_DIFFICULTY = "Difficulty";
    private final LazyOptional<IDifficultyAffected> holder = LazyOptional.of(() -> this);
    private float difficulty;
    private boolean blight;
    private boolean processed;

    @Override
    public float getDifficulty() {
        return this.difficulty;
    }

    @Override
    public void setDifficulty(Mob mob) {
        this.difficulty = (float)((Math.random() * 0.1 + 0.95) * SHDifficulty.areaDifficulty(mob.m_9236_(), mob.m_20183_()));
    }

    @Override
    public void forceDifficulty(float diff) {
        this.difficulty = diff;
    }

    @Override
    public boolean isBlight() {
        return this.blight;
    }

    @Override
    public void setIsBlight(boolean value) {
        this.blight = value;
    }

    @Override
    public void setProcessed(boolean value) {
        this.processed = value;
    }

    @Override
    public void tick(Mob entity) {
        if (!this.processed && entity.m_6084_() && entity.f_19797_ > 2) {
            this.setDifficulty(entity);
            MobDifficultyHandler.process(entity, this);
            this.processed = true;
            if (ScalingHealth.LOGGER.isDebugEnabled() && SHConfig.SERVER.debugLogEntitySpawns.get().booleanValue()) {
                ScalingHealth.LOGGER.debug(DifficultyEvents.MARKER, "Processed {} -> difficulty={}, isBlight={}", (Object)entity, (Object)Float.valueOf(this.difficulty), (Object)this.blight);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.holder);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_(NBT_BLIGHT, this.blight);
        nbt.m_128350_(NBT_DIFFICULTY, this.difficulty);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.blight = nbt.m_128471_(NBT_BLIGHT);
        this.difficulty = nbt.m_128457_(NBT_DIFFICULTY);
    }

    public static boolean canAttachTo(ICapabilityProvider entity) {
        return entity instanceof Mob && !entity.getCapability(INSTANCE).isPresent() && SHMobs.allowsDifficultyChanges((Mob)entity);
    }
}

