/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.server.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import endorh.aerobaticelytra.server.loot.AerobaticLootConditions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class SubmergedLootCondition
implements LootItemCondition {
    protected final TagKey<Fluid> fluidTag;

    public SubmergedLootCondition(TagKey<Fluid> fluidTag) {
        this.fluidTag = fluidTag;
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return AerobaticLootConditions.SUBMERGED;
    }

    public boolean test(LootContext lootContext) {
        return ((Entity)lootContext.m_78953_(LootContextParams.f_81455_)).m_204029_(this.fluidTag);
    }

    public static class ConditionSerializer
    implements Serializer<SubmergedLootCondition> {
        public void serialize(@NotNull JsonObject json, @NotNull SubmergedLootCondition condition, @NotNull JsonSerializationContext context) {
            json.add("fluid", (JsonElement)new JsonPrimitive(condition.fluidTag.f_203868_().toString()));
        }

        @NotNull
        public SubmergedLootCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            ResourceLocation fluid = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"fluid", (String)"water"));
            TagKey fluidTag = FluidTags.create((ResourceLocation)fluid);
            return new SubmergedLootCondition((TagKey<Fluid>)fluidTag);
        }
    }
}

