/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.server.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.server.loot.AerobaticLootFunctions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class SetAbilitiesLootFunction
extends LootItemConditionalFunction {
    private final Map<IAbility, Float> abilities;
    private final Map<String, Float> unknown;

    protected SetAbilitiesLootFunction(LootItemCondition[] conditionsIn, Map<IAbility, Float> abilities, Map<String, Float> unknown) {
        super(conditionsIn);
        this.abilities = abilities;
        this.unknown = unknown;
    }

    @NotNull
    protected ItemStack m_7372_(@NotNull ItemStack stack, @NotNull LootContext context) {
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(stack);
        spec.putAbilities(this.abilities);
        spec.getUnknownAbilities().putAll(this.unknown);
        return stack;
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return AerobaticLootFunctions.SET_ABILITIES;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Map<IAbility, Float> abilities = new HashMap<IAbility, Float>();
        private final Map<String, Float> unknown = new HashMap<String, Float>();

        @NotNull
        protected Builder getThis() {
            return this;
        }

        public void setAbility(String name, double value) {
            if (IAbility.isDefined(name)) {
                IAbility ability = IAbility.fromName(name);
                this.abilities.put(ability, Float.valueOf((float)value));
            } else {
                this.unknown.put(name, Float.valueOf((float)value));
            }
        }

        @NotNull
        public LootItemFunction m_7453_() {
            return new SetAbilitiesLootFunction(this.m_80699_(), this.abilities, this.unknown);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetAbilitiesLootFunction> {
        @NotNull
        public SetAbilitiesLootFunction deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext deserializationContext, LootItemCondition @NotNull [] conditionsIn) {
            HashMap<IAbility, Float> abilities = new HashMap<IAbility, Float>();
            HashMap<String, Float> unknown = new HashMap<String, Float>();
            for (Map.Entry entry : json.entrySet()) {
                String name = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if ("function".equals(name)) continue;
                if (!value.isJsonPrimitive()) {
                    throw new JsonSyntaxException("Ability values must be numbers");
                }
                JsonPrimitive val = value.getAsJsonPrimitive();
                if (!val.isNumber()) {
                    throw new JsonSyntaxException("Ability values must be numbers");
                }
                float v = val.getAsFloat();
                if (IAbility.isDefined(name)) {
                    abilities.put(IAbility.fromName(name), Float.valueOf(v));
                    continue;
                }
                unknown.put(name, Float.valueOf(v));
            }
            return new SetAbilitiesLootFunction(conditionsIn, abilities, unknown);
        }
    }
}

