/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.server.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import endorh.aerobaticelytra.server.loot.AerobaticLootConditions;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class OriginDistanceLootCondition
implements LootItemCondition {
    protected final double minDistance;
    protected final double maxDistance;

    public OriginDistanceLootCondition(double minDistance, double maxDistance) {
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return AerobaticLootConditions.ORIGIN_DISTANCE;
    }

    public boolean test(LootContext lootContext) {
        Vec3 position = (Vec3)lootContext.m_78953_(LootContextParams.f_81460_);
        if (position == null) {
            throw new IllegalStateException("Cannot use 'origin_distance' loot condition in this loot table type");
        }
        Vec3 flatPosition = position.m_82492_(0.0, position.f_82480_, 0.0);
        double distance = flatPosition.m_82554_(Vec3.f_82478_);
        return this.minDistance < distance && distance < this.maxDistance;
    }

    public static class ConditionSerializer
    implements Serializer<OriginDistanceLootCondition> {
        public void serialize(@NotNull JsonObject json, @NotNull OriginDistanceLootCondition condition, @NotNull JsonSerializationContext serializationContext) {
            if (condition.minDistance > 0.0) {
                json.add("min", (JsonElement)new JsonPrimitive((Number)condition.minDistance));
            }
            if (condition.maxDistance != Double.POSITIVE_INFINITY) {
                json.add("max", (JsonElement)new JsonPrimitive((Number)condition.maxDistance));
            }
        }

        @NotNull
        public OriginDistanceLootCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext deserializationContext) {
            double minDistance = 0.0;
            double maxDistance = Double.POSITIVE_INFINITY;
            if (json.has("min")) {
                JsonElement min = json.get("min");
                if (!min.isJsonPrimitive() || !min.getAsJsonPrimitive().isNumber()) {
                    throw new JsonSyntaxException("'min' distance must be a number");
                }
                minDistance = min.getAsDouble();
            }
            if (json.has("max")) {
                JsonElement max = json.get("max");
                if (!max.isJsonPrimitive() || !max.getAsJsonPrimitive().isNumber()) {
                    throw new JsonSyntaxException("'max' distance must be a number");
                }
                maxDistance = max.getAsDouble();
            }
            return new OriginDistanceLootCondition(minDistance, maxDistance);
        }
    }
}

