/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.server.loot;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.server.loot.AerobaticFlyingLootCondition;
import endorh.aerobaticelytra.server.loot.ElytraFlyingLootCondition;
import endorh.aerobaticelytra.server.loot.OriginDistanceLootCondition;
import endorh.aerobaticelytra.server.loot.SubmergedLootCondition;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
public class AerobaticLootConditions {
    public static LootItemConditionType ORIGIN_DISTANCE;
    public static LootItemConditionType AEROBATIC_FLYING;
    public static LootItemConditionType ELYTRA_FLYING;
    public static LootItemConditionType SUBMERGED;

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        AerobaticLootConditions.register();
        AerobaticElytra.logRegistered("Loot conditions");
    }

    public static void register() {
        ORIGIN_DISTANCE = AerobaticLootConditions.register("origin_distance", new OriginDistanceLootCondition.ConditionSerializer());
        AEROBATIC_FLYING = AerobaticLootConditions.register("aerobatic_flying", new AerobaticFlyingLootCondition.ConditionSerializer());
        ELYTRA_FLYING = AerobaticLootConditions.register("elytra_flying", new ElytraFlyingLootCondition.ConditionSerializer());
        SUBMERGED = AerobaticLootConditions.register("submerged", new SubmergedLootCondition.ConditionSerializer());
    }

    public static LootItemConditionType register(String name, Serializer<? extends LootItemCondition> serializer) {
        return (LootItemConditionType)Registry.m_122965_((Registry)BuiltInRegistries.f_256991_, (ResourceLocation)AerobaticElytra.prefix(name), (Object)new LootItemConditionType(serializer));
    }
}

