/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.server.command;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.AerobaticElytraWingItem;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import endorh.aerobaticelytra.debug.Debug;
import endorh.aerobaticelytra.network.DebugPackets;
import endorh.lazulib.command.QualifiedNameArgumentType;
import endorh.lazulib.text.TextUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class AerobaticElytraCommand {
    private static final String DATAPACK_LOCATION = "datapacks";
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_PACKS = (context, builder) -> SharedSuggestionProvider.m_82981_(AerobaticElytraCommand.getAvailablePacks((CommandSourceStack)context.getSource()).values().stream().filter(bd -> !AerobaticElytraCommand.isPackInstalled((CommandSourceStack)context.getSource(), bd.getTitle())).map(bd -> StringArgumentType.escapeIfRequired((String)bd.getTitle())), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_ABILITIES = (context, builder) -> SharedSuggestionProvider.m_82970_(AerobaticElytraRegistries.getAbilitiesByName().keySet(), (SuggestionsBuilder)builder);
    public static final SimpleCommandExceptionType NO_ELYTRA_HOLDING_TARGETS = new SimpleCommandExceptionType((Message)TextUtil.ttc((String)"commands.aerobaticelytra.error.no_elytra", (Object[])new Object[0]));
    public static final SimpleCommandExceptionType UNKNOWN_ABILITY = new SimpleCommandExceptionType((Message)TextUtil.ttc((String)"commands.aerobaticelytra.error.unknown_ability", (Object[])new Object[0]));
    private static final Logger LOGGER = LogManager.getLogger();
    public static String packPrefix = "aerobaticelytra - ";
    private static final Pattern PACK_MCMETA_PATH_PATTERN = Pattern.compile("^datapacks/[\\w_-]++/pack\\.mcmeta$");

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        AerobaticElytraCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder aerobaticElytraCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"aerobaticelytra").requires(cs -> cs.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"datapack").then(Commands.m_82127_((String)"install").then(Commands.m_82129_((String)"datapack", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_PACKS).executes(cc -> AerobaticElytraCommand.installPack((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"datapack")))))).then(Commands.m_82127_((String)"list").executes(AerobaticElytraCommand::listPacks)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"show").executes(AerobaticElytraCommand.debug((cc, d) -> {
            d.enabled = true;
        })))).then(Commands.m_82127_((String)"hide").executes(AerobaticElytraCommand.debug((cc, d) -> {
            d.enabled = false;
        })))).then(Commands.m_82127_((String)"give").executes(AerobaticElytraCommand::giveDebugWing))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"particles").then(Commands.m_82127_((String)"show").executes(AerobaticElytraCommand.debug((cc, d) -> {
            d.suppressParticles = false;
        })))).then(Commands.m_82127_((String)"hide").executes(AerobaticElytraCommand.debug((cc, d) -> {
            d.suppressParticles = true;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"speed").then(Commands.m_82127_((String)"freeze").then(Commands.m_82129_((String)"speed", (ArgumentType)FloatArgumentType.floatArg()).suggests((s, b) -> b.suggest("1").buildFuture()).executes(AerobaticElytraCommand.debug((cc, d) -> {
            d.freezeParticleSpeed = FloatArgumentType.getFloat((CommandContext)cc, (String)"speed");
        }))))).then(Commands.m_82127_((String)"normal").then(Commands.m_82129_((String)"speed", (ArgumentType)FloatArgumentType.floatArg()).suggests((s, b) -> b.suggest("0.1").buildFuture()).executes(AerobaticElytraCommand.debug((cc, d) -> {
            d.freezeParticleSpeed = FloatArgumentType.getFloat((CommandContext)cc, (String)"speed");
        })))))).then(Commands.m_82127_((String)"keep").then(Commands.m_82129_((String)"keep", (ArgumentType)BoolArgumentType.bool()).executes(AerobaticElytraCommand.debug((cc, d) -> {
            d.persistentParticles = BoolArgumentType.getBool((CommandContext)cc, (String)"keep");
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"freeze").then(Commands.m_82127_((String)"invert").executes(AerobaticElytraCommand.debug((cc, d) -> {
            d.invertFreeze = true;
        })))).then(Commands.m_82127_((String)"normal").executes(AerobaticElytraCommand.debug((cc, d) -> {
            d.invertFreeze = false;
        }))))).then(Commands.m_82127_((String)"target").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(AerobaticElytraCommand.debug((cc, d) -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)cc, (String)"target");
            d.targetPlayer = player != ((CommandSourceStack)cc.getSource()).m_230896_() ? player.m_20148_() : null;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").then(Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(AerobaticElytraCommand::getAbilities)).then(Commands.m_82129_((String)"ability_name", (ArgumentType)QualifiedNameArgumentType.optionallyQualified()).suggests(SUGGEST_ABILITIES).executes(cc -> AerobaticElytraCommand.getAbility((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"ability_name"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"ability_name", (ArgumentType)QualifiedNameArgumentType.optionallyQualified()).suggests(SUGGEST_ABILITIES).then(Commands.m_82129_((String)"ability_value", (ArgumentType)FloatArgumentType.floatArg()).executes(cc -> AerobaticElytraCommand.setAbility((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"ability_name"), FloatArgumentType.getFloat((CommandContext)cc, (String)"ability_value")))))))).then(Commands.m_82127_((String)"reset").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).executes(AerobaticElytraCommand::resetAbilities)).then(Commands.m_82129_((String)"ability_name", (ArgumentType)QualifiedNameArgumentType.optionallyQualified()).suggests(SUGGEST_ABILITIES).executes(cc -> AerobaticElytraCommand.resetAbility((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"ability_name"))))))).then(Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).executes(AerobaticElytraCommand::removeAbilities)).then(Commands.m_82129_((String)"ability_name", (ArgumentType)QualifiedNameArgumentType.optionallyQualified()).suggests(SUGGEST_ABILITIES).executes(cc -> AerobaticElytraCommand.removeAbility((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"ability_name"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"unknown").then(Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(AerobaticElytraCommand::getUnknownAbilities)).then(Commands.m_82129_((String)"ability_name", (ArgumentType)QualifiedNameArgumentType.optionallyQualified()).executes(cc -> AerobaticElytraCommand.getUnknownAbility((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"ability_name"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"ability_name", (ArgumentType)QualifiedNameArgumentType.optionallyQualified()).then(Commands.m_82129_((String)"ability_value", (ArgumentType)FloatArgumentType.floatArg()).executes(cc -> AerobaticElytraCommand.setUnknownAbility((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"ability_name"), FloatArgumentType.getFloat((CommandContext)cc, (String)"ability_value")))))))).then(Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).executes(AerobaticElytraCommand::removeUnknownAbilities)).then(Commands.m_82129_((String)"ability_name", (ArgumentType)QualifiedNameArgumentType.optionallyQualified()).executes(cc -> AerobaticElytraCommand.removeUnknownAbility((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"ability_name"))))))));
        dispatcher.register(aerobaticElytraCommand);
    }

    public static Entity getTarget(CommandContext<CommandSourceStack> cc) throws CommandSyntaxException {
        return EntityArgument.m_91452_(cc, (String)"target");
    }

    public static List<IElytraSpec> getElytraSpecs(CommandContext<CommandSourceStack> cc) throws CommandSyntaxException {
        List<IElytraSpec> list = EntityArgument.m_91461_(cc, (String)"target").stream().filter(e -> e instanceof LivingEntity).map(e -> ((LivingEntity)e).m_6844_(EquipmentSlot.CHEST)).filter(AerobaticElytraLogic::isAerobaticElytra).map(ElytraSpecCapability::getElytraSpecOrDefault).collect(Collectors.toList());
        if (list.isEmpty()) {
            throw NO_ELYTRA_HOLDING_TARGETS.create();
        }
        return list;
    }

    public static IElytraSpec getElytraSpec(CommandContext<CommandSourceStack> cc) throws CommandSyntaxException {
        List<IElytraSpec> specs = AerobaticElytraCommand.getElytraSpecs(cc);
        if (specs.size() != 1) {
            throw new IllegalStateException("Expected a single entity target");
        }
        return specs.get(0);
    }

    public static Component displayFloat(float value) {
        return Component.m_237113_((String)String.format("%5.2f", Float.valueOf(value))).m_130940_(ChatFormatting.AQUA);
    }

    public static int getAbility(CommandContext<CommandSourceStack> cc, String name) throws CommandSyntaxException {
        IElytraSpec spec = AerobaticElytraCommand.getElytraSpec(cc);
        if (!IAbility.isDefined(name)) {
            throw UNKNOWN_ABILITY.create();
        }
        IAbility ability = IAbility.fromName(name);
        Entity target = AerobaticElytraCommand.getTarget(cc);
        if (spec.hasAbility(ability)) {
            float value = spec.getAbility(ability);
            ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.success", (Object[])new Object[]{target.m_5446_()}).m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.ability", (Object[])new Object[]{ability.getDisplayName(), AerobaticElytraCommand.displayFloat(value)})), true);
        } else {
            ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.default", (Object[])new Object[]{ability.getDisplayName(), target.m_5446_(), AerobaticElytraCommand.displayFloat(ability.getDefault())}), true);
        }
        return 0;
    }

    private static int getUnknownAbility(CommandContext<CommandSourceStack> cc, String name) throws CommandSyntaxException {
        IElytraSpec spec = AerobaticElytraCommand.getElytraSpec(cc);
        Entity target = AerobaticElytraCommand.getTarget(cc);
        if (spec.getUnknownAbilities().containsKey(name)) {
            float value = spec.getUnknownAbilities().get(name).floatValue();
            ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.success.unknown", (Object[])new Object[]{target.m_5446_()}).m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.ability.unknown", (Object[])new Object[]{name, AerobaticElytraCommand.displayFloat(value)})), true);
        } else {
            ((CommandSourceStack)cc.getSource()).m_81352_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.failure.unknown", (Object[])new Object[]{name, target.m_5446_()}));
        }
        return 0;
    }

    public static int getAbilities(CommandContext<CommandSourceStack> cc) throws CommandSyntaxException {
        return AerobaticElytraCommand.getAbilities(cc, true);
    }

    public static int getAbilities(CommandContext<CommandSourceStack> cc, boolean show_unknown) throws CommandSyntaxException {
        return AerobaticElytraCommand.getAbilities(cc, true, show_unknown);
    }

    public static int getUnknownAbilities(CommandContext<CommandSourceStack> cc) throws CommandSyntaxException {
        return AerobaticElytraCommand.getAbilities(cc, false, true);
    }

    public static int getAbilities(CommandContext<CommandSourceStack> cc, boolean show_known, boolean show_unknown) throws CommandSyntaxException {
        IElytraSpec spec = AerobaticElytraCommand.getElytraSpec(cc);
        Component name = AerobaticElytraCommand.getTarget(cc).m_5446_();
        MutableComponent msg = TextUtil.stc((String)"");
        if (show_known) {
            msg = msg.m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.all.success", (Object[])new Object[]{spec.getAbilities().size(), name}));
            for (IAbility ability : AerobaticElytraRegistries.getAbilities().values()) {
                msg = msg.m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.ability", (Object[])new Object[]{ability.getDisplayName(), AerobaticElytraCommand.displayFloat(spec.getAbility(ability))}));
            }
        }
        if (show_unknown) {
            Map<String, Float> unknown = spec.getUnknownAbilities();
            if (unknown.isEmpty()) {
                msg = msg.m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.all.unknown.empty", (Object[])new Object[]{name}));
            } else {
                msg = msg.m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.all.unknown", (Object[])new Object[]{unknown.size(), name}));
                for (Map.Entry<String, Float> entry : unknown.entrySet()) {
                    msg = msg.m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.get.ability.unknown", (Object[])new Object[]{entry.getKey(), AerobaticElytraCommand.displayFloat(entry.getValue().floatValue())}));
                }
            }
        }
        MutableComponent m = msg;
        ((CommandSourceStack)cc.getSource()).m_288197_(() -> m, true);
        return 0;
    }

    public static int setAbility(CommandContext<CommandSourceStack> cc, String name, float value) throws CommandSyntaxException {
        if (!IAbility.isDefined(name)) {
            throw UNKNOWN_ABILITY.create();
        }
        IAbility ability = IAbility.fromName(name);
        List<IElytraSpec> specs = AerobaticElytraCommand.getElytraSpecs(cc);
        specs.forEach(s -> s.setAbility(ability, value));
        ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.set.success", (Object[])new Object[]{specs.size()}).m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.set.ability", (Object[])new Object[]{ability.getDisplayName(), AerobaticElytraCommand.displayFloat(value)})), true);
        return 0;
    }

    public static int setUnknownAbility(CommandContext<CommandSourceStack> cc, String name, float value) throws CommandSyntaxException {
        List<IElytraSpec> specs = AerobaticElytraCommand.getElytraSpecs(cc);
        specs.forEach(s -> s.getUnknownAbilities().put(name, Float.valueOf(value)));
        ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.set.success.unknown", (Object[])new Object[]{specs.size()}).m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.set.ability.unknown", (Object[])new Object[]{name, AerobaticElytraCommand.displayFloat(value)})), true);
        return 0;
    }

    public static int resetAbility(CommandContext<CommandSourceStack> cc, String name) throws CommandSyntaxException {
        if (!IAbility.isDefined(name)) {
            throw UNKNOWN_ABILITY.create();
        }
        IAbility ability = IAbility.fromName(name);
        List<IElytraSpec> specs = AerobaticElytraCommand.getElytraSpecs(cc);
        specs.forEach(s -> s.resetAbility(ability));
        ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.reset.success", (Object[])new Object[]{specs.size()}).m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.reset.ability", (Object[])new Object[]{ability.getDisplayName(), AerobaticElytraCommand.displayFloat(ability.getDefault())})), true);
        return 0;
    }

    public static int resetAbilities(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List<IElytraSpec> specs = AerobaticElytraCommand.getElytraSpecs(context);
        specs.forEach(s -> AerobaticElytraRegistries.getAbilities().values().forEach(s::resetAbility));
        MutableComponent msg = TextUtil.ttc((String)"commands.aerobaticelytra.ability.reset.all.success", (Object[])new Object[]{AerobaticElytraRegistries.getAbilities().values().size(), specs.size()});
        for (IAbility ability : AerobaticElytraRegistries.getAbilities().values()) {
            msg = msg.m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.ability.reset.ability", (Object[])new Object[]{ability.getDisplayName(), AerobaticElytraCommand.displayFloat(ability.getDefault())}));
        }
        MutableComponent m = msg;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> m, true);
        return 0;
    }

    public static int removeAbilities(CommandContext<CommandSourceStack> cc) throws CommandSyntaxException {
        List<IElytraSpec> specs = AerobaticElytraCommand.getElytraSpecs(cc);
        specs.forEach(s -> {
            AerobaticElytraRegistries.getAbilities().values().forEach(s::removeAbility);
            s.getUnknownAbilities().clear();
        });
        ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.remove.all.success", (Object[])new Object[]{specs.size()}), true);
        return 0;
    }

    private static int removeUnknownAbilities(CommandContext<CommandSourceStack> cc) throws CommandSyntaxException {
        List<IElytraSpec> specs = AerobaticElytraCommand.getElytraSpecs(cc);
        specs.forEach(s -> s.getUnknownAbilities().clear());
        ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.remove.all.unknown.success", (Object[])new Object[]{specs.size()}), true);
        return 0;
    }

    public static int removeAbility(CommandContext<CommandSourceStack> cc, String name) throws CommandSyntaxException {
        List<IElytraSpec> specs = AerobaticElytraCommand.getElytraSpecs(cc);
        if (!IAbility.isDefined(name)) {
            throw UNKNOWN_ABILITY.create();
        }
        IAbility ability = IAbility.fromName(name);
        long count = specs.stream().map(s -> s.removeAbility(ability)).filter(Objects::nonNull).count();
        ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.remove.success", (Object[])new Object[]{ability.getDisplayName(), count, specs.size()}), true);
        return 0;
    }

    public static int removeUnknownAbility(CommandContext<CommandSourceStack> cc, String name) throws CommandSyntaxException {
        List<IElytraSpec> specs = AerobaticElytraCommand.getElytraSpecs(cc);
        long count = specs.stream().map(s -> s.getUnknownAbilities().remove(name)).filter(Objects::nonNull).count();
        ((CommandSourceStack)cc.getSource()).m_288197_(() -> TextUtil.ttc((String)"commands.aerobaticelytra.ability.remove.success.unknown", (Object[])new Object[]{name, count, specs.size()}), true);
        return 0;
    }

    public static Command<CommandSourceStack> debug(DebugCommand c) {
        return c;
    }

    public static int giveDebugWing(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack debugWing = AerobaticElytraWingItem.createDebugWing();
            if (!player.m_150109_().m_36054_(debugWing)) {
                player.m_36176_(debugWing, false);
            }
            return 0;
        }
        catch (CommandSyntaxException e) {
            LOGGER.warn((Object)e);
            return -1;
        }
    }

    public static int listPacks(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        List<BundledDatapack> packs = AerobaticElytraCommand.getAvailablePacks(source).values().stream().sorted(Comparator.comparing(bd -> bd.name)).toList();
        if (packs.isEmpty()) {
            source.m_81352_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.datapack.list.empty", (Object[])new Object[0]));
        } else {
            MutableComponent msg = TextUtil.ttc((String)"commands.aerobaticelytra.datapack.list.success", (Object[])new Object[0]);
            for (BundledDatapack pack : packs) {
                msg = msg.m_130946_("\n  ").m_7220_((Component)pack.getDisplayName().m_130938_(s -> {
                    boolean isEnabled;
                    boolean isInstalled = AerobaticElytraCommand.isPackInstalled(source, pack.getTitle());
                    boolean bl = isEnabled = isInstalled && source.m_81377_().m_129891_().m_10524_().stream().anyMatch(p -> p.m_10446_().equals(pack.getPackName()));
                    s = s.m_131140_(isInstalled ? (isEnabled ? ChatFormatting.GREEN : ChatFormatting.LIGHT_PURPLE) : ChatFormatting.AQUA).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextUtil.stc((String)pack.getDescription()).m_130946_("\n").m_7220_((Component)TextUtil.ttc((String)("commands.aerobaticelytra.datapack.list.link." + (isInstalled ? (isEnabled ? "disable" : "enable") : "install")), (Object[])new Object[0]))));
                    String command = isInstalled ? "/datapack " + (isEnabled ? "disable" : "enable") + " \"" + pack.getPackName() + "\"" : "/aerobaticelytra datapack install " + StringArgumentType.escapeIfRequired((String)pack.getTitle());
                    s = s.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command));
                    return s;
                }));
            }
            MutableComponent m = msg;
            source.m_288197_(() -> m, true);
        }
        return 0;
    }

    public static boolean isPackInstalled(CommandSourceStack source, String name) {
        Map<String, BundledDatapack> availablePacks = AerobaticElytraCommand.getAvailablePacksByTitle(source);
        if (!availablePacks.containsKey(name)) {
            source.m_81352_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.datapack.install.unknown", (Object[])new Object[0]));
        }
        Path datapacksFolder = source.m_81377_().m_129843_(LevelResource.f_78180_);
        Path destination = datapacksFolder.resolve(packPrefix + name);
        return destination.toFile().exists();
    }

    public static int installPack(CommandContext<CommandSourceStack> context, String name) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Map<String, BundledDatapack> availablePacks = AerobaticElytraCommand.getAvailablePacksByTitle(source);
        if (!availablePacks.containsKey(name)) {
            source.m_81352_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.datapack.install.unknown", (Object[])new Object[0]));
        }
        BundledDatapack pack = availablePacks.get(name);
        Path datapacksFolder = source.m_81377_().m_129843_(LevelResource.f_78180_);
        Path destination = datapacksFolder.resolve(packPrefix + name);
        String enableCommandText = "/datapack enable \"file/" + destination.getFileName() + "\"";
        MutableComponent enableCommand = ComponentUtils.m_130748_((Component)TextUtil.stc((String)AerobaticElytraCommand.ellipsis(enableCommandText, 40)).m_130938_(style2 -> style2.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, enableCommandText)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TextUtil.stc((String)enableCommandText).m_130940_(ChatFormatting.AQUA)))));
        if (destination.toFile().exists()) {
            source.m_81352_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.datapack.install.overwrite", (Object[])new Object[]{enableCommand}));
            return 1;
        }
        Path anchor = new File(DATAPACK_LOCATION).toPath().resolve(pack.name);
        try {
            for (Map.Entry<ResourceLocation, InputStream> entry : pack.getStreams().entrySet()) {
                File dest = destination.resolve(anchor.relativize(new File(entry.getKey().m_135815_()).toPath())).toFile();
                assert (dest.getParentFile().mkdirs());
                assert (dest.createNewFile());
                FileUtils.copyInputStreamToFile((InputStream)entry.getValue(), (File)dest);
            }
        }
        catch (IOException | AssertionError e) {
            LOGGER.error(e);
            source.m_81352_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.datapack.install.failure.copy", (Object[])new Object[]{((Throwable)e).getLocalizedMessage()}));
            try {
                FileUtils.deleteDirectory((File)destination.toFile());
            }
            catch (IOException f) {
                LOGGER.error(e);
                source.m_81352_((Component)TextUtil.ttc((String)"commands.aerobaticelytra.datapack.install.failure.undo", (Object[])new Object[]{f.getLocalizedMessage()}));
            }
            return 2;
        }
        source.m_81377_().m_129891_().m_10506_();
        source.m_288197_(() -> AerobaticElytraCommand.lambda$installPack$52((Component)enableCommand), true);
        return 0;
    }

    public static String ellipsis(String str, int length) {
        return str.length() < length ? str : str.substring(0, length - 3) + "...";
    }

    public static Map<String, BundledDatapack> getAvailablePacksByTitle(CommandSourceStack source) {
        return AerobaticElytraCommand.getAvailablePacks(source).values().stream().collect(Collectors.toMap(BundledDatapack::getTitle, bd -> bd, (a, b) -> a));
    }

    public static Map<String, BundledDatapack> getAvailablePacks(CommandSourceStack source) {
        Pack pack = source.m_81377_().m_129891_().m_10507_("mod:aerobaticelytra");
        if (pack == null) {
            LOGGER.warn("Could not find mod datapack");
            return Collections.emptyMap();
        }
        try (PackResources resourcePack = pack.m_10445_();){
            HashMap packs = Maps.newHashMap();
            resourcePack.m_8031_(PackType.SERVER_DATA, "aerobaticelytra", DATAPACK_LOCATION, (loc, io) -> {
                String path = AerobaticElytraCommand.normalizePath(loc.m_135815_());
                if (PACK_MCMETA_PATH_PATTERN.asMatchPredicate().test(path)) {
                    BundledDatapack bundled = new BundledDatapack(resourcePack, new ResourceLocation(loc.m_135827_(), StringUtils.removeEnd((String)AerobaticElytraCommand.normalizePath(loc.m_135815_()), (String)"/pack.mcmeta")));
                    if (!packs.containsKey(bundled.name)) {
                        packs.put(bundled.name, bundled);
                    }
                }
            });
            HashMap hashMap = packs;
            return hashMap;
        }
    }

    public static String normalizePath(String path) {
        return path.replace('\\', '/').replaceAll("^/|/$", "");
    }

    private static /* synthetic */ Component lambda$installPack$52(Component enableCommand) {
        return TextUtil.ttc((String)"commands.aerobaticelytra.datapack.install.success", (Object[])new Object[]{enableCommand});
    }

    @FunctionalInterface
    public static interface DebugCommand
    extends Command<CommandSourceStack> {
        public void run(CommandContext<CommandSourceStack> var1, Debug var2) throws CommandSyntaxException;

        default public int run(CommandContext<CommandSourceStack> s) throws CommandSyntaxException {
            Debug debug = Debug.DEBUG;
            this.run(s, debug);
            Debug.register();
            ServerPlayer player = ((CommandSourceStack)s.getSource()).m_81375_();
            new DebugPackets.SDebugSettingsPacket((Player)player, debug).sendTo(player);
            return 0;
        }
    }

    public static class BundledDatapack {
        public final String name;
        public final ResourceLocation location;
        public final PackResources pack;
        protected final String description;
        protected final MutableComponent title;

        public BundledDatapack(PackResources pack, ResourceLocation location) {
            String description;
            String title;
            block5: {
                this.pack = pack;
                this.location = location;
                String[] split = location.m_135815_().split("/");
                title = this.name = split[split.length - 1];
                description = "";
                try {
                    IoSupplier res = pack.m_214146_(PackType.SERVER_DATA, this.getMcMetaLocation());
                    if (res == null) break block5;
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)res.m_247737_()));
                    try {
                        if (json.isJsonObject()) {
                            JsonObject packInfo = GsonHelper.m_13930_((JsonObject)json.getAsJsonObject(), (String)"pack");
                            title = GsonHelper.m_13906_((JsonObject)packInfo, (String)"title");
                            description = GsonHelper.m_13906_((JsonObject)packInfo, (String)"description");
                        }
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {}
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.title = Component.m_237113_((String)title);
            this.description = description;
        }

        public String getTitle() {
            return this.title.getString();
        }

        public String getPackName() {
            return "file/" + packPrefix + this.getTitle();
        }

        public String getDescription() {
            return this.description;
        }

        public MutableComponent getDisplayName() {
            return this.title;
        }

        public ResourceLocation getMcMetaLocation() {
            return new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + "/pack.mcmeta");
        }

        public Collection<ResourceLocation> getAllResourceLocations() {
            ArrayList locations = Lists.newArrayList();
            this.pack.m_8031_(PackType.SERVER_DATA, this.location.m_135827_(), this.location.m_135815_(), (loc, s) -> {
                if (!loc.m_135815_().equals(this.location.m_135815_())) {
                    locations.add(loc);
                }
            });
            locations.add(this.getMcMetaLocation());
            return locations;
        }

        public Map<ResourceLocation, InputStream> getStreams() {
            HashMap<ResourceLocation, InputStream> streams = new HashMap<ResourceLocation, InputStream>();
            for (ResourceLocation rl : this.getAllResourceLocations()) {
                try {
                    IoSupplier res = this.pack.m_214146_(PackType.SERVER_DATA, rl);
                    if (res == null) {
                        throw new IOException("Unknown resource: " + rl);
                    }
                    streams.put(rl, (InputStream)res.m_247737_());
                }
                catch (IOException e) {
                    LOGGER.warn("Could not get resource stream for bundled datapack resource " + rl);
                    LOGGER.error((Object)e);
                }
            }
            return streams;
        }
    }
}

