/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.server;

import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.FlightDataCapability;
import endorh.aerobaticelytra.network.AerobaticPackets;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class SyncHandler {
    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player tracked = (Player)entity;
            ServerPlayer player = (ServerPlayer)event.getEntity();
            new AerobaticPackets.SFlightDataPacket(tracked).sendTo(player);
            new AerobaticPackets.SAerobaticDataPacket(tracked).sendTo(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SyncHandler.update((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        SyncHandler.reset((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
    }

    private static void update(ServerPlayer player) {
        new AerobaticPackets.SFlightDataPacket((Player)player).sendTo(player);
        new AerobaticPackets.SAerobaticDataPacket((Player)player).sendTo(player);
    }

    private static void reset(ServerPlayer player) {
        FlightDataCapability.getFlightDataOrDefault((Player)player).reset();
        AerobaticDataCapability.getAerobaticDataOrDefault((Player)player).reset();
        new AerobaticPackets.SFlightDataPacket((Player)player).sendTo(player);
        new AerobaticPackets.SAerobaticDataPacket((Player)player).sendTo(player);
    }
}

