/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.server;

import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.flight.AerobaticFlight;
import endorh.lazulib.events.DisableElytraCheckEvent;
import endorh.lazulib.text.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class KickHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<UUID, Integer> INVALID_PACKET_COUNT = new HashMap<UUID, Integer>();

    public static void incrementInvalidPacketCount(ServerPlayer player) {
        UUID id = player.m_20148_();
        int count = INVALID_PACKET_COUNT.containsKey(id) ? INVALID_PACKET_COUNT.get(id) + 1 : 1;
        INVALID_PACKET_COUNT.put(id, count);
        if (Config.network.invalid_packet_kick_count > 0 && count >= Config.network.invalid_packet_kick_count) {
            INVALID_PACKET_COUNT.put(id, 0);
            player.f_8906_.m_9942_((Component)TextUtil.ttc((String)"aerobaticelytra.network.kick", (Object[])new Object[0]));
            LOGGER.warn("Kicked player '" + player.m_6302_() + "' for reaching the limit of invalid aerobatic flight packets.\nServer config might be out of sync, or the player could be cheating.\nYou may change the limit or disable it completely in the aerobatic elytra server config.");
        }
    }

    @SubscribeEvent
    public static void onDisableElytraCheck(DisableElytraCheckEvent event) {
        if (event.getDisable()) {
            return;
        }
        if (AerobaticFlight.isAerobaticFlying((Player)event.player) && (Config.network.disable_aerobatic_elytra_movement_check || event.excess <= (double)((float)event.stackedPackets * Config.network.aerobatic_elytra_movement_check))) {
            event.setDisable(true);
        }
    }
}

