/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.network;

import endorh.aerobaticelytra.common.flight.WeatherData;
import endorh.aerobaticelytra.network.NetworkHandler;
import endorh.lazulib.math.Vec3f;
import endorh.lazulib.network.ServerWorldPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeatherPackets {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void registerAll() {
        ServerWorldPacket.with((SimpleChannel)NetworkHandler.CHANNEL, NetworkHandler.ID_GEN).register(SWindNodePacket::new);
    }

    public static class SWindNodePacket
    extends ServerWorldPacket {
        protected WeatherData.WindRegion node = null;
        protected long x;
        protected long z;
        public Vec3f wind;
        public Vec3f angularWind;

        private SWindNodePacket() {
        }

        public SWindNodePacket(WeatherData.WindRegion node) {
            super(node.region.world);
            this.node = node;
            this.x = node.region.x;
            this.z = node.region.z;
            this.wind = node.wind;
            this.angularWind = node.angularWind;
        }

        public void onClient(Level world, NetworkEvent.Context ctx) {
            WeatherData.WindRegion node = WeatherData.WindRegion.of(world, this.x, this.z);
            node.update(this);
        }

        public void serialize(FriendlyByteBuf buf) {
            buf.writeLong(this.x);
            buf.writeLong(this.z);
            this.wind.write(buf);
            this.angularWind.write(buf);
        }

        public void deserialize(FriendlyByteBuf buf) {
            this.x = buf.readLong();
            this.z = buf.readLong();
            this.wind = Vec3f.read((FriendlyByteBuf)buf);
            this.angularWind = Vec3f.read((FriendlyByteBuf)buf);
        }

        public void sendTracking() {
            this.sendTarget(WeatherData.TRACKING_WEATHER_REGION.with(() -> this.node.region));
        }
    }
}

