/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.network;

import endorh.aerobaticelytra.common.recipe.UpgradeRecipe;
import endorh.aerobaticelytra.network.NetworkHandler;
import endorh.lazulib.network.ClientPlayerPacket;
import endorh.lazulib.network.PacketBufferUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpgradeRecipePacket
extends ClientPlayerPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    List<ResourceLocation> recipeIDs;

    public static void register() {
        ClientPlayerPacket.with((SimpleChannel)NetworkHandler.CHANNEL, NetworkHandler.ID_GEN).register(UpgradeRecipePacket::new);
    }

    public UpgradeRecipePacket() {
    }

    public UpgradeRecipePacket(Player player, List<UpgradeRecipe> recipes) {
        super(player);
        this.recipeIDs = recipes.stream().map(CustomRecipe::m_6423_).collect(Collectors.toList());
    }

    public List<UpgradeRecipe> getRecipes(Player player) {
        return this.recipeIDs.stream().map(id -> {
            Optional opt = player.m_9236_().m_7465_().m_44043_(id);
            if (opt.isEmpty()) {
                LOGGER.error("Unknown recipe id found in packet from player \"" + player.m_6302_() + "\": \"" + id + "\"\nRecipe will be ignored");
                return null;
            }
            Recipe recipe = (Recipe)opt.get();
            if (recipe instanceof UpgradeRecipe) {
                return (UpgradeRecipe)recipe;
            }
            LOGGER.error("Invalid recipe id found in packet from player \"" + player.m_6302_() + "\": \"" + id + "\"\nRecipe will be ignored");
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void onServer(Player player, NetworkEvent.Context ctx) {
        List<UpgradeRecipe> recipes = this.getRecipes(player);
        UpgradeRecipe.apply(player, recipes);
    }

    public void serialize(FriendlyByteBuf buf) {
        PacketBufferUtil.writeList((FriendlyByteBuf)buf, this.recipeIDs, FriendlyByteBuf::m_130085_);
    }

    public void deserialize(FriendlyByteBuf buf) {
        this.recipeIDs = PacketBufferUtil.readList((FriendlyByteBuf)buf, FriendlyByteBuf::m_130281_);
    }
}

