/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.network;

import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.FlightDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.capability.IFlightData;
import endorh.aerobaticelytra.common.config.Config;
import endorh.aerobaticelytra.common.flight.VectorBase;
import endorh.aerobaticelytra.common.flight.mode.IFlightMode;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import endorh.aerobaticelytra.network.NetworkHandler;
import endorh.aerobaticelytra.server.KickHandler;
import endorh.lazulib.math.Vec3f;
import endorh.lazulib.network.DistributedPlayerPacket;
import endorh.lazulib.network.ServerPlayerPacket;
import endorh.lazulib.network.ValidatedDistributedPlayerPacket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AerobaticPackets {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String invalidPacketWarnSuffix = "\nServer config might be out of sync, the server could be lagging, or the player could be trying to cheat.";
    private static final int TIME_BETWEEN_WARNINGS = 40;
    private static final Map<String, Map<String, Integer>> LAST_WARNS = new HashMap<String, Map<String, Integer>>();

    private static boolean logWarning(Player player, String message, Object ... args) {
        String name = player.m_6302_();
        int time = player.f_19797_;
        if (!LAST_WARNS.computeIfAbsent(name, s -> new HashMap()).containsKey(message) || time - LAST_WARNS.get(name).get(message) >= 40) {
            Object[] formatArgs = new Object[args.length + 1];
            formatArgs[0] = player;
            System.arraycopy(args, 0, formatArgs, 1, args.length);
            LOGGER.warn(String.format(message, formatArgs));
            LAST_WARNS.get(name).put(message, time);
            return true;
        }
        return false;
    }

    private static boolean handlePlayerWarning(Player player, String message, Object ... args) {
        KickHandler.incrementInvalidPacketCount((ServerPlayer)player);
        return AerobaticPackets.logWarning(player, message + invalidPacketWarnSuffix, args);
    }

    public static void registerAll() {
        DistributedPlayerPacket.with((SimpleChannel)NetworkHandler.CHANNEL, NetworkHandler.ID_GEN).registerLocal(DFlightModePacket::new).registerLocal(DTiltPacket::new).registerLocal(DAccelerationPacket::new).registerLocal(DSneakingPacket::new).registerLocal(DJumpingPacket::new).registerLocal(DSprintingPacket::new).registerLocal(DRotationPacket::new).registerLocal(DLookAroundPacket::new);
        ServerPlayerPacket.with((SimpleChannel)NetworkHandler.CHANNEL, NetworkHandler.ID_GEN).register(SFlightDataPacket::new).register(SAerobaticDataPacket::new);
    }

    public static class SFlightDataPacket
    extends ServerPlayerPacket {
        IFlightData data;

        protected SFlightDataPacket() {
        }

        public SFlightDataPacket(Player player) {
            super(player);
            this.data = FlightDataCapability.getFlightDataOrDefault(player);
        }

        protected void onClient(Player player, NetworkEvent.Context ctx) {
            IFlightData targetData = FlightDataCapability.getFlightDataOrDefault(player);
            targetData.copy(this.data);
        }

        protected void serialize(FriendlyByteBuf buf) {
            buf.m_130079_(FlightDataCapability.asNBT(this.data));
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.data = FlightDataCapability.fromNBT(buf.m_130260_());
        }
    }

    public static class SAerobaticDataPacket
    extends ServerPlayerPacket {
        IAerobaticData data;

        protected SAerobaticDataPacket() {
        }

        public SAerobaticDataPacket(Player player) {
            super(player);
            this.data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        }

        protected void onClient(Player player, NetworkEvent.Context ctx) {
            IAerobaticData targetData = AerobaticDataCapability.getAerobaticDataOrDefault(player);
            targetData.copy(this.data);
        }

        protected void serialize(FriendlyByteBuf buf) {
            buf.m_130079_(AerobaticDataCapability.asNBT(this.data));
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.data = AerobaticDataCapability.fromNBT(buf.m_130260_());
        }
    }

    public static class DLookAroundPacket
    extends DistributedPlayerPacket {
        float yaw;
        float pitch;

        public DLookAroundPacket() {
        }

        public DLookAroundPacket(IAerobaticData data) {
            this.yaw = data.getLookAroundYaw();
            this.pitch = data.getLookAroundPitch();
        }

        protected void onCommon(Player sender, NetworkEvent.Context ctx) {
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(sender);
            data.setLookAroundYaw(this.yaw);
            data.setLookAroundPitch(this.pitch);
        }

        protected void serialize(FriendlyByteBuf buf) {
            buf.writeFloat(this.yaw);
            buf.writeFloat(this.pitch);
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.yaw = buf.readFloat();
            this.pitch = buf.readFloat();
        }
    }

    public static class DSprintingPacket
    extends DistributedPlayerPacket {
        boolean sprinting;

        public DSprintingPacket() {
        }

        public DSprintingPacket(IAerobaticData data) {
            this.sprinting = data.isSprinting();
        }

        protected void onCommon(Player sender, NetworkEvent.Context ctx) {
            IAerobaticData target = AerobaticDataCapability.getAerobaticDataOrDefault(sender);
            if (this.sprinting) {
                sender.m_6858_(false);
            }
            target.setSprinting(this.sprinting);
        }

        protected void serialize(FriendlyByteBuf buf) {
            buf.writeBoolean(this.sprinting);
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.sprinting = buf.readBoolean();
        }
    }

    public static class DJumpingPacket
    extends DistributedPlayerPacket {
        boolean jumping;

        public DJumpingPacket() {
        }

        public DJumpingPacket(IAerobaticData data) {
            this.jumping = data.isJumping();
        }

        protected void onCommon(Player sender, NetworkEvent.Context ctx) {
            IAerobaticData target = AerobaticDataCapability.getAerobaticDataOrDefault(sender);
            target.setJumping(this.jumping);
        }

        protected void serialize(FriendlyByteBuf buf) {
            buf.writeBoolean(this.jumping);
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.jumping = buf.readBoolean();
        }
    }

    public static class DSneakingPacket
    extends DistributedPlayerPacket {
        boolean sneaking;

        public DSneakingPacket() {
        }

        public DSneakingPacket(IAerobaticData data) {
            this.sneaking = data.isSneaking();
        }

        public void onCommon(Player sender, NetworkEvent.Context ctx) {
            IAerobaticData target = AerobaticDataCapability.getAerobaticDataOrDefault(sender);
            target.setSneaking(this.sneaking);
        }

        protected void serialize(FriendlyByteBuf buf) {
            buf.writeBoolean(this.sneaking);
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.sneaking = buf.readBoolean();
        }
    }

    public static class DAccelerationPacket
    extends ValidatedDistributedPlayerPacket {
        float propStrength;
        float brakeStrength;

        public DAccelerationPacket() {
        }

        public DAccelerationPacket(IAerobaticData data) {
            this.propStrength = data.getPropulsionStrength();
            this.brakeStrength = data.getBrakeStrength();
        }

        public void onCommon(Player sender, NetworkEvent.Context ctx) {
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(sender);
            data.setPropulsionStrength(this.validateClamp(this.propStrength, Config.aerobatic.propulsion.range_tick.getFloatMin(), Config.aerobatic.propulsion.range_tick.getFloatMax()));
            data.setBrakeStrength(this.validateClamp(this.brakeStrength, 0.0f, 1.0f));
        }

        protected void serialize(FriendlyByteBuf buf) {
            buf.writeFloat(this.propStrength);
            buf.writeFloat(this.brakeStrength);
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.propStrength = buf.readFloat();
            this.brakeStrength = buf.readFloat();
        }
    }

    public static class DTiltPacket
    extends ValidatedDistributedPlayerPacket {
        private static final Map<String, Integer> STRIKES = new HashMap<String, Integer>();
        float tiltPitch;
        float tiltRoll;
        float tiltYaw;

        public DTiltPacket() {
        }

        public DTiltPacket(IAerobaticData data) {
            this.tiltPitch = data.getTiltPitch();
            this.tiltRoll = data.getTiltRoll();
            this.tiltYaw = data.getTiltYaw();
        }

        protected void onServer(Player sender, NetworkEvent.Context ctx) {
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(sender);
            boolean inWater = sender.m_20069_();
            data.setTiltPitch(this.validateClamp(this.tiltPitch, -Config.aerobatic.tilt.range_pitch, Config.aerobatic.tilt.range_pitch));
            data.setTiltRoll(this.validateClamp(this.tiltRoll, -Config.aerobatic.tilt.range_roll, Config.aerobatic.tilt.range_roll));
            float tiltRangeYaw = inWater ? 1.6f * Config.aerobatic.tilt.range_yaw : Config.aerobatic.tilt.range_yaw;
            data.setTiltYaw(this.validateClamp(this.tiltYaw, -tiltRangeYaw, tiltRangeYaw));
            String name = sender.m_6302_();
            if (this.isInvalid()) {
                if (STRIKES.compute(name, (n, i) -> i != null ? i + 1 : 1) < 4) {
                    this.unInvalidate();
                } else {
                    AerobaticPackets.handlePlayerWarning(sender, "Player '%s' tilted too much!", new Object[0]);
                }
            } else {
                STRIKES.computeIfPresent(name, (n, i) -> Math.max(0, i - 1));
            }
        }

        protected void onClient(Player sender, NetworkEvent.Context ctx) {
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(sender);
            data.setTiltPitch(this.tiltPitch);
            data.setTiltRoll(this.tiltRoll);
            data.setTiltYaw(this.tiltYaw);
        }

        protected void serialize(FriendlyByteBuf buf) {
            buf.writeFloat(this.tiltPitch);
            buf.writeFloat(this.tiltRoll);
            buf.writeFloat(this.tiltYaw);
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.tiltPitch = buf.readFloat();
            this.tiltRoll = buf.readFloat();
            this.tiltYaw = buf.readFloat();
        }
    }

    public static class DRotationPacket
    extends ValidatedDistributedPlayerPacket {
        VectorBase rotation;

        public DRotationPacket() {
        }

        public DRotationPacket(IAerobaticData data) {
            this.rotation = data.getRotationBase();
        }

        protected void onServer(Player sender, NetworkEvent.Context ctx) {
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(sender);
            if (!Config.network.disable_aerobatic_elytra_rotation_check && !sender.m_20069_()) {
                MinecraftServer server = sender.m_20194_();
                assert (server != null);
                long[] times = server.getTickTime(sender.m_9236_().m_46472_());
                long mspt = times != null ? Math.max(Arrays.stream(times).sum() / (long)times.length, 50L) : 50L;
                float lag = Math.max(50.0f, (float)((ServerPlayer)sender).f_8943_);
                float overlook = (float)mspt / 50.0f * (lag / 50.0f) * Config.network.aerobatic_elytra_rotation_check_overlook;
                float mul = overlook * Math.max(0.2f, Math.abs(new Vec3f(sender.m_20184_()).dot(this.rotation.look)));
                float[] distance = data.getRotationBase().distance(this.rotation);
                float tiltYaw = this.validateClose(distance[0], 0.0f, Config.aerobatic.tilt.range_yaw * mul);
                float tiltPitch = this.validateClose(distance[1], 0.0f, Config.aerobatic.tilt.range_pitch * mul);
                float tiltRoll = this.validateClose(distance[2], 0.0f, Config.aerobatic.tilt.range_roll * mul);
                if (this.isInvalid()) {
                    data.getRotationBase().rotate(tiltPitch, tiltYaw, tiltRoll);
                    AerobaticPackets.handlePlayerWarning(sender, "Player '%s' rotated too fast!", new Object[0]);
                } else {
                    data.getRotationBase().set(this.rotation);
                }
            } else {
                data.getRotationBase().set(this.rotation);
            }
        }

        public void onCommon(Player sender, NetworkEvent.Context ctx) {
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(sender);
            data.getRotationBase().set(this.rotation);
        }

        protected void serialize(FriendlyByteBuf buf) {
            this.rotation.write(buf);
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.rotation = VectorBase.read(buf);
        }
    }

    public static class DFlightModePacket
    extends ValidatedDistributedPlayerPacket {
        IFlightMode mode;

        private DFlightModePacket() {
        }

        public DFlightModePacket(IFlightMode mode) {
            this.mode = mode;
        }

        protected void onServer(Player sender, NetworkEvent.Context ctx) {
            if (this.mode.canBeUsedBy(sender)) {
                FlightDataCapability.getFlightDataOrDefault(sender).setFlightMode(this.mode);
            } else {
                this.mode = FlightDataCapability.getFlightDataOrDefault(sender).getFlightMode();
                this.invalidate();
                AerobaticPackets.handlePlayerWarning(sender, "Player '%s' tried to use restricted flight mode: %s", AerobaticElytraRegistries.FLIGHT_MODE_REGISTRY.getKey((Object)this.mode));
            }
        }

        protected void onClient(Player sender, NetworkEvent.Context ctx) {
            FlightDataCapability.getFlightDataOrDefault(sender).setFlightMode(this.mode);
        }

        protected void serialize(FriendlyByteBuf buf) {
            this.mode.write(buf);
        }

        protected void deserialize(FriendlyByteBuf buf) {
            this.mode = IFlightMode.read(buf);
        }
    }
}

