/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei.category;

import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.recipe.ItemSelector;
import endorh.aerobaticelytra.common.recipe.UpgradeRecipe;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiHelper;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiPlugin;
import endorh.aerobaticelytra.integration.jei.category.BaseCategory;
import endorh.aerobaticelytra.integration.jei.gui.JeiResources;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeRecipeCategory
extends BaseCategory<UpgradeRecipe> {
    public static final RecipeType<UpgradeRecipe> TYPE = RecipeType.create((String)"aerobaticelytra", (String)"upgrade", UpgradeRecipe.class);
    @Nullable
    private IDrawable[] plusEffectTextures;

    public UpgradeRecipeCategory() {
        super(TYPE, JeiResources::upgradeRecipeBg, (Item)AerobaticElytraItems.AEROBATIC_ELYTRA, false);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull UpgradeRecipe recipe, @NotNull IFocusGroup focuses) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.m_7527_());
        List<ItemStack> inputs = ingredients.stream().flatMap(i -> Arrays.stream(i.m_43908_())).toList();
        ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AerobaticElytraItems.AEROBATIC_ELYTRA}));
        List<ItemStack> elytras = AerobaticElytraJeiHelper.getAerobaticElytrasMatchingFocus(focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK));
        ItemStack output = recipe.getResult(elytras.stream().findFirst().orElseGet(() -> new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA)));
        List<ItemStack> items = this.setTag(recipe, UpgradeRecipeCategory.getItemMatchingFocus(focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK), RecipeIngredientRole.OUTPUT, Collections.singletonList(output), inputs));
        int i2 = 0;
        while (elytras.size() < items.size()) {
            elytras.add(elytras.get(i2));
            ++i2;
        }
        i2 = 0;
        while (items.size() < elytras.size()) {
            items.add(items.get(i2));
            ++i2;
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 1).addItemStacks(elytras);
        builder.addSlot(RecipeIngredientRole.INPUT, 70, 1).addItemStacks(items);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 118, 1).addItemStacks(this.apply(recipe, elytras, items));
    }

    private IDrawable getPlusEffectTexture() {
        if (this.plusEffectTextures == null) {
            this.plusEffectTextures = JeiResources.upgradeRecipePlusHighlightTexture(AerobaticElytraJeiPlugin.guiHelper);
        }
        return this.plusEffectTextures[ClientConfig.style.dark_theme.enabled ? 1 : 0];
    }

    public void draw(@NotNull UpgradeRecipe recipe, @NotNull IRecipeSlotsView view, @NotNull GuiGraphics gg, double mouseX, double mouseY) {
        super.draw((Object)recipe, view, gg, mouseX, mouseY);
        if (recipe.getSelectors().stream().anyMatch(s -> !s.isSimple())) {
            this.getPlusEffectTexture().draw(gg, 45, 0);
        }
    }

    protected List<ItemStack> apply(UpgradeRecipe recipe, List<ItemStack> elytras, List<ItemStack> ingredients) {
        if (elytras.size() != ingredients.size()) {
            throw new IllegalArgumentException("elytras and ingredients must be of the same size");
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(elytras.size());
        for (int i = 0; i < elytras.size(); ++i) {
            ItemStack res = elytras.get(i).m_41777_();
            for (UpgradeRecipe r : UpgradeRecipe.getUpgradeRecipes(elytras.get(i), ingredients.get(i))) {
                res = r.getResult(res);
            }
            result.add(res);
        }
        return result;
    }

    protected List<ItemStack> setTag(UpgradeRecipe recipe, List<ItemStack> stacks) {
        return stacks.stream().map(s -> {
            ItemStack st = s = s.m_41777_();
            recipe.getSelectors().stream().filter(sel -> sel.testIgnoringNBT(st)).findFirst().flatMap(ItemSelector::matchingNBT).ifPresent(arg_0 -> ((ItemStack)s).m_41751_(arg_0));
            return s;
        }).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<Component> getTooltipStrings(@NotNull UpgradeRecipe recipe, @NotNull IRecipeSlotsView view, double x, double y) {
        List<Component> tt;
        block3: {
            block4: {
                block2: {
                    tt = super.getTooltipStrings(recipe, view, x, y);
                    if (!UpgradeRecipeCategory.inRect(x, y, 3.0, 2.0, 14.0, 14.0)) break block2;
                    tt.addAll((Collection<Component>)TextUtil.splitTtc((String)"aerobaticelytra.jei.help.category.upgrade", (Object[])new Object[0]));
                    break block3;
                }
                if (!UpgradeRecipeCategory.inRect(x, y, 46.0, 1.0, 15.0, 15.0)) break block4;
                for (ItemSelector sel : recipe.getSelectors()) {
                    tt.add(sel.getDisplay());
                }
                break block3;
            }
            if (!UpgradeRecipeCategory.inRect(x, y, 91.0, 1.0, 22.0, 15.0)) break block3;
            for (IElytraSpec.Upgrade upgrade : recipe.getUpgrades()) {
                tt.addAll(upgrade.getDisplay());
            }
        }
        return tt;
    }

    @Override
    public void registerRecipes(IRecipeRegistration reg, RecipeManager recipeManager, List<UpgradeRecipe> recipes) {
        List<UpgradeRecipe> sorted = recipes.stream().filter(UpgradeRecipe::isValid).sorted(Comparator.comparing(r -> r.getSelectors().stream().map(ItemSelector::toString).collect(Collectors.joining(";")))).toList();
        reg.addRecipes(this.type, sorted);
    }
}

