/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei.category;

import com.google.common.collect.Sets;
import endorh.aerobaticelytra.client.trail.AerobaticTrail;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.recipe.TrailRecipe;
import endorh.aerobaticelytra.integration.jei.AbstractContextualRecipeWrapper;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiHelper;
import endorh.aerobaticelytra.integration.jei.ContextualRecipeCategory;
import endorh.aerobaticelytra.integration.jei.category.BaseCategory;
import endorh.aerobaticelytra.integration.jei.gui.JeiResources;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class TrailRecipeCategory
extends BaseCategory<TrailRecipeWrapper>
implements ContextualRecipeCategory<TrailRecipeWrapper, TrailRecipeCategory> {
    public static final RecipeType<TrailRecipeWrapper> TYPE = RecipeType.create((String)"aerobaticelytra", (String)"trail", TrailRecipeWrapper.class);

    public TrailRecipeCategory() {
        super(TYPE, JeiResources::regular3x3RecipeBg, (Item)AerobaticElytraItems.AEROBATIC_ELYTRA, Items.f_42688_, false);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull TrailRecipeWrapper recipe, @NotNull IFocusGroup focuses) {
        List<ItemStack> elytras;
        EnumMap<AerobaticTrail.RocketSide, List<ItemStack>> rockets = new EnumMap<AerobaticTrail.RocketSide, List<ItemStack>>(AerobaticTrail.RocketSide.class);
        ItemStack outElytra = AerobaticElytraJeiHelper.getSingleFocusStack(focuses, (Item)AerobaticElytraItems.AEROBATIC_ELYTRA, RecipeIngredientRole.OUTPUT);
        ItemStack inputRocket = AerobaticElytraJeiHelper.getSingleFocusStack(focuses, Items.f_42688_, RecipeIngredientRole.INPUT);
        if (!outElytra.m_41619_()) {
            elytras = recipe.getInputElytras(outElytra);
            for (Object side : recipe.mask) {
                rockets.put((AerobaticTrail.RocketSide)((Object)side), recipe.getRockets(outElytra, (AerobaticTrail.RocketSide)((Object)side)));
            }
        } else {
            ItemStack inElytra = AerobaticElytraJeiHelper.getSingleFocusStack(focuses, (Item)AerobaticElytraItems.AEROBATIC_ELYTRA, RecipeIngredientRole.INPUT);
            List<ItemStack> list = elytras = inElytra.m_41619_() ? AerobaticElytraJeiHelper.getAerobaticElytras() : List.of(inElytra.m_41777_());
            if (!inputRocket.m_41619_()) {
                for (AerobaticTrail.RocketSide side : recipe.mask) {
                    rockets.put(side, List.of(inputRocket.m_41777_()));
                }
            } else {
                for (AerobaticTrail.RocketSide side : recipe.mask) {
                    rockets.put(side, AerobaticElytraJeiHelper.getRockets(5));
                }
            }
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 19).addItemStacks(elytras);
        for (Object side : recipe.mask) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, TrailRecipeCategory.getSlotX(side), TrailRecipeCategory.getSlotY(side)).addItemStacks(rockets.get(side))).addTooltipCallback(TrailRecipeCategory.getRocketTooltip(side));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStacks(TrailRecipeCategory.apply(elytras, rockets));
    }

    private static int getSlotX(AerobaticTrail.RocketSide side) {
        return side.wingSide == ElytraDyement.WingSide.LEFT ? 1 : 37;
    }

    private static int getSlotY(AerobaticTrail.RocketSide side) {
        return side == AerobaticTrail.RocketSide.CENTER_LEFT || side == AerobaticTrail.RocketSide.CENTER_RIGHT ? 37 : 19;
    }

    @NotNull
    private static IRecipeSlotTooltipCallback getRocketTooltip(AerobaticTrail.RocketSide side) {
        return (view, tooltip) -> {
            tooltip.add(Component.m_237119_());
            tooltip.addAll(TextUtil.splitTtc((String)(view.getItemStacks().anyMatch(TrailRecipeCategory::hasNoStars) ? "aerobaticelytra.recipe.trail.clears_side" : "aerobaticelytra.recipe.trail.changes_side"), (Object[])new Object[]{side.getDisplayName().m_130940_(ChatFormatting.DARK_AQUA)}).withStyle(ChatFormatting.GRAY));
        };
    }

    private static boolean hasNoStars(ItemStack rocket) {
        CompoundTag fireworks = rocket.m_41737_("Fireworks");
        return fireworks == null || !fireworks.m_128441_("Explosions");
    }

    public static List<ItemStack> apply(List<ItemStack> elytras, Map<AerobaticTrail.RocketSide, List<ItemStack>> rockets) {
        int rocketSize = rockets.values().stream().mapToInt(List::size).max().orElse(0);
        if (rocketSize == 0) {
            return elytras;
        }
        return IntStream.range(0, AerobaticElytraJeiHelper.mcm(elytras.size(), rocketSize)).mapToObj(i -> TrailRecipe.apply((ItemStack)elytras.get(i % elytras.size()), new ItemStack[]{TrailRecipeCategory.getOrDefault(rockets, AerobaticTrail.RocketSide.LEFT, i, ItemStack.f_41583_), TrailRecipeCategory.getOrDefault(rockets, AerobaticTrail.RocketSide.RIGHT, i, ItemStack.f_41583_), TrailRecipeCategory.getOrDefault(rockets, AerobaticTrail.RocketSide.CENTER_LEFT, i, ItemStack.f_41583_), TrailRecipeCategory.getOrDefault(rockets, AerobaticTrail.RocketSide.CENTER_RIGHT, i, ItemStack.f_41583_)})).toList();
    }

    private static <K, T> T getOrDefault(Map<K, List<T>> map, K key, int idx, T def) {
        List<T> l = map.get(key);
        return l != null ? l.get(idx % l.size()) : def;
    }

    @Override
    @NotNull
    public List<Component> getTooltipStrings(@NotNull TrailRecipeWrapper recipe, @NotNull IRecipeSlotsView view, double mouseX, double mouseY) {
        List<Component> tt = super.getTooltipStrings(recipe, view, mouseX, mouseY);
        if (TrailRecipeCategory.inRect(mouseX, mouseY, 61.0, 19.0, 22.0, 15.0)) {
            tt.addAll((Collection<Component>)TextUtil.optSplitTtc((String)"aerobaticelytra.jei.help.category.trail", (Object[])new Object[0]));
        }
        return tt;
    }

    @Override
    public RecipeType<?> getContextualRecipeType() {
        return TYPE;
    }

    @Override
    public List<TrailRecipeWrapper> getContextualRecipes(RecipeManager manager) {
        Optional<Recipe> opt = manager.m_44051_().stream().filter(r -> r instanceof TrailRecipe).findAny();
        if (opt.isPresent()) {
            return (List)Util.m_137469_(new ArrayList(), l -> {
                l.add(TrailRecipeWrapper.clear(EnumSet.allOf(AerobaticTrail.RocketSide.class)));
                for (AerobaticTrail.RocketSide side : AerobaticTrail.RocketSide.values()) {
                    l.add(TrailRecipeWrapper.set(EnumSet.of(side)));
                }
                l.add(TrailRecipeWrapper.set(EnumSet.of(AerobaticTrail.RocketSide.LEFT, AerobaticTrail.RocketSide.RIGHT)));
                l.add(TrailRecipeWrapper.set(EnumSet.of(AerobaticTrail.RocketSide.CENTER_LEFT, AerobaticTrail.RocketSide.CENTER_RIGHT)));
                l.add(TrailRecipeWrapper.set(EnumSet.allOf(AerobaticTrail.RocketSide.class)));
            });
        }
        return Collections.emptyList();
    }

    @Override
    public List<TrailRecipeWrapper> getContextualRecipes(RecipeManager manager, IFocusGroup focuses) {
        ItemStack outElytra = AerobaticElytraJeiHelper.getSingleFocusStack(focuses, (Item)AerobaticElytraItems.AEROBATIC_ELYTRA, RecipeIngredientRole.OUTPUT);
        if (!outElytra.m_41619_()) {
            IElytraSpec.TrailData trail = ElytraSpecCapability.getElytraSpecOrDefault(outElytra).getTrailData();
            if (trail.getUsedSides().isEmpty()) {
                return Collections.emptyList();
            }
            return List.of(TrailRecipeWrapper.set(trail.getUsedSides()));
        }
        return ContextualRecipeCategory.super.getContextualRecipes(manager, focuses);
    }

    @Override
    public void registerRecipes(IRecipeRegistration reg, RecipeManager recipeManager) {
    }

    public static class TrailRecipeWrapper
    extends AbstractContextualRecipeWrapper {
        public final Set<AerobaticTrail.RocketSide> mask;
        public final boolean clear;

        protected TrailRecipeWrapper(Set<AerobaticTrail.RocketSide> mask, boolean clear) {
            super(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AerobaticElytraItems.AEROBATIC_ELYTRA}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42688_})), List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AerobaticElytraItems.AEROBATIC_ELYTRA})));
            this.mask = Sets.immutableEnumSet(mask);
            this.clear = clear;
        }

        public static TrailRecipeWrapper set(Set<AerobaticTrail.RocketSide> mask) {
            return new TrailRecipeWrapper(mask, false);
        }

        public static TrailRecipeWrapper clear(Set<AerobaticTrail.RocketSide> mask) {
            return new TrailRecipeWrapper(mask, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isOutputReachable(ItemStack output) {
            IElytraSpec.TrailData trail = ElytraSpecCapability.getElytraSpecOrDefault(output).getTrailData();
            if (!this.clear) return true;
            if (!trail.getUsedSides().stream().noneMatch(this.mask::contains)) return false;
            return true;
        }

        @Override
        public boolean isInputUsable(ItemStack input) {
            if (input.m_41720_() == Items.f_42688_) {
                IElytraSpec.TrailData trail = IElytraSpec.TrailData.empty();
                trail.readRocket(AerobaticTrail.RocketSide.LEFT, input);
                return this.clear == (trail.get(AerobaticTrail.RocketSide.LEFT).length == 0);
            }
            return true;
        }

        public List<ItemStack> getRockets(ItemStack outputElytra, AerobaticTrail.RocketSide side) {
            IElytraSpec.TrailData trail = ElytraSpecCapability.getElytraSpecOrDefault(outputElytra).getTrailData();
            if (this.clear) {
                if (trail.getUsedSides().stream().anyMatch(this.mask::contains)) {
                    throw new IllegalStateException("Contextual recipe is not reachable!");
                }
            }
            if (!this.mask.contains((Object)side)) {
                return Collections.emptyList();
            }
            ItemStack rocket = new ItemStack((ItemLike)Items.f_42688_);
            trail.writeRocket(side, rocket);
            return List.of(rocket);
        }

        public List<ItemStack> getInputElytras(ItemStack outputElytra) {
            IElytraSpec.TrailData trail = ElytraSpecCapability.getElytraSpecOrDefault(outputElytra).getTrailData();
            if (this.clear) {
                if (trail.getUsedSides().stream().anyMatch(this.mask::contains)) {
                    throw new IllegalStateException("Contextual recipe is not reachable!");
                }
            }
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < 5; ++i) {
                ItemStack copy = outputElytra.m_41777_();
                IElytraSpec.TrailData trailCopy = trail.copy();
                for (AerobaticTrail.RocketSide side : AerobaticTrail.RocketSide.values()) {
                    if (!this.mask.contains((Object)side)) continue;
                    trailCopy.put(side, trailCopy.get(side).length > 0 ? null : AerobaticElytraJeiHelper.makeRocketStars());
                }
                ElytraSpecCapability.getElytraSpecOrDefault(copy).getTrailData().read(trailCopy.write());
                list.add(copy);
            }
            return list;
        }
    }
}

