/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei.category;

import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.recipe.SplitRecipe;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiHelper;
import endorh.aerobaticelytra.integration.jei.category.BaseCategory;
import endorh.aerobaticelytra.integration.jei.gui.JeiResources;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class SplitRecipeCategory
extends BaseCategory<SplitRecipe> {
    public static final RecipeType<SplitRecipe> TYPE = RecipeType.create((String)"aerobaticelytra", (String)"split", SplitRecipe.class);

    public SplitRecipeCategory() {
        super(TYPE, JeiResources::byproduct3x3RecipeBg, (Item)AerobaticElytraItems.AEROBATIC_ELYTRA, Items.f_42574_, true);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull SplitRecipe recipe, @NotNull IFocusGroup focuses) {
        int j;
        int i;
        List<ItemStack> elytras = AerobaticElytraJeiHelper.getAerobaticElytrasMatchingFocus(focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK));
        ArrayList<IRecipeSlotBuilder> slots = new ArrayList<IRecipeSlotBuilder>(18);
        Pair<List<ItemStack>, List<ItemStack>> wings = AerobaticElytraJeiHelper.split(elytras);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                slots.add(builder.addSlot(RecipeIngredientRole.INPUT, 1 + 18 * j, 1 + 18 * i));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                slots.add(builder.addSlot(RecipeIngredientRole.OUTPUT, 28 + 18 * j, 64 + 18 * i));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStacks((List)wings.getSecond());
        ((IRecipeSlotBuilder)slots.get(0)).addItemStacks(elytras);
        ((IRecipeSlotBuilder)slots.get(9)).addItemStacks((List)wings.getFirst());
        int s = Math.min(recipe.ingredients.size(), 8);
        for (i = 0; i < s; ++i) {
            List<ItemStack> ing = Arrays.asList(((Ingredient)((org.apache.commons.lang3.tuple.Pair)recipe.ingredients.get(i)).getLeft()).m_43908_());
            List<ItemStack> st = SplitRecipeCategory.getItemMatchingFocus(focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK), RecipeIngredientRole.INPUT, ing, ing);
            ((IRecipeSlotBuilder)slots.get(i + 1)).addItemStacks(st);
            SplitRecipe.LeaveData data = (SplitRecipe.LeaveData)((org.apache.commons.lang3.tuple.Pair)recipe.ingredients.get(i)).getRight();
            if (!data.leave) continue;
            ((IRecipeSlotBuilder)slots.get(10 + i)).addItemStacks(SplitRecipeCategory.damage(st, data.damage));
        }
    }

    private static List<ItemStack> damage(List<ItemStack> stacks, int damage) {
        return stacks.stream().map(s -> {
            s = s.m_41777_();
            s.m_41721_(s.m_41773_() + damage);
            return s;
        }).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<Component> getTooltipStrings(@NotNull SplitRecipe recipe, @NotNull IRecipeSlotsView view, double mouseX, double mouseY) {
        List<Component> tt = super.getTooltipStrings(recipe, view, mouseX, mouseY);
        if (SplitRecipeCategory.inRect(mouseX, mouseY, 61.0, 19.0, 22.0, 15.0)) {
            tt.addAll((Collection<Component>)TextUtil.optSplitTtc((String)"aerobaticelytra.jei.help.category.split", (Object[])new Object[0]));
        } else if (SplitRecipeCategory.inRect(mouseX, mouseY, 7.0, 60.0, 17.0, 19.0)) {
            tt.addAll((Collection<Component>)TextUtil.optSplitTtc((String)"aerobaticelytra.jei.help.category.split.remainder", (Object[])new Object[0]));
        }
        return tt;
    }
}

