/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei.category;

import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.recipe.JoinRecipe;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiHelper;
import endorh.aerobaticelytra.integration.jei.category.BaseCategory;
import endorh.aerobaticelytra.integration.jei.gui.JeiResources;
import endorh.lazulib.text.TextUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class JoinRecipeCategory
extends BaseCategory<JoinRecipe> {
    public static final RecipeType<JoinRecipe> TYPE = RecipeType.create((String)"aerobaticelytra", (String)"join", JoinRecipe.class);

    public JoinRecipeCategory() {
        super(TYPE, JeiResources::regular3x3RecipeBg, AerobaticElytraItems.AEROBATIC_ELYTRA_WING, AerobaticElytraItems.AEROBATIC_ELYTRA_WING, false);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull JoinRecipe recipe, @NotNull IFocusGroup focuses) {
        Stream focus = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK);
        List<ItemStack> elytras = AerobaticElytraJeiHelper.getAerobaticElytrasMatchingFocus(focus);
        Pair<List<ItemStack>, List<ItemStack>> wings = AerobaticElytraJeiHelper.split(elytras);
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks((List)wings.getFirst());
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).addItemStacks((List)wings.getSecond());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStacks(elytras);
    }

    @Override
    @NotNull
    public List<Component> getTooltipStrings(@NotNull JoinRecipe recipe, @NotNull IRecipeSlotsView view, double mouseX, double mouseY) {
        List<Component> tt = super.getTooltipStrings(recipe, view, mouseX, mouseY);
        if (JoinRecipeCategory.inRect(mouseX, mouseY, 61.0, 19.0, 22.0, 15.0)) {
            tt.addAll((Collection<Component>)TextUtil.optSplitTtc((String)"aerobaticelytra.jei.help.category.join", (Object[])new Object[0]));
        }
        return tt;
    }
}

