/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei.category;

import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.recipe.DyeRecipe;
import endorh.aerobaticelytra.integration.jei.AbstractContextualRecipeWrapper;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiHelper;
import endorh.aerobaticelytra.integration.jei.ContextualRecipeCategory;
import endorh.aerobaticelytra.integration.jei.DyeMixGenerator;
import endorh.aerobaticelytra.integration.jei.category.BaseCategory;
import endorh.aerobaticelytra.integration.jei.gui.JeiResources;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DyeRecipeCategory
extends BaseCategory<DyeRecipeWrapper>
implements ContextualRecipeCategory<DyeRecipeWrapper, DyeRecipeCategory> {
    public static final RecipeType<DyeRecipeWrapper> TYPE = RecipeType.create((String)"aerobaticelytra", (String)"dye", DyeRecipeWrapper.class);
    protected static long lastIconChange = 0L;

    public DyeRecipeCategory() {
        super(TYPE, JeiResources::regular3x3RecipeBg, (Item)AerobaticElytraItems.AEROBATIC_ELYTRA, Items.f_42497_, true);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull DyeRecipeWrapper recipe, @NotNull IFocusGroup focuses) {
        List<List<ItemStack>> dyes;
        ArrayList<IRecipeSlotBuilder> slots = new ArrayList<IRecipeSlotBuilder>(10);
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                slots.add(builder.addSlot(RecipeIngredientRole.INPUT, 18 * j, 18 * i2));
            }
        }
        List elytras = null;
        ItemStack out = AerobaticElytraJeiHelper.getSingleFocusElytraOrWings(focuses, RecipeIngredientRole.OUTPUT);
        if (!out.m_41619_()) {
            List<DyeMixGenerator.DyeMix> mixes = recipe.makeMixes(out, 5);
            elytras = IntStream.range(0, 5).mapToObj(i -> recipe.dyementFromRemainder((DyeMixGenerator.DyeMix)mixes.get(i), i)).map(d -> {
                ItemStack stack = new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA);
                d.write(stack);
                return stack;
            }).toList();
            if (recipe.wings) {
                elytras = (List)AerobaticElytraJeiHelper.split(elytras).getFirst();
            }
            dyes = mixes.stream().map(DyeMixGenerator.DyeMix::getDyeStacks).toList();
        } else {
            ItemStack inputElytra = AerobaticElytraJeiHelper.getSingleFocusElytraOrWings(focuses, RecipeIngredientRole.INPUT);
            if (!inputElytra.m_41619_()) {
                elytras = List.of(inputElytra.m_41777_());
            }
            ItemStack inputDye = AerobaticElytraJeiHelper.getSingleFocusStack(focuses, i -> i instanceof DyeItem, RecipeIngredientRole.INPUT);
            dyes = IntStream.range(0, 5).mapToObj(i -> (List)Util.m_137469_(new ArrayList(), l -> {
                int j;
                if (!inputDye.m_41619_()) {
                    l.add(inputDye.m_41777_());
                }
                int n = j = inputDye.m_41619_() ? 0 : 1;
                while (j < recipe.dyeAmount) {
                    l.add(new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)AerobaticElytraJeiHelper.nextDyeColor())));
                    ++j;
                }
            })).toList();
        }
        if (elytras == null) {
            elytras = AerobaticElytraJeiHelper.getAerobaticElytras();
            if (recipe.wings) {
                elytras = (List)AerobaticElytraJeiHelper.split(elytras).getFirst();
            }
        }
        ((IRecipeSlotBuilder)slots.get(0)).addItemStacks(elytras);
        int s2 = Math.min(recipe.dyeAmount, 8);
        for (int i3 = 0; i3 < s2; ++i3) {
            for (List list : dyes) {
                ((IRecipeSlotBuilder)slots.get(i3 + 1)).addItemStack((ItemStack)list.get(i3));
            }
        }
        IntStream.range(1, Math.min(recipe.dyeAmount + 1, 9)).mapToObj(slots::get).forEach(s -> s.addTooltipCallback((view, tooltip) -> tooltip.add(TextUtil.ttc((String)"jei.tooltip.recipe.tag", (Object[])new Object[]{"minecraft:dyes"}).m_130940_(ChatFormatting.GRAY))));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStacks(DyeRecipeCategory.dye(elytras, dyes));
    }

    public static List<ItemStack> dye(List<ItemStack> stacks, List<List<ItemStack>> dyes) {
        if (dyes.isEmpty()) {
            return stacks;
        }
        return IntStream.range(0, AerobaticElytraJeiHelper.mcm(stacks.size(), dyes.get(0).size())).mapToObj(i -> DyeRecipe.dye((ItemStack)stacks.get(i % stacks.size()), dyes.stream().map(l -> (DyeItem)((ItemStack)l.get(i % l.size())).m_41720_()).collect(Collectors.toList()))).toList();
    }

    @Override
    @NotNull
    public List<Component> getTooltipStrings(@NotNull DyeRecipeWrapper recipe, @NotNull IRecipeSlotsView view, double mouseX, double mouseY) {
        List<Component> tt = super.getTooltipStrings(recipe, view, mouseX, mouseY);
        if (DyeRecipeCategory.inRect(mouseX, mouseY, 61.0, 19.0, 22.0, 15.0)) {
            tt.addAll((Collection<Component>)TextUtil.optSplitTtc((String)"aerobaticelytra.jei.help.category.dye", (Object[])new Object[0]));
        }
        return tt;
    }

    @Override
    public RecipeType<?> getContextualRecipeType() {
        return TYPE;
    }

    @Override
    public List<DyeRecipeWrapper> getContextualRecipes(RecipeManager manager) {
        Optional<Recipe> opt = manager.m_44051_().stream().filter(r -> r instanceof DyeRecipe).findAny();
        if (opt.isPresent()) {
            return IntStream.range(0, 16).mapToObj(i -> new DyeRecipeWrapper(i / 2 + 1, i % 2 == 1)).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void registerRecipes(IRecipeRegistration reg, RecipeManager recipeManager) {
    }

    @Override
    @NotNull
    public IDrawable getIcon() {
        long t = System.currentTimeMillis();
        if (t - lastIconChange > 1000L) {
            this.icon = AerobaticElytraJeiHelper.createMultiIngredientDrawable(VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)this.iconItems.getFirst()), new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)AerobaticElytraJeiHelper.nextDyeColor())));
            lastIconChange = t;
        }
        return this.icon;
    }

    public static class DyeRecipeWrapper
    extends AbstractContextualRecipeWrapper {
        private static final DyeMixGenerator MIX_GEN = new DyeMixGenerator();
        protected static final List<DyeItem> dyeItems = Arrays.stream(DyeColor.values()).map(DyeItem::m_41082_).collect(Collectors.toList());
        protected static final Ingredient dyeIngredient = Ingredient.m_43929_((ItemLike[])((ItemLike[])dyeItems.toArray(new DyeItem[0])));
        protected final int dyeAmount;
        protected final boolean wings;

        public DyeRecipeWrapper(int dyeAmount, boolean wings) {
            super(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{wings ? AerobaticElytraItems.AEROBATIC_ELYTRA_WING : AerobaticElytraItems.AEROBATIC_ELYTRA}), dyeIngredient), List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{wings ? AerobaticElytraItems.AEROBATIC_ELYTRA_WING : AerobaticElytraItems.AEROBATIC_ELYTRA})));
            this.dyeAmount = dyeAmount;
            this.wings = wings;
        }

        public List<Ingredient> getIngredients() {
            return (List)Util.m_137469_(new ArrayList(), l -> {
                l.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AerobaticElytraItems.AEROBATIC_ELYTRA}));
                for (int i = 0; i < this.dyeAmount; ++i) {
                    l.add(dyeIngredient);
                }
            });
        }

        @Override
        public boolean isOutputReachable(ItemStack output) {
            ElytraDyement dyement = new ElytraDyement();
            dyement.read(output);
            return !dyement.hasWingDyement && dyement.getWing((ElytraDyement.WingSide)ElytraDyement.WingSide.LEFT).hasColor;
        }

        public List<DyeMixGenerator.DyeMix> makeMixes(ItemStack outputElytra, int amount) {
            ElytraDyement dyement = new ElytraDyement();
            dyement.read(outputElytra);
            if (dyement.hasWingDyement || !dyement.getWing((ElytraDyement.WingSide)ElytraDyement.WingSide.LEFT).hasColor) {
                throw new IllegalStateException("Contextual recipe is not applicable");
            }
            int color = dyement.getWing((ElytraDyement.WingSide)ElytraDyement.WingSide.LEFT).color;
            return IntStream.range(0, amount).mapToObj(i -> MIX_GEN.generateMix(color, this.dyeAmount)).sorted(Comparator.comparing(m -> Float.valueOf(m.error() - (m.remainder() == null ? 1.0f : 0.0f)))).toList();
        }

        public ElytraDyement dyementFromRemainder(DyeMixGenerator.DyeMix mix, int parts) {
            Integer remainder = mix.remainder();
            ElytraDyement dyement = new ElytraDyement();
            if (remainder == null) {
                return dyement;
            }
            if (parts <= 1 || parts == 2 && this.wings) {
                dyement.setColor(remainder);
            } else if (parts == 2) {
                int[] pair = MIX_GEN.splitRemainder(remainder);
                dyement.getWing(ElytraDyement.WingSide.LEFT).setColor(pair[0]);
                dyement.getWing(ElytraDyement.WingSide.RIGHT).setColor(pair[1]);
            } else {
                List<DyeColor> colors = MIX_GEN.separateRemainderIntoDyes(remainder, parts);
                if (parts % 2 == 0 && !this.wings) {
                    dyement.getWing(ElytraDyement.WingSide.LEFT).setPattern(colors.get(0), IntStream.range(0, colors.size() / 2).mapToObj(i -> Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)((DyeColor)colors.get(i)))).toList());
                    dyement.getWing(ElytraDyement.WingSide.RIGHT).setPattern(colors.get(colors.size() / 2), IntStream.range(colors.size() / 2 + 1, colors.size()).mapToObj(i -> Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)((DyeColor)colors.get(i)))).toList());
                } else {
                    dyement.setPattern(colors.get(0), IntStream.range(1, colors.size()).mapToObj(i -> Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)((DyeColor)colors.get(i)))).toList());
                }
            }
            return dyement;
        }
    }
}

