/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei.category;

import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.client.config.ClientConfig;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiHelper;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiPlugin;
import endorh.aerobaticelytra.integration.jei.gui.JeiResources;
import endorh.aerobaticelytra.integration.jei.gui.ShapelessDecoratedDrawable;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCategory<T>
implements IRecipeCategory<T> {
    protected final RecipeType<T> type;
    protected final IDrawable background;
    protected final IDrawable background_dark;
    protected IDrawable icon;
    protected Pair<Item, Item> iconItems;
    protected final String localizedNameKey;
    protected final boolean shapeless;

    protected BaseCategory(RecipeType<T> type, Function<IGuiHelper, IDrawable[]> backgroundProvider, Item icon, boolean shapeless) {
        this(type, backgroundProvider, icon, null, shapeless);
    }

    protected BaseCategory(RecipeType<T> type, Function<IGuiHelper, IDrawable[]> backgroundProvider, Item icon, Item iconSecond, boolean shapeless) {
        IGuiHelper guiHelper = AerobaticElytraJeiPlugin.guiHelper;
        String shortName = type.getUid().m_135815_().replace("/", ".");
        this.type = type;
        if (shapeless) {
            backgroundProvider = JeiResources.shapeless(backgroundProvider);
        }
        IDrawable[] bg = backgroundProvider.apply(guiHelper);
        this.background = bg[0];
        this.background_dark = bg[1];
        this.localizedNameKey = "aerobaticelytra.recipe.category." + shortName;
        this.iconItems = Pair.of((Object)icon, (Object)iconSecond);
        this.shapeless = shapeless;
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)this.localizedNameKey);
    }

    @NotNull
    public IDrawable getBackground() {
        return ClientConfig.style.dark_theme.enabled ? this.background_dark : this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        if (this.icon == null) {
            IGuiHelper guiHelper = AerobaticElytraJeiPlugin.guiHelper;
            Item first = (Item)this.iconItems.getFirst();
            Item second = (Item)this.iconItems.getSecond();
            this.icon = second != null ? AerobaticElytraJeiHelper.createMultiIngredientDrawable(VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)first), new ItemStack((ItemLike)second)) : guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)first));
        }
        return this.icon;
    }

    public void registerRecipes(IRecipeRegistration reg, RecipeManager recipeManager) {
        this.registerRecipes(reg, recipeManager, recipeManager.m_44051_().stream().filter(r -> this.getRecipeType().getRecipeClass().isInstance(r)).sorted(Comparator.comparing(r -> r.m_7527_().stream().map(Object::toString).collect(Collectors.joining(";")))).map(r -> r).collect(Collectors.toList()));
    }

    public void registerRecipes(IRecipeRegistration reg, RecipeManager recipeManager, List<T> recipes) {
        reg.addRecipes(this.type, recipes);
    }

    protected static List<ItemStack> getItemMatchingFocus(Stream<IFocus<ItemStack>> focuses, RecipeIngredientRole role, List<ItemStack> focused, List<ItemStack> other) {
        for (IFocus focus : focuses::iterator) {
            if (focus.getRole() != role) continue;
            ItemStack focusStack = focus.getTypedValue().getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(ItemStack.f_41583_);
            for (int i = 0; i < focused.size(); ++i) {
                if (!Objects.equals(focusStack.m_41720_(), focused.get(i).m_41720_())) continue;
                return Collections.singletonList(other.get(i));
            }
        }
        return other;
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull T recipe, @NotNull IRecipeSlotsView view, double mouseX, double mouseY) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (this.shapeless && BaseCategory.inRect(mouseX, mouseY, this.background.getWidth() - ShapelessDecoratedDrawable.shapelessIconWidth(), 0.0, ShapelessDecoratedDrawable.shapelessIconWidth(), ShapelessDecoratedDrawable.shapelessIconHeight())) {
            list.add((Component)TextUtil.ttc((String)"jei.tooltip.shapeless.recipe", (Object[])new Object[0]));
        }
        return list;
    }

    protected static boolean inRect(double x, double y, double l, double t, double w, double h) {
        return x >= l && x < l + w && y >= t && y < t + h;
    }
}

