/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei.category;

import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.recipe.BannerRecipe;
import endorh.aerobaticelytra.integration.jei.AbstractContextualRecipeWrapper;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiHelper;
import endorh.aerobaticelytra.integration.jei.ContextualRecipeCategory;
import endorh.aerobaticelytra.integration.jei.category.BaseCategory;
import endorh.aerobaticelytra.integration.jei.gui.JeiResources;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BannerBlock;
import org.jetbrains.annotations.NotNull;

public class BannerRecipeCategory
extends BaseCategory<BannerRecipeWrapper>
implements ContextualRecipeCategory<BannerRecipeWrapper, BannerRecipeCategory> {
    public static final RecipeType<BannerRecipeWrapper> TYPE = RecipeType.create((String)"aerobaticelytra", (String)"banner", BannerRecipeWrapper.class);
    protected static long lastIconChange = 0L;

    public BannerRecipeCategory() {
        super(TYPE, JeiResources::regular3x3RecipeBg, (Item)AerobaticElytraItems.AEROBATIC_ELYTRA, Items.f_42727_, true);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BannerRecipeWrapper recipe, @NotNull IFocusGroup focuses) {
        List elytras = null;
        ItemStack outElytra = AerobaticElytraJeiHelper.getSingleFocusElytraOrWings(focuses, RecipeIngredientRole.OUTPUT);
        ItemStack inElytra = AerobaticElytraJeiHelper.getSingleFocusElytraOrWings(focuses, RecipeIngredientRole.INPUT);
        List<ItemStack> banners = null;
        if (!outElytra.m_41619_()) {
            ElytraDyement dyement = new ElytraDyement();
            dyement.read(outElytra);
            ElytraDyement.WingDyement wing = dyement.getWing(ElytraDyement.WingSide.LEFT);
            if (wing.hasPattern) {
                ItemStack stack = new ItemStack((ItemLike)BannerBlock.m_49014_((DyeColor)wing.basePatternColor));
                wing.write(stack, null);
                banners = List.of(stack);
            }
        } else if (!inElytra.m_41619_()) {
            elytras = List.of(inElytra.m_41777_());
        }
        ItemStack inputBanner = AerobaticElytraJeiHelper.getSingleFocusStack(focuses, i -> i instanceof BannerItem, RecipeIngredientRole.INPUT);
        if (!inputBanner.m_41619_() && !outElytra.m_41619_()) {
            banners = List.of(inputBanner);
        }
        if (banners == null) {
            banners = AerobaticElytraJeiHelper.getBanners();
        }
        if (elytras == null) {
            elytras = AerobaticElytraJeiHelper.getAerobaticElytras();
            if (recipe.wings) {
                elytras = (List)AerobaticElytraJeiHelper.split(elytras).getFirst();
            }
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(elytras);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).addItemStacks(banners)).addTooltipCallback((view, tooltip) -> tooltip.add(TextUtil.ttc((String)"jei.tooltip.recipe.tag", (Object[])new Object[]{ItemTags.f_13191_.f_203868_()}).m_130940_(ChatFormatting.GRAY)));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStacks(BannerRecipeCategory.elytras(elytras, banners));
    }

    public static List<ItemStack> elytras(List<ItemStack> elytras, List<ItemStack> patterns) {
        if (patterns.isEmpty()) {
            return elytras;
        }
        return IntStream.range(0, AerobaticElytraJeiHelper.mcm(elytras.size(), patterns.size())).mapToObj(i -> BannerRecipe.apply((ItemStack)elytras.get(i % elytras.size()), (ItemStack)patterns.get(i % patterns.size()))).toList();
    }

    @Override
    public RecipeType<?> getContextualRecipeType() {
        return TYPE;
    }

    @Override
    public List<BannerRecipeWrapper> getContextualRecipes(RecipeManager manager) {
        Optional<Recipe> opt = manager.m_44051_().stream().filter(r -> r instanceof BannerRecipe).findAny();
        if (opt.isPresent()) {
            return IntStream.range(0, 2).mapToObj(i -> new BannerRecipeWrapper(i != 0)).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void registerRecipes(IRecipeRegistration reg, RecipeManager recipeManager) {
    }

    @Override
    @NotNull
    public List<Component> getTooltipStrings(@NotNull BannerRecipeWrapper recipe, @NotNull IRecipeSlotsView view, double mouseX, double mouseY) {
        List<Component> tt = super.getTooltipStrings(recipe, view, mouseX, mouseY);
        if (BannerRecipeCategory.inRect(mouseX, mouseY, 61.0, 19.0, 22.0, 15.0)) {
            tt.addAll((Collection<Component>)TextUtil.optSplitTtc((String)"aerobaticelytra.jei.help.category.banner", (Object[])new Object[0]));
        }
        return tt;
    }

    @Override
    @NotNull
    public IDrawable getIcon() {
        long t = System.currentTimeMillis();
        if (t - lastIconChange > 1000L) {
            this.icon = AerobaticElytraJeiHelper.createMultiIngredientDrawable(VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)this.iconItems.getFirst()), AerobaticElytraJeiHelper.makeBanner(AerobaticElytraJeiHelper.nextDyeColor(), (List)Util.m_137469_(new ArrayList(), l -> {
                int n = AerobaticElytraJeiHelper.RANDOM.m_188503_(4);
                for (int i = 0; i < n; ++i) {
                    l.add(Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()));
                }
            })));
            lastIconChange = t;
        }
        return this.icon;
    }

    public static class BannerRecipeWrapper
    extends AbstractContextualRecipeWrapper {
        protected final boolean wings;

        public BannerRecipeWrapper(boolean wings) {
            super(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{wings ? AerobaticElytraItems.AEROBATIC_ELYTRA_WING : AerobaticElytraItems.AEROBATIC_ELYTRA}), Ingredient.m_204132_((TagKey)ItemTags.f_13191_)), List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{wings ? AerobaticElytraItems.AEROBATIC_ELYTRA_WING : AerobaticElytraItems.AEROBATIC_ELYTRA})));
            this.wings = wings;
        }

        @Override
        public boolean isOutputReachable(ItemStack output) {
            ElytraDyement dyement = new ElytraDyement();
            dyement.read(output);
            return (this.wings || !dyement.hasWingDyement) && dyement.getWing((ElytraDyement.WingSide)ElytraDyement.WingSide.LEFT).hasPattern;
        }

        public ItemStack getInputPattern(@NotNull ItemStack outputElytra) {
            ElytraDyement dyement = new ElytraDyement();
            dyement.read(outputElytra);
            ElytraDyement.WingDyement wing = dyement.getWing(ElytraDyement.WingSide.LEFT);
            if (!this.wings && dyement.hasWingDyement || !wing.hasPattern) {
                throw new IllegalStateException("Contextual recipe is not reachable!");
            }
            ItemStack banner = new ItemStack((ItemLike)BannerBlock.m_49014_((DyeColor)wing.basePatternColor));
            wing.write(banner, null);
            return banner;
        }
    }
}

