/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DyeMixGenerator {
    private final RandomSource RANDOM;
    private final List<DyeColor> dyes = new ArrayList<DyeColor>(9);
    private int targetAmount;
    private int target;
    private float error;
    @Nullable
    private Integer remainder;
    private int remainingAttempts;
    private float targetValue;
    private final float[] targetHueCoords = new float[3];
    private float currentValue;
    private final float[] currentHueCoords = new float[3];
    private final int[] currentSum = new int[3];

    public DyeMixGenerator(RandomSource randomSource) {
        this.RANDOM = randomSource;
    }

    public DyeMixGenerator() {
        this(RandomSource.m_216327_());
    }

    public List<DyeColor> separateRemainderIntoDyes(int rem, int n) {
        return this.generateMix(rem, n).dyes();
    }

    public int[] splitRemainder(int rem) {
        float rf = this.RANDOM.m_188501_();
        float gf = this.RANDOM.m_188501_();
        float bf = this.RANDOM.m_188501_();
        int r = (int)((float)(rem >> 16 & 0xFF) * rf) & 0xFF;
        int g = (int)((float)(rem >> 8 & 0xFF) * gf) & 0xFF;
        int b = (int)((float)(rem & 0xFF) * bf) & 0xFF;
        return new int[]{r << 16 | g << 8 | b, 255 - r << 16 | 255 - g << 8 | 255 - b};
    }

    public DyeMix generateMix(int targetColor, int dyeNum) {
        this.dyes.clear();
        this.targetAmount = dyeNum;
        this.target = targetColor;
        this.remainder = targetColor;
        this.remainingAttempts = 16;
        this.initSearch();
        if (this.searchMix()) {
            return this.result();
        }
        while (this.remainingAttempts > 0) {
            this.backtrackSome();
            if (!this.searchMix()) continue;
            return this.result();
        }
        return this.result();
    }

    private DyeMix result() {
        if (this.targetAmount > 0) {
            if (this.dyes.size() > this.targetAmount) {
                this.dyes.subList(this.targetAmount + 1, this.dyes.size()).clear();
            } else if (!this.dyes.isEmpty()) {
                int s = this.dyes.size();
                int i = 0;
                while (i < s && this.dyes.size() < this.targetAmount) {
                    this.dyes.add(this.dyes.get(i));
                    i = (i + 1) % s;
                }
            } else {
                while (this.dyes.size() < this.targetAmount) {
                    this.dyes.add(this.nextRandomDyeByHueValueDistance());
                }
            }
        }
        this.updateState();
        this.calculateRemainder();
        return new DyeMix(this.remainder, new ArrayList<DyeColor>(this.dyes), this.error);
    }

    private void initSearch() {
        int r = this.target >> 16 & 0xFF;
        int g = this.target >> 8 & 0xFF;
        int b = this.target & 0xFF;
        this.targetValue = (float)DyeMixGenerator.max3(r, g, b) / 255.0f;
        this.targetHueCoords[0] = (float)r / 255.0f / this.targetValue;
        this.targetHueCoords[1] = (float)g / 255.0f / this.targetValue;
        this.targetHueCoords[2] = (float)b / 255.0f / this.targetValue;
        Arrays.fill(this.currentSum, 0);
        this.error = 0.0f;
    }

    private boolean searchMix() {
        if (this.remainingAttempts <= 0) {
            return false;
        }
        if (this.dyes.size() < this.targetAmount) {
            DyeColor dye = this.nextRandomDyeByHueValueDistance();
            this.addDye(dye);
            this.updateState();
            this.calculateRemainder();
        }
        if (this.targetAmount > 0 && this.dyes.size() != this.targetAmount) {
            return this.searchMix();
        }
        float chance = this.getSatisfactionChance();
        return this.remainder == null && chance > 0.05f || this.error == 0.0f && chance > 0.4f || this.error < 0.4f && chance > 0.7f;
    }

    private void addDye(DyeColor color) {
        this.dyes.add(color);
        float[] c = color.m_41068_();
        int r = (int)(c[0] * 255.0f);
        int g = (int)(c[1] * 255.0f);
        int b = (int)(c[2] * 255.0f);
        this.currentSum[0] = this.currentSum[0] + r;
        this.currentSum[1] = this.currentSum[1] + g;
        this.currentSum[2] = this.currentSum[2] + b;
    }

    private void updateState() {
        this.currentHueCoords[0] = (float)this.currentSum[0] / 255.0f / (float)this.dyes.size();
        this.currentHueCoords[1] = (float)this.currentSum[1] / 255.0f / (float)this.dyes.size();
        this.currentHueCoords[2] = (float)this.currentSum[2] / 255.0f / (float)this.dyes.size();
        this.currentValue = DyeMixGenerator.max3(this.currentHueCoords[0], this.currentHueCoords[1], this.currentHueCoords[2]);
        this.currentHueCoords[0] = this.currentHueCoords[0] / this.currentValue;
        this.currentHueCoords[1] = this.currentHueCoords[1] / this.currentValue;
        this.currentHueCoords[2] = this.currentHueCoords[2] / this.currentValue;
    }

    private void calculateRemainder() {
        this.error = 0.0f;
        if (Math.abs(this.currentValue - this.targetValue) < 1.0E-5f && Math.abs(this.currentHueCoords[0] - this.targetHueCoords[0]) + Math.abs(this.currentHueCoords[1] - this.targetHueCoords[1]) + Math.abs(this.currentHueCoords[2] - this.targetHueCoords[2]) < 3.0E-5f) {
            this.remainder = null;
            return;
        }
        int s = this.dyes.size();
        int S = s + 1;
        float v = this.correctFloat(this.targetValue * (float)S - this.currentValue * (float)s);
        float rF = this.correctFloat(this.targetHueCoords[0] * (float)S - this.currentHueCoords[0] * (float)s);
        float gF = this.correctFloat(this.targetHueCoords[1] * (float)S - this.currentHueCoords[1] * (float)s);
        float bF = this.correctFloat(this.targetHueCoords[2] * (float)S - this.currentHueCoords[2] * (float)s);
        int c = (int)(rF * 255.0f * v) & 0xFF;
        c = c << 8 | (int)(gF * 255.0f * v) & 0xFF;
        c = c << 8 | (int)(bF * 255.0f * v) & 0xFF;
        this.remainder = c;
    }

    private float correctFloat(float f) {
        if (f < 0.0f) {
            this.error += -f;
            return 0.0f;
        }
        if (f > 1.0f) {
            this.error += f - 1.0f;
            return 1.0f;
        }
        return f;
    }

    private static int max3(int r, int g, int b) {
        return Math.max(r, Math.max(g, b));
    }

    private static float max3(float r, float g, float b) {
        return Math.max(r, Math.max(g, b));
    }

    private static float value(DyeColor color) {
        float[] t = color.m_41068_();
        return DyeMixGenerator.max3(t[0], t[1], t[2]);
    }

    private static float[] hueCoords(DyeColor color) {
        float[] c = color.m_41068_();
        float v = DyeMixGenerator.value(color);
        return new float[]{c[0] / v, c[1] / v, c[2] / v};
    }

    private static float hueDistance(DyeColor color, float[] tc) {
        float[] cc = DyeMixGenerator.hueCoords(color);
        return Mth.m_14116_((float)(Mth.m_14207_((float)(cc[0] - tc[0])) + Mth.m_14207_((float)(cc[1] - tc[1])) + Mth.m_14207_((float)(cc[2] - tc[2]))));
    }

    private static float lightDistance(DyeColor color, float value) {
        return Mth.m_14154_((float)(DyeMixGenerator.value(color) - value));
    }

    private List<DyeColor> dyesByHueValueDistance() {
        return Arrays.stream(DyeColor.values()).sorted(Comparator.comparing(c -> Float.valueOf(DyeMixGenerator.hueDistance(c, this.targetHueCoords))).thenComparing(c -> Float.valueOf(DyeMixGenerator.lightDistance(c, this.targetValue)))).toList();
    }

    private int nextSortIndex() {
        return (int)(Math.abs(this.RANDOM.m_188583_()) * (double)1.2f * (double)(4.0f / (float)Math.min(4, this.remainingAttempts)));
    }

    private DyeColor nextRandomDyeByHueValueDistance() {
        List<DyeColor> sorted = this.dyesByHueValueDistance();
        return sorted.get(this.nextSortIndex() % sorted.size());
    }

    private void backtrackSome() {
        float min = Math.min(this.RANDOM.m_188501_(), this.RANDOM.m_188501_());
        int i = (int)(min * (float)this.dyes.size()) % this.dyes.size();
        this.dyes.subList(i, this.dyes.size()).clear();
        --this.remainingAttempts;
        Arrays.fill(this.currentSum, 0);
        for (int j = 0; j < i; ++j) {
            this.addDye(this.dyes.get(j));
            this.dyes.remove(this.dyes.size() - 1);
        }
        this.updateState();
    }

    private float getSatisfactionChance() {
        return this.RANDOM.m_188501_() / (1.0f + this.error * 0.8f);
    }

    public record DyeMix(@Nullable Integer remainder, List<DyeColor> dyes, float error) {
        public static DyeMix of(DyeColor ... colors) {
            return new DyeMix(null, Arrays.asList(colors), 0.0f);
        }

        public static DyeMix of(int rem, DyeColor ... colors) {
            return new DyeMix(rem, Arrays.asList(colors), 0.0f);
        }

        public List<DyeItem> getDyeItems() {
            return this.dyes.stream().map(DyeItem::m_41082_).toList();
        }

        public List<ItemStack> getDyeStacks() {
            return this.dyes.stream().map(DyeItem::m_41082_).map(ItemStack::new).toList();
        }
    }
}

