/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei;

import java.util.Collection;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public interface ContextualRecipeWrapper {
    @NotNull
    public Collection<Ingredient> getInputIngredients();

    @NotNull
    public Collection<Ingredient> getOutputIngredients();

    public boolean isOutputReachable(ItemStack var1);

    default public boolean isInputUsable(ItemStack input) {
        return true;
    }

    default public boolean matchesFocus(@NotNull IFocusGroup focus) {
        return this.matchesOutput(focus) || this.matchesInput(focus);
    }

    default public boolean matchesOutput(@NotNull IFocusGroup focus) {
        Collection<Ingredient> outputs = this.getOutputIngredients();
        return outputs.stream().anyMatch(out -> focus.getItemStackFocuses(RecipeIngredientRole.OUTPUT).anyMatch(f -> {
            ItemStack output = (ItemStack)f.getTypedValue().getIngredient();
            return out.test(output) && this.isOutputReachable(output);
        }));
    }

    default public boolean matchesInput(@NotNull IFocusGroup focus) {
        Collection<Ingredient> inputs = this.getInputIngredients();
        return inputs.stream().anyMatch(in -> focus.getItemStackFocuses(RecipeIngredientRole.INPUT).anyMatch(f -> {
            ItemStack input = (ItemStack)f.getTypedValue().getIngredient();
            return in.test(input) && this.isInputUsable(input);
        }));
    }
}

