/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei;

import endorh.aerobaticelytra.client.input.KeyHandler;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.recipe.CraftedUpgradeRecipe;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraRecipeManagerPlugin;
import endorh.aerobaticelytra.integration.jei.ContextualRecipeCategory;
import endorh.aerobaticelytra.integration.jei.category.BannerRecipeCategory;
import endorh.aerobaticelytra.integration.jei.category.BaseCategory;
import endorh.aerobaticelytra.integration.jei.category.DyeRecipeCategory;
import endorh.aerobaticelytra.integration.jei.category.JoinRecipeCategory;
import endorh.aerobaticelytra.integration.jei.category.SplitRecipeCategory;
import endorh.aerobaticelytra.integration.jei.category.TrailRecipeCategory;
import endorh.aerobaticelytra.integration.jei.category.UpgradeRecipeCategory;
import endorh.lazulib.recipe.RecipeManagerHelper;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class AerobaticElytraJeiPlugin
implements IModPlugin {
    public static final ResourceLocation pluginUid = new ResourceLocation("aerobaticelytra", "jei_plugin");
    public static IIngredientManager ingredientManager = null;
    public static IRecipeManager recipeManager = null;
    public static IJeiHelpers jeiHelpers = null;
    public static IGuiHelper guiHelper = null;
    protected static final List<Supplier<BaseCategory<?>>> categoryConstructors = (List)Util.m_137469_(new ArrayList(), l -> {
        l.add(UpgradeRecipeCategory::new);
        l.add(TrailRecipeCategory::new);
        l.add(DyeRecipeCategory::new);
        l.add(BannerRecipeCategory::new);
        l.add(SplitRecipeCategory::new);
        l.add(JoinRecipeCategory::new);
    });
    protected static final List<BaseCategory<?>> categories = new ArrayList();
    protected static List<ContextualRecipeCategory<?, ?>> contextualCategories = new ArrayList();

    @NotNull
    public ResourceLocation getPluginUid() {
        return pluginUid;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IJeiHelpers jeiHelpers = reg.getJeiHelpers();
        guiHelper = jeiHelpers.getGuiHelper();
        categories.clear();
        for (Supplier<BaseCategory<?>> c : categoryConstructors) {
            BaseCategory<?> cat = c.get();
            categories.add(cat);
            if (cat instanceof ContextualRecipeCategory) {
                ContextualRecipeCategory ct = (ContextualRecipeCategory)((Object)cat);
                contextualCategories.add(ct);
            }
            reg.addRecipeCategories(new IRecipeCategory[]{cat});
        }
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)AerobaticElytraItems.AEROBATIC_ELYTRA, (stack, context) -> switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case UidContext.Ingredient -> ElytraSpecCapability.getElytraSpecOrDefault(stack).getAbilities().entrySet().stream().sorted(Comparator.comparing(e -> ((IAbility)e.getKey()).getName())).map(e -> ((IAbility)e.getKey()).getName() + ":" + e.getValue()).collect(Collectors.joining(";"));
            case UidContext.Recipe -> "";
        });
    }

    public void registerRecipes(@NotNull IRecipeRegistration reg) {
        String keyName;
        String key = KeyHandler.FLIGHT_MODE.getKey().m_84874_();
        if (key.equals(keyName = I18n.m_118938_((String)key, (Object[])new Object[0]))) {
            keyName = keyName.replaceFirst("key\\.keyboard\\.", "");
        }
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtil.ttc((String)"aerobaticelytra.jei.info.aerobatic_elytra", (Object[])new Object[]{keyName})});
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        assert (world != null);
        RecipeManager recipeManager = world.m_7465_();
        for (BaseCategory<?> cat : categories) {
            AerobaticElytraJeiPlugin.registerRecipes(reg, recipeManager, cat);
        }
    }

    protected static <V> void registerRecipes(IRecipeRegistration reg, RecipeManager manager, BaseCategory<V> cat) {
        ingredientManager = reg.getIngredientManager();
        cat.registerRecipes(reg, manager);
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration reg) {
        reg.addRecipeTransferHandler(CraftingMenu.class, MenuType.f_39968_, JoinRecipeCategory.TYPE, 0, 9, 9, 36);
        reg.addRecipeTransferHandler(CraftingMenu.class, MenuType.f_39968_, SplitRecipeCategory.TYPE, 0, 9, 9, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA), new RecipeType[]{UpgradeRecipeCategory.TYPE});
        ItemStack craftingTable = new ItemStack((ItemLike)Items.f_41960_);
        reg.addRecipeCatalyst(craftingTable, new RecipeType[]{JoinRecipeCategory.TYPE, SplitRecipeCategory.TYPE, DyeRecipeCategory.TYPE, BannerRecipeCategory.TYPE, TrailRecipeCategory.TYPE});
        if (RecipeManagerHelper.getRecipeManager().m_44051_().stream().anyMatch(r -> r instanceof CraftedUpgradeRecipe)) {
            reg.addRecipeCatalyst(craftingTable, new RecipeType[]{UpgradeRecipeCategory.TYPE});
        }
    }

    public static <T> RecipeType<T> create(ResourceLocation location, Class<T> cls) {
        return RecipeType.create((String)location.m_135827_(), (String)location.m_135815_(), cls);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ingredientManager = jeiRuntime.getIngredientManager();
        recipeManager = jeiRuntime.getRecipeManager();
        jeiHelpers = jeiRuntime.getJeiHelpers();
    }

    public void registerAdvanced(@NotNull IAdvancedRegistration reg) {
        reg.addRecipeManagerPlugin((IRecipeManagerPlugin)new AerobaticElytraRecipeManagerPlugin(contextualCategories, reg.getJeiHelpers().getFocusFactory()));
    }
}

