/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.client.trail.AerobaticTrail;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.AerobaticElytraWingItem;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.recipe.JoinRecipe;
import endorh.aerobaticelytra.integration.jei.AerobaticElytraJeiPlugin;
import endorh.aerobaticelytra.integration.jei.gui.MultiIngredientDrawable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AerobaticElytraJeiHelper {
    public static final RandomSource RANDOM = new LegacyRandomSource(0L);
    protected static final ElytraDyement dyement = new ElytraDyement();

    public static List<ItemStack> getAerobaticElytras() {
        return AerobaticElytraJeiHelper.getAerobaticElytras(null, null, null);
    }

    public static List<ItemStack> getAerobaticElytras(InputDyementQuery dyementDataQuery) {
        return AerobaticElytraJeiHelper.getAerobaticElytras(dyementDataQuery, null, null);
    }

    public static List<ItemStack> getAerobaticElytras(TrailDataQuery trailDataQuery) {
        return AerobaticElytraJeiHelper.getAerobaticElytras(null, trailDataQuery, null);
    }

    public static List<ItemStack> getAerobaticElytras(@Nullable InputDyementQuery dyementQuery, @Nullable TrailDataQuery trailQuery, IFocusGroup focus) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            list.add(new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA));
            list.add(AerobaticElytraJeiHelper.makeElytra(AerobaticElytraJeiHelper.nextDyeColor()));
            list.add(AerobaticElytraJeiHelper.makeElytra(AerobaticElytraJeiHelper.nextDyeColor(), AerobaticElytraJeiHelper.nextDyeColor()));
            list.add(AerobaticElytraJeiHelper.makeElytra(AerobaticElytraJeiHelper.nextDyeColor(), Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()), Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()), Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()), Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor())));
            list.add(AerobaticElytraJeiHelper.makeElytra(AerobaticElytraJeiHelper.nextDyeColor(), (List)Util.m_137469_(new ArrayList(), w -> {
                w.add(Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()));
                w.add(Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()));
            }), AerobaticElytraJeiHelper.nextDyeColor(), (List)Util.m_137469_(new ArrayList(), w -> {
                w.add(Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()));
                w.add(Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()));
            })));
        }
        for (ItemStack itemStack : list) {
            IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(itemStack);
            IElytraSpec.TrailData data = AerobaticElytraJeiHelper.getTrailData(trailQuery);
            spec.getTrailData().read(data.write());
            spec.setAbility(IAbility.Ability.MAX_FUEL, 50.0f);
            spec.setAbility(IAbility.Ability.FUEL, 30.0f);
        }
        return list;
    }

    public static ItemStack applyDyement(ItemStack elytra, ElytraDyement dyement) {
        ItemStack copy = elytra.m_41777_();
        dyement.write(copy);
        return copy;
    }

    public static ItemStack applyTrail(ItemStack elytra, IElytraSpec.TrailData trail) {
        ItemStack copy = elytra.m_41777_();
        IElytraSpec.TrailData trailData = ElytraSpecCapability.getElytraSpecOrDefault(copy).getTrailData();
        trailData.read(trail.write());
        return copy;
    }

    public static List<ElytraDyement> makeDyements() {
        ArrayList<ElytraDyement> list = new ArrayList<ElytraDyement>();
        list.add(new ElytraDyement());
        list.add((ElytraDyement)Util.m_137469_((Object)new ElytraDyement(), d -> d.setColor(AerobaticElytraJeiHelper.nextDyeColor().m_41071_())));
        list.add((ElytraDyement)Util.m_137469_((Object)new ElytraDyement(), d -> {
            d.getWing(ElytraDyement.WingSide.LEFT).setColor(AerobaticElytraJeiHelper.nextDyeColor().m_41071_());
            d.getWing(ElytraDyement.WingSide.RIGHT).setColor(AerobaticElytraJeiHelper.nextDyeColor().m_41071_());
        }));
        list.add((ElytraDyement)Util.m_137469_((Object)new ElytraDyement(), d -> d.setPattern(AerobaticElytraJeiHelper.nextDyeColor(), AerobaticElytraJeiHelper.nextPatternLayers())));
        list.add((ElytraDyement)Util.m_137469_((Object)new ElytraDyement(), d -> {
            d.getWing(ElytraDyement.WingSide.LEFT).setPattern(AerobaticElytraJeiHelper.nextDyeColor(), AerobaticElytraJeiHelper.nextPatternLayers());
            d.getWing(ElytraDyement.WingSide.RIGHT).setPattern(AerobaticElytraJeiHelper.nextDyeColor(), AerobaticElytraJeiHelper.nextPatternLayers());
        }));
        return list;
    }

    public static DyeColor nextDyeColor() {
        return DyeColor.values()[RANDOM.m_188503_(DyeColor.values().length)];
    }

    public static BannerPattern nextPattern() {
        return (BannerPattern)((Holder.Reference)BuiltInRegistries.f_256878_.m_213642_(RANDOM).orElseThrow(() -> new IllegalStateException("No banner patterns registered"))).get();
    }

    public static List<Pair<BannerPattern, DyeColor>> nextPatternLayers() {
        ArrayList<Pair<BannerPattern, DyeColor>> list = new ArrayList<Pair<BannerPattern, DyeColor>>();
        int l = RANDOM.m_216339_(2, 6);
        for (int i = 0; i < l; ++i) {
            list.add((Pair<BannerPattern, DyeColor>)Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()));
        }
        return list;
    }

    public static ItemStack makeElytra(DyeColor color) {
        ItemStack e = new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA);
        dyement.read(e);
        dyement.setColor(color.m_41071_());
        dyement.write(e);
        return e;
    }

    public static ItemStack makeElytra(DyeColor leftColor, DyeColor rightColor) {
        ItemStack e = new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA);
        dyement.read(e);
        dyement.getWing(ElytraDyement.WingSide.LEFT).setColor(leftColor.m_41071_());
        dyement.getWing(ElytraDyement.WingSide.RIGHT).setColor(rightColor.m_41071_());
        dyement.write(e);
        return e;
    }

    @SafeVarargs
    public static ItemStack makeElytra(DyeColor base, Pair<BannerPattern, DyeColor> ... patterns) {
        ItemStack e = new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA);
        dyement.read(e);
        dyement.setPattern(base, Arrays.asList(patterns));
        dyement.write(e);
        return e;
    }

    public static ItemStack makeElytra(DyeColor baseLeft, List<Pair<BannerPattern, DyeColor>> leftPatterns, DyeColor baseRight, List<Pair<BannerPattern, DyeColor>> rightPatterns) {
        ItemStack e = new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA);
        dyement.read(e);
        dyement.getWing(ElytraDyement.WingSide.LEFT).setPattern(baseLeft, leftPatterns);
        dyement.getWing(ElytraDyement.WingSide.RIGHT).setPattern(baseRight, rightPatterns);
        dyement.write(e);
        return e;
    }

    public static Pair<ItemStack, ItemStack> split(ItemStack elytra) {
        Item item2 = elytra.m_41720_();
        if (!(item2 instanceof AerobaticElytraItem)) {
            throw new IllegalArgumentException("Cannot split non-elytra item");
        }
        AerobaticElytraItem item3 = (AerobaticElytraItem)item2;
        return Pair.of((Object)item3.getWing(elytra, ElytraDyement.WingSide.LEFT), (Object)item3.getWing(elytra, ElytraDyement.WingSide.RIGHT));
    }

    public static Pair<List<ItemStack>, List<ItemStack>> split(List<ItemStack> elytras) {
        ArrayList left = new ArrayList();
        ArrayList right = new ArrayList();
        elytras.stream().map(AerobaticElytraJeiHelper::split).forEachOrdered(p -> {
            left.add((ItemStack)p.getFirst());
            right.add((ItemStack)p.getSecond());
        });
        return Pair.of(left, right);
    }

    public static ItemStack makeBanner(DyeColor base, List<Pair<BannerPattern, DyeColor>> patterns) {
        ItemStack banner = new ItemStack((ItemLike)BannerBlock.m_49014_((DyeColor)base).m_5456_());
        dyement.read(banner);
        dyement.setPattern(base, patterns);
        dyement.write(banner);
        return banner;
    }

    public static List<ItemStack> getBanners() {
        return (List)Util.m_137469_(new ArrayList(), l -> {
            for (int i = 0; i < 5; ++i) {
                int j = 0;
                while (j < 4) {
                    int fj = j++;
                    l.add(AerobaticElytraJeiHelper.makeBanner(AerobaticElytraJeiHelper.nextDyeColor(), (List)Util.m_137469_(new ArrayList(), p -> {
                        for (int k = 1; k <= fj; ++k) {
                            p.add(Pair.of((Object)AerobaticElytraJeiHelper.nextPattern(), (Object)AerobaticElytraJeiHelper.nextDyeColor()));
                        }
                    })));
                }
            }
        });
    }

    public static List<DyeColor> getDyeColors(int size) {
        return (List)Util.m_137469_(new ArrayList(), l -> {
            for (int i = 0; i < size; ++i) {
                l.add(AerobaticElytraJeiHelper.nextDyeColor());
            }
        });
    }

    public static ItemStack makeRocket(IElytraSpec.RocketStar[] stars) {
        ItemStack rocket = new ItemStack((ItemLike)Items.f_42688_);
        CompoundTag fireworks = rocket.m_41698_("Fireworks");
        fireworks.m_128365_("Explosions", (Tag)IElytraSpec.RocketStar.listAsNBT(stars));
        return rocket;
    }

    public static IElytraSpec.RocketStar[] getRocketStars(ItemStack rocket) {
        CompoundTag tag = rocket.m_41737_("Fireworks");
        if (tag != null && tag.m_128441_("Explosions")) {
            return IElytraSpec.RocketStar.listFromNBT(tag.m_128437_("Explosions", 10));
        }
        return new IElytraSpec.RocketStar[0];
    }

    public static ItemStack makeRocket() {
        return AerobaticElytraJeiHelper.makeRocket(AerobaticElytraJeiHelper.makeRocketStars());
    }

    public static List<IElytraSpec.TrailData> makeTrails() {
        ArrayList<IElytraSpec.TrailData> list = new ArrayList<IElytraSpec.TrailData>();
        list.add(IElytraSpec.TrailData.empty());
        IElytraSpec.RocketStar[] stars = AerobaticElytraJeiHelper.makeRocketStars();
        IElytraSpec.TrailData data = IElytraSpec.TrailData.empty();
        data.put(AerobaticTrail.RocketSide.LEFT, stars);
        data.put(AerobaticTrail.RocketSide.RIGHT, stars);
        list.add(data);
        list.add(AerobaticElytraJeiHelper.makeTrailData(EnumSet.of(AerobaticTrail.RocketSide.LEFT, AerobaticTrail.RocketSide.RIGHT)));
        data = data.copy();
        stars = AerobaticElytraJeiHelper.makeRocketStars();
        data.put(AerobaticTrail.RocketSide.LEFT, stars);
        data.put(AerobaticTrail.RocketSide.RIGHT, stars);
        stars = AerobaticElytraJeiHelper.makeRocketStars();
        data.put(AerobaticTrail.RocketSide.CENTER_LEFT, stars);
        data.put(AerobaticTrail.RocketSide.CENTER_RIGHT, stars);
        list.add(data);
        list.add(AerobaticElytraJeiHelper.makeTrailData(EnumSet.allOf(AerobaticTrail.RocketSide.class)));
        return list;
    }

    public static IElytraSpec.TrailData makeTrailData() {
        IElytraSpec.TrailData trail = IElytraSpec.TrailData.empty();
        for (AerobaticTrail.RocketSide side : AerobaticTrail.RocketSide.values()) {
            if (!(RANDOM.m_188501_() > 0.5f)) continue;
            trail.put(side, AerobaticElytraJeiHelper.makeRocketStars());
        }
        return trail;
    }

    public static IElytraSpec.TrailData makeTrailData(Set<AerobaticTrail.RocketSide> mask) {
        IElytraSpec.TrailData trail = IElytraSpec.TrailData.empty();
        for (AerobaticTrail.RocketSide side : mask) {
            trail.put(side, AerobaticElytraJeiHelper.makeRocketStars());
        }
        return trail;
    }

    public static IElytraSpec.RocketStar[] makeRocketStars() {
        ArrayList<IElytraSpec.RocketStar> list = new ArrayList<IElytraSpec.RocketStar>();
        int e = RANDOM.m_188503_(2) + 1;
        for (int j = 0; j < e; ++j) {
            list.add(new IElytraSpec.RocketStar(AerobaticElytraJeiHelper.getDyeColors(RANDOM.m_188503_(3)), AerobaticElytraJeiHelper.getDyeColors(RANDOM.m_188503_(3)), RANDOM.m_188501_() > 0.7f, RANDOM.m_188501_() > 0.7f, (byte)RANDOM.m_188503_(5)));
        }
        return (IElytraSpec.RocketStar[])list.toArray(IElytraSpec.RocketStar[]::new);
    }

    public static List<ItemStack> getRockets(AerobaticTrail.RocketSide side, TrailDataQuery query, IFocusGroup focus) {
        if (!query.mask().contains((Object)side)) {
            return Collections.emptyList();
        }
        if (query.clear()) {
            return ImmutableList.of((Object)new ItemStack((ItemLike)Items.f_42688_));
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack rocket = AerobaticElytraJeiHelper.getSingleFocusStack(focus, Items.f_42688_, RecipeIngredientRole.INPUT);
        if (!rocket.m_41619_() && AerobaticElytraJeiHelper.getRocketStars(rocket).length > 0) {
            return List.of(rocket);
        }
        ItemStack outElytra = AerobaticElytraJeiHelper.getSingleFocusStack(focus, (Item i) -> i instanceof AerobaticElytraItem, RecipeIngredientRole.OUTPUT);
        if (!outElytra.m_41619_()) {
            IElytraSpec.TrailData outTrail = ElytraSpecCapability.getElytraSpecOrDefault(outElytra).getTrailData();
            if (outTrail.get(side).length > 0) {
                list.add(AerobaticElytraJeiHelper.makeRocket(outTrail.get(side)));
            } else {
                list.add(new ItemStack((ItemLike)Items.f_42688_));
            }
        } else {
            for (int i2 = 0; i2 < 20; ++i2) {
                list.add(AerobaticElytraJeiHelper.makeRocket());
            }
        }
        return list;
    }

    @NotNull
    public static ItemStack getSingleFocusStack(IFocusGroup focuses, Predicate<Item> p, RecipeIngredientRole role) {
        return focuses.getItemStackFocuses(role).flatMap(f -> f.getTypedValue().getItemStack().stream()).filter(ss -> p.test(ss.m_41720_())).findFirst().orElse(ItemStack.f_41583_);
    }

    @NotNull
    public static ItemStack getSingleFocusStack(IFocusGroup focuses, Item item2, RecipeIngredientRole role) {
        return AerobaticElytraJeiHelper.getSingleFocusStack(focuses, (Item i) -> i == item2, role);
    }

    @NotNull
    public static ItemStack getSingleFocusElytraOrWings(IFocusGroup focuses, RecipeIngredientRole role) {
        return AerobaticElytraJeiHelper.getSingleFocusStack(focuses, (Item p) -> p instanceof AerobaticElytraItem || p instanceof AerobaticElytraWingItem, role);
    }

    public static IElytraSpec.TrailData getTrailData(TrailDataQuery query) {
        return query != null && query.clear() ? AerobaticElytraJeiHelper.makeTrailData(query.mask()) : AerobaticElytraJeiHelper.makeTrailData();
    }

    public static List<Pair<IElytraSpec.TrailData, IElytraSpec.TrailData>> getRocketsMatchingFocus(Stream<IFocus<ItemStack>> focuses, Set<AerobaticTrail.RocketSide> mask, int variations) {
        ArrayList<Pair<IElytraSpec.TrailData, IElytraSpec.TrailData>> list = new ArrayList<Pair<IElytraSpec.TrailData, IElytraSpec.TrailData>>();
        focuses.forEach(f -> {
            block3: {
                ItemStack stack;
                RecipeIngredientRole role;
                block4: {
                    role = f.getRole();
                    stack = (ItemStack)f.getTypedValue().getIngredient();
                    if (!(stack.m_41720_() instanceof AerobaticElytraItem)) break block3;
                    if (role != RecipeIngredientRole.INPUT) break block4;
                    IElytraSpec.TrailData trail = ElytraSpecCapability.getElytraSpecOrDefault(stack).getTrailData();
                    for (int i = 0; i < variations; ++i) {
                        list.add(Pair.of((Object)trail, (Object)AerobaticElytraJeiHelper.makeTrailData(mask)));
                    }
                    break block3;
                }
                if (role != RecipeIngredientRole.OUTPUT) break block3;
                IElytraSpec.TrailData trail = ElytraSpecCapability.getElytraSpecOrDefault(stack).getTrailData();
                for (int i = 0; i < variations; ++i) {
                    IElytraSpec.TrailData src = IElytraSpec.TrailData.empty();
                    for (AerobaticTrail.RocketSide side : mask) {
                        src.put(side, AerobaticElytraJeiHelper.makeRocketStars());
                    }
                    list.add(Pair.of((Object)src, (Object)trail));
                }
            }
        });
        return list.isEmpty() ? AerobaticElytraJeiHelper.getRockets(mask, variations) : list;
    }

    public static List<ItemStack> getRockets(int amount) {
        return IntStream.range(0, amount).mapToObj(i -> AerobaticElytraJeiHelper.makeRocket(AerobaticElytraJeiHelper.makeRocketStars())).toList();
    }

    public static List<Pair<IElytraSpec.TrailData, IElytraSpec.TrailData>> getRockets(Set<AerobaticTrail.RocketSide> sides, int variations) {
        return IntStream.range(0, variations).mapToObj(i -> {
            IElytraSpec.TrailData trail = IElytraSpec.TrailData.empty();
            for (AerobaticTrail.RocketSide side : sides) {
                trail.put(side, AerobaticElytraJeiHelper.makeRocketStars());
            }
            return Pair.of((Object)IElytraSpec.TrailData.empty(), (Object)trail);
        }).toList();
    }

    public static List<ItemStack> getAerobaticElytrasMatchingFocus(Stream<IFocus<ItemStack>> focuses) {
        return AerobaticElytraJeiHelper.getAerobaticElytrasMatchingFocus(focuses, null);
    }

    public static List<ItemStack> getAerobaticElytrasMatchingFocus(Stream<IFocus<ItemStack>> focuses, @Nullable TrailDataQuery trailQuery) {
        ArrayList list = new ArrayList();
        focuses.forEach(f -> {
            ItemStack focusStack = (ItemStack)f.getTypedValue().getIngredient();
            if (focusStack.m_41720_() instanceof AerobaticElytraItem) {
                ItemStack elytra = focusStack.m_41777_();
                elytra.m_41721_(0);
                list.add(elytra);
            } else if (focusStack.m_41720_() instanceof AerobaticElytraWingItem) {
                ItemStack right = focusStack.m_41777_();
                right.m_41721_(0);
                List leftWings = AerobaticElytraJeiHelper.getAerobaticElytras(trailQuery).stream().map(s -> ((AerobaticElytraItem)s.m_41720_()).getWing((ItemStack)s, ElytraDyement.WingSide.LEFT)).collect(Collectors.toList());
                leftWings.add(0, right.m_41777_());
                leftWings.stream().map(w -> {
                    ItemStack l = right.m_41777_();
                    dyement.read((ItemStack)w);
                    dyement.write(l);
                    return JoinRecipe.join(l, right);
                }).forEach(list::add);
            }
        });
        return list.isEmpty() ? AerobaticElytraJeiHelper.getAerobaticElytras(trailQuery) : list;
    }

    public static <T> List<T> randomSample(List<T> pool, int copies) {
        ArrayList<T> result = new ArrayList<T>();
        int s = copies * pool.size();
        for (int i = 0; i < s; ++i) {
            result.add(pool.get(RANDOM.m_188503_(pool.size())));
        }
        return result;
    }

    public static int gcd(int a, int b) {
        return b == 0 ? a : AerobaticElytraJeiHelper.gcd(b, a % b);
    }

    public static int mcm(int a, int b) {
        return a * b / AerobaticElytraJeiHelper.gcd(a, b);
    }

    public static <V> IDrawable createMultiIngredientDrawable(IIngredientType<V> type, V first, V second) {
        return new MultiIngredientDrawable<V>(first, second, AerobaticElytraJeiPlugin.ingredientManager.getIngredientRenderer(type));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface InputDyementQuery {
    }

    public record TrailDataQuery(Set<AerobaticTrail.RocketSide> mask, boolean clear) {
    }

    public record InputBannerQuery() implements InputDyementQuery
    {
    }

    public record InputDyeQuery(int amount) implements InputDyementQuery
    {
    }
}

