/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.colytra;

import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.caelus.api.CaelusApi;

public class ColytraIntegration {
    public static final AttributeModifier COLYTRA_CAELUS_FLIGHT_MODIFIER = new AttributeModifier(UUID.fromString("668bdbee-32b6-4c4b-bf6a-5a30f4d02e37"), "Flight modifier", 1.0, AttributeModifier.Operation.ADDITION);

    public static ItemStack getColytraSubItem(ItemStack chest) {
        ItemStack elytra;
        CompoundTag colytraTag = chest.m_41737_("colytra:ElytraUpgrade");
        if (colytraTag != null && (elytra = ItemStack.m_41712_((CompoundTag)colytraTag)).m_41720_() instanceof AerobaticElytraItem) {
            return elytra;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getColytraSubItem(LivingEntity entity) {
        return ColytraIntegration.getColytraSubItem(entity.m_6844_(EquipmentSlot.CHEST));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (!(chest.m_41720_() instanceof ArmorItem)) {
            return;
        }
        ItemStack elytra = ColytraIntegration.getColytraSubItem(chest);
        if (elytra.m_41619_()) {
            return;
        }
        assert (elytra.m_41720_() instanceof AerobaticElytraItem);
        AttributeInstance flightAttribute = player.m_21051_(CaelusApi.getInstance().getFlightAttribute());
        assert (flightAttribute != null);
        flightAttribute.m_22130_(COLYTRA_CAELUS_FLIGHT_MODIFIER);
        if (elytra.m_41720_().canElytraFly(elytra, (LivingEntity)player)) {
            flightAttribute.m_22118_(COLYTRA_CAELUS_FLIGHT_MODIFIER);
        }
    }
}

