/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.integration.caelus;

import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.caelus.api.CaelusApi;

public class CaelusIntegration {
    private static final Attribute CAELUS_FLIGHT_ATTRIBUTE = CaelusApi.getInstance().getFlightAttribute();
    private static final AttributeModifier CAELUS_FLIGHT_MODIFIER = new AttributeModifier(UUID.fromString("c433b7b2-7811-4c9a-b891-14bbed6d3dae"), "Aerobatic Elytra Flight", 1.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean hasCurioElytra;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        AttributeInstance flight = player.m_21051_(CAELUS_FLIGHT_ATTRIBUTE);
        if (flight == null) {
            return;
        }
        boolean bl = hasCurioElytra = AerobaticElytraLogic.hasAerobaticElytra(player) && !(player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof AerobaticElytraItem);
        if (hasCurioElytra) {
            if (!flight.m_22109_(CAELUS_FLIGHT_MODIFIER)) {
                flight.m_22118_(CAELUS_FLIGHT_MODIFIER);
            }
        } else if (flight.m_22109_(CAELUS_FLIGHT_MODIFIER)) {
            flight.m_22130_(CAELUS_FLIGHT_MODIFIER);
        }
    }
}

