/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.debug;

import endorh.aerobaticelytra.common.capability.AerobaticDataCapability;
import endorh.aerobaticelytra.common.capability.IAerobaticData;
import endorh.aerobaticelytra.common.flight.VectorBase;
import endorh.aerobaticelytra.common.flight.WeatherData;
import endorh.aerobaticelytra.debug.Debug;
import endorh.lazulib.math.Vec3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class DebugOverlay {
    public static float sound = 0.0f;
    public static float animation = 0.0f;

    @SubscribeEvent
    public static void onDebugScreenRenderEvent(CustomizeGuiOverlayEvent.DebugText event) {
        if (Debug.DEBUG.enabled && !Minecraft.m_91087_().f_91066_.f_92063_) {
            event.getLeft().addAll(DebugOverlay.getLeftInfo());
            event.getRight().addAll(DebugOverlay.getRightInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLeftInfo() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("Loaded regions: ");
        Map<Level, Map<Pair<Long, Long>, WeatherData.WeatherRegion>> map = WeatherData.weatherRegions;
        synchronized (map) {
            for (Level world : WeatherData.weatherRegions.keySet()) {
                Map<Pair<Long, Long>, WeatherData.WeatherRegion> worldRegions;
                Map<Pair<Long, Long>, WeatherData.WeatherRegion> map2 = worldRegions = WeatherData.weatherRegions.get(world);
                synchronized (map2) {
                    ret.add(String.format("  World: %s: %d", world, worldRegions.size()));
                }
            }
        }
        ret.add("");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault((Player)player);
            ret.add(String.format("yaw:  %.2f", Float.valueOf(player.m_146908_())));
            ret.add(String.format("yawh: %.2f", Float.valueOf(player.m_6080_())));
            ret.add("");
            ret.add(String.format("Lift cut: %.2f", Float.valueOf(data.getLiftCut())));
            ret.add("");
            ret.add(String.format("Look Yaw: %.2f", Float.valueOf(data.getLookAroundYaw())));
            ret.add(String.format("Look Pitch: %.2f", Float.valueOf(data.getLookAroundPitch())));
        }
        ret.add("");
        ret.add(String.format("Sound: %.2f", Float.valueOf(sound)));
        ret.add(String.format("Animation: %.2f", Float.valueOf(animation)));
        ret.add("");
        return ret;
    }

    public static List<String> getRightInfo() {
        Player player = Debug.DEBUG.getTargetPlayer();
        assert (player != null);
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("Debuggee: " + player.m_6302_());
        ret.add("");
        IAerobaticData data = AerobaticDataCapability.getAerobaticDataOrDefault(player);
        VectorBase rotation = data.getRotationBase();
        ret.add("Look: " + rotation.look.toString());
        ret.add("Normal: " + rotation.normal.toString());
        ret.add("Roll: " + rotation.roll.toString());
        ret.add("");
        ret.add(String.format("Tilt Pitch: %+2.3f", Float.valueOf(data.getTiltPitch())));
        ret.add(String.format("Tilt Roll: %+2.3f", Float.valueOf(data.getTiltRoll())));
        ret.add(String.format("Tilt Yaw: %+2.3f", Float.valueOf(data.getTiltYaw())));
        ret.add("");
        float pitch = player.m_146909_();
        ret.add(String.format("Yaw: %+2.3f", Float.valueOf((player.m_146908_() % 360.0f + 720.0f) % 360.0f)));
        if (Math.abs(pitch) >= 89.9f) {
            ret.add(String.format(">> Pitch: %+2.3f", Float.valueOf(player.m_146909_())));
        } else {
            ret.add(String.format("Pitch: %+2.3f", Float.valueOf(player.m_146909_())));
        }
        ret.add(String.format("Roll: %+2.3f", Float.valueOf(data.getRotationRoll())));
        ret.add("");
        WeatherData.WindRegion node = WeatherData.WindRegion.of(player.m_9236_(), WeatherData.WeatherRegion.scale(player.m_20185_()), WeatherData.WeatherRegion.scale(player.m_20189_()));
        ret.add("Wind: " + node.wind);
        ret.add("Angular Wind: " + node.angularWind);
        ret.add(String.format("Affected by weather: %b", data.isAffectedByWeather()));
        ret.add("");
        ret.add(String.format("Speed: %.2f", player.m_20184_().m_82553_()));
        ret.add(String.format("Motion: %s", new Vec3f(player.m_20184_())));
        ret.add("");
        ret.add(String.format("Last trail pos: %s", data.getLastTrailPos().toString()));
        ret.add("");
        return ret;
    }
}

