/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.debug;

import endorh.aerobaticelytra.debug.DebugOverlay;
import endorh.aerobaticelytra.debug.DebugTicker;
import endorh.lazulib.network.PacketBufferUtil;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;

public class Debug {
    public static Debug DEBUG = new Debug();
    private static boolean registered = false;
    public boolean enabled = false;
    public boolean suppressParticles;
    public boolean invertFreeze;
    public boolean persistentParticles = false;
    public float freezeParticleSpeed = 1.0f;
    public float particleSpeed = 0.1f;
    public UUID targetPlayer = null;

    public static void register() {
        if (registered || !Debug.DEBUG.enabled) {
            return;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register(DebugOverlay.class));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> MinecraftForge.EVENT_BUS.register(DebugTicker.class));
        registered = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Player getTargetPlayer() {
        Minecraft mc = Minecraft.m_91087_();
        if (this.targetPlayer == null || mc.f_91073_ == null) {
            return mc.f_91074_;
        }
        Player player = mc.f_91073_.m_46003_(this.targetPlayer);
        return player == null ? mc.f_91074_ : player;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeBoolean(this.enabled);
        buf.writeBoolean(this.suppressParticles);
        buf.writeBoolean(this.invertFreeze);
        buf.writeBoolean(this.persistentParticles);
        buf.writeFloat(this.freezeParticleSpeed);
        buf.writeFloat(this.particleSpeed);
        PacketBufferUtil.writeNullable((FriendlyByteBuf)buf, (Object)this.targetPlayer, FriendlyByteBuf::m_130077_);
    }

    public static Debug deserialize(FriendlyByteBuf buf) {
        Debug d = new Debug();
        d.enabled = buf.readBoolean();
        d.suppressParticles = buf.readBoolean();
        d.invertFreeze = buf.readBoolean();
        d.persistentParticles = buf.readBoolean();
        d.freezeParticleSpeed = buf.readFloat();
        d.particleSpeed = buf.readFloat();
        d.targetPlayer = (UUID)PacketBufferUtil.readNullable((FriendlyByteBuf)buf, FriendlyByteBuf::m_130259_);
        return d;
    }

    public static void update(Debug debug) {
        DEBUG = debug;
        Debug.register();
    }
}

