/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.registry;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.IEffectAbility;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="aerobaticelytra")
public class JsonAbilityManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = Deserializers.m_78798_().registerTypeAdapter(IEffectAbility.EffectAbility.class, (Object)new IEffectAbility.EffectAbility.Deserializer()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public JsonAbilityManager() {
        super(GSON, "aerobaticelytra-abilities");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        AerobaticElytraRegistries.reloadDatapackAbilities(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (IEffectAbility.EffectAbility)GSON.fromJson((JsonElement)e.getValue(), IEffectAbility.EffectAbility.class))));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !AerobaticElytraLogic.hasAerobaticElytra(event.player) || event.side != LogicalSide.SERVER) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ItemStack elytra = AerobaticElytraLogic.getAerobaticElytra((LivingEntity)player);
        if (elytra.m_41619_()) {
            return;
        }
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(elytra);
        Map<IEffectAbility, Boolean> abilities = spec.getEffectAbilities();
        if (!abilities.isEmpty()) {
            LootContext ctx = JsonAbilityManager.createEffectAbilityLootContext(player);
            for (IEffectAbility ability : abilities.keySet()) {
                boolean using = abilities.get(ability);
                if (spec.getAbility(ability) > 0.0f && ability.testConditions(ctx)) {
                    if (!using) {
                        ability.applyEffect(player);
                        abilities.put(ability, true);
                    } else {
                        ability.reapplyEffect(player);
                    }
                    if (ability.getConsumption() == 0.0f) continue;
                    spec.setAbility(ability, Math.max(0.0f, spec.getAbility(ability) - ability.getConsumption()));
                    continue;
                }
                if (!using) continue;
                ability.undoEffect(player);
                abilities.put(ability, false);
            }
        }
    }

    public static LootParams createEffectAbilityLootParams(ServerPlayer player) {
        return new LootParams.Builder(player.m_284548_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81416_);
    }

    public static LootContext createEffectAbilityLootContext(ServerPlayer player) {
        return new LootContext.Builder(JsonAbilityManager.createEffectAbilityLootParams(player)).m_287259_(new ResourceLocation("default"));
    }
}

