/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.registry;

import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.common.event.AerobaticElytraAbilitiesReloadedEvent;
import endorh.aerobaticelytra.common.flight.mode.FlightModes;
import endorh.aerobaticelytra.common.flight.mode.IFlightMode;
import endorh.aerobaticelytra.common.item.AbilityReloadManager;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.item.IDatapackAbility;
import endorh.aerobaticelytra.common.item.IEffectAbility;
import endorh.aerobaticelytra.common.recipe.UpgradeRecipe;
import endorh.lazulib.math.MathHighlighter;
import endorh.lazulib.math.MathParser;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
public class AerobaticElytraRegistries {
    private static final Logger LOGGER = LogManager.getLogger();
    public static IForgeRegistry<IFlightMode> FLIGHT_MODE_REGISTRY;
    public static List<IFlightMode> FLIGHT_MODE_LIST;
    public static ResourceKey<Registry<IFlightMode>> FLIGHT_MODE_REGISTRY_KEY;
    private static IForgeRegistry<IAbility> ABILITY_REGISTRY;
    public static ResourceKey<Registry<IAbility>> ABILITY_REGISTRY_KEY;
    private static final Map<ResourceLocation, IAbility> ABILITIES;
    private static final Map<ResourceLocation, IDatapackAbility> DATAPACK_ABILITIES;
    private static final Map<ResourceLocation, IEffectAbility> EFFECT_ABILITIES;
    private static final Map<IAbility, ResourceLocation> ABILITY_NAMES;
    private static final Map<String, IAbility> JSON_TO_ABILITY;
    private static final Set<IDatapackAbility> OUTDATED_ABILITIES;
    public static MathParser.ExpressionParser<Double> ABILITY_EXPRESSION_PARSER;
    public static MathHighlighter.UnicodeMathSyntaxHighlightParser ABILITY_EXPRESSION_HIGHLIGHTER;

    @Nullable
    public static ResourceLocation getAbilityKey(IAbility ability) {
        return ABILITY_NAMES.get(ability);
    }

    @Nullable
    public static IAbility getAbility(ResourceLocation id) {
        return ABILITIES.get(id);
    }

    public static Map<ResourceLocation, IAbility> getAbilities() {
        return Collections.unmodifiableMap(ABILITIES);
    }

    public static Map<ResourceLocation, IEffectAbility> getEffectAbilities() {
        return Collections.unmodifiableMap(EFFECT_ABILITIES);
    }

    @Nullable
    public static IAbility getAbilityByName(String name) {
        return JSON_TO_ABILITY.get(name);
    }

    public static boolean hasAbilityName(String jsonName) {
        return JSON_TO_ABILITY.containsKey(jsonName);
    }

    public static Map<String, IAbility> getAbilitiesByName() {
        return Collections.unmodifiableMap(JSON_TO_ABILITY);
    }

    public static Set<IDatapackAbility> getOutdatedAbilities() {
        return Collections.unmodifiableSet(OUTDATED_ABILITIES);
    }

    public static Map<ResourceLocation, IDatapackAbility> getDatapackAbilities() {
        return Collections.unmodifiableMap(DATAPACK_ABILITIES);
    }

    @SubscribeEvent
    public static void onNewRegistry(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(AerobaticElytra.prefix("flight_modes")).allowModification().onBake(AerobaticElytraRegistries::onFlightModeRegistryBake), r -> {
            FLIGHT_MODE_REGISTRY = r;
            FLIGHT_MODE_REGISTRY_KEY = r.getRegistryKey();
        });
        event.create(new RegistryBuilder().setName(AerobaticElytra.prefix("ability")).allowModification().onBake(AerobaticElytraRegistries::onAbilityRegistryBake), r -> {
            ABILITY_REGISTRY = r;
            ABILITY_REGISTRY_KEY = r.getRegistryKey();
        });
        AerobaticElytra.logRegistered("Registries");
    }

    public static void onFlightModeRegistryBake(IForgeRegistryInternal<IFlightMode> owner, RegistryManager stage) {
        FLIGHT_MODE_LIST = new ArrayList<IFlightMode>(owner.getValues());
        FLIGHT_MODE_LIST.sort(Comparator.comparingInt(IFlightMode::getRegistryOrder));
    }

    public static void onAbilityRegistryBake(IForgeRegistryInternal<IAbility> owner, RegistryManager stage) {
        AerobaticElytraRegistries.bakeAbilities();
    }

    public static void reloadDatapackAbilities(Map<ResourceLocation, ? extends IDatapackAbility> abilities) {
        OUTDATED_ABILITIES.addAll(DATAPACK_ABILITIES.values());
        DATAPACK_ABILITIES.clear();
        DATAPACK_ABILITIES.putAll(abilities);
        AerobaticElytraRegistries.bakeAbilities();
    }

    private static void bakeAbilities() {
        ABILITIES.clear();
        ABILITY_NAMES.clear();
        JSON_TO_ABILITY.clear();
        EFFECT_ABILITIES.clear();
        for (Map.Entry entry : ABILITY_REGISTRY.getEntries()) {
            ABILITIES.put(((ResourceKey)entry.getKey()).m_135782_(), (IAbility)entry.getValue());
            ABILITY_NAMES.put((IAbility)entry.getValue(), ((ResourceKey)entry.getKey()).m_135782_());
        }
        for (Map.Entry entry : DATAPACK_ABILITIES.entrySet()) {
            if (ABILITIES.containsKey(entry.getKey())) {
                LOGGER.warn("Datapack Aerobatic Elytra Ability conflicts with one already defined by a mod: \"" + entry.getKey() + "\". The datapack one will be ignored");
                continue;
            }
            ABILITIES.put((ResourceLocation)entry.getKey(), (IAbility)entry.getValue());
            ABILITY_NAMES.put((IAbility)entry.getValue(), (ResourceLocation)entry.getKey());
        }
        HashMap<CallSite, ChatFormatting> abilityColors = new HashMap<CallSite, ChatFormatting>();
        HashMap<CallSite, MutableComponent> hashMap = new HashMap<CallSite, MutableComponent>();
        for (ResourceLocation id : ABILITIES.keySet()) {
            String namespace = id.m_135827_();
            IAbility ability = ABILITIES.get(id);
            String fullName = namespace + ":" + ability.getName();
            JSON_TO_ABILITY.put(fullName, ability);
            abilityColors.put((CallSite)((Object)fullName), ability.getColor());
            hashMap.put((CallSite)((Object)fullName), ability.getDisplayName());
            if (!(ability instanceof IEffectAbility)) continue;
            EFFECT_ABILITIES.put(id, (IEffectAbility)ability);
        }
        MathParser.FixedNamespaceSet namespaceSet = MathParser.FixedNamespaceSet.of(JSON_TO_ABILITY.keySet());
        ABILITY_EXPRESSION_PARSER = new MathParser.UnicodeMathDoubleExpressionParser(namespaceSet);
        ABILITY_EXPRESSION_HIGHLIGHTER = new MathHighlighter.UnicodeMathSyntaxHighlightParser(abilityColors, hashMap);
        for (Map.Entry entry : namespaceSet.getShortcuts().entrySet()) {
            Pair pair = (Pair)entry.getValue();
            String name = ((String)pair.getKey()).replace('`', '_') + ":" + (String)pair.getValue();
            JSON_TO_ABILITY.put((String)entry.getKey(), JSON_TO_ABILITY.get(name));
        }
        UpgradeRecipe.onAbilityReload();
        AbilityReloadManager.onAbilityReload();
        MinecraftForge.EVENT_BUS.post((Event)new AerobaticElytraAbilitiesReloadedEvent());
    }

    @SubscribeEvent
    public static void onRegisterFlightModes(RegisterEvent event) {
        event.register(FLIGHT_MODE_REGISTRY_KEY, h -> {
            for (FlightModes mode : FlightModes.values()) {
                h.register(AerobaticElytra.prefix(mode.name().toLowerCase()), (Object)mode);
            }
            AerobaticElytra.logRegistered("Flight Modes");
        });
        event.register(ABILITY_REGISTRY_KEY, h -> {
            for (IAbility.Ability ability : IAbility.Ability.values()) {
                h.register(AerobaticElytra.prefix(ability.name().toLowerCase()), (Object)ability);
            }
            AerobaticElytra.logRegistered("Abilities");
        });
    }

    static {
        ABILITIES = new HashMap<ResourceLocation, IAbility>();
        DATAPACK_ABILITIES = new HashMap<ResourceLocation, IDatapackAbility>();
        EFFECT_ABILITIES = new HashMap<ResourceLocation, IEffectAbility>();
        ABILITY_NAMES = new HashMap<IAbility, ResourceLocation>();
        JSON_TO_ABILITY = new HashMap<String, IAbility>();
        OUTDATED_ABILITIES = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    }
}

