/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import com.google.gson.JsonObject;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.recipe.ItemSelector;
import endorh.aerobaticelytra.common.registry.AerobaticElytraRegistries;
import endorh.lazulib.network.PacketBufferUtil;
import endorh.lazulib.recipe.RecipeManagerHelper;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeRecipe
extends CustomRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    protected static final RecipeManagerHelper.CachedRecipeProvider<Collection<UpgradeRecipe>> recipeProvider = new RecipeManagerHelper.CachedRecipeProvider<Collection<UpgradeRecipe>>(){

        protected Collection<UpgradeRecipe> onReload(RecipeManager manager) {
            return manager.m_44051_().stream().filter(r -> r instanceof UpgradeRecipe && ((UpgradeRecipe)((Object)r)).isValid()).map(r -> (UpgradeRecipe)((Object)r)).sorted(Comparator.comparing(r -> r.getSelectors().stream().map(ItemSelector::toString).collect(Collectors.joining(";")))).collect(Collectors.toList());
        }
    };
    protected final List<ItemSelector> ingredients;
    protected final List<IElytraSpec.Upgrade> upgrades;
    protected final ElytraRequirement requirement;
    protected final boolean lenient;
    protected boolean valid;
    protected static final Map<ResourceLocation, WeakReference<UpgradeRecipe>> INSTANCES = Collections.synchronizedMap(new WeakHashMap());
    private static final Logger LOGGER = LogManager.getLogger();

    public static Collection<UpgradeRecipe> getUpgradeRecipes() {
        return (Collection)recipeProvider.get();
    }

    public static Optional<UpgradeRecipe> getUpgradeRecipe(ItemStack elytra, ItemStack ingredient) {
        return UpgradeRecipe.getUpgradeRecipes().stream().filter(recipe -> recipe.matches(elytra, ingredient)).findFirst();
    }

    public static List<UpgradeRecipe> getUpgradeRecipes(ItemStack elytra, ItemStack ingredient) {
        return UpgradeRecipe.getUpgradeRecipes().stream().filter(recipe -> recipe.matches(elytra, ingredient)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void onAbilityReload() {
        Map<ResourceLocation, WeakReference<UpgradeRecipe>> map = INSTANCES;
        synchronized (map) {
            for (WeakReference<UpgradeRecipe> rep : INSTANCES.values()) {
                UpgradeRecipe recipe = (UpgradeRecipe)((Object)rep.get());
                if (recipe == null) continue;
                recipe.reloadAbilities();
            }
            if (!AerobaticElytraRegistries.getDatapackAbilities().isEmpty()) {
                boolean any = false;
                for (ResourceLocation id : INSTANCES.keySet()) {
                    UpgradeRecipe recipe = (UpgradeRecipe)((Object)INSTANCES.get(id).get());
                    if (recipe == null || recipe.isValid()) continue;
                    any = true;
                    LOGGER.warn("The Aerobatic Elytra upgrade recipe \"" + id + "\" was ignored because it uses abilities which aren't loaded");
                }
                if (any) {
                    LOGGER.warn("A datapack may be missing/malformed");
                }
            }
        }
    }

    public UpgradeRecipe(ResourceLocation id, CraftingBookCategory category, List<ItemSelector> ingredients, List<IElytraSpec.Upgrade> upgrades, ElytraRequirement requirement) {
        this(id, category, ingredients, upgrades, requirement, true);
    }

    public UpgradeRecipe(ResourceLocation id, CraftingBookCategory category, List<ItemSelector> ingredients, List<IElytraSpec.Upgrade> upgrades, ElytraRequirement requirement, boolean lenient) {
        super(id, category);
        this.ingredients = ingredients;
        this.upgrades = upgrades;
        this.requirement = requirement;
        this.lenient = lenient;
        boolean bl = this.valid = !lenient;
        if (lenient) {
            for (IElytraSpec.Upgrade upgrade : upgrades) {
                this.valid |= upgrade.isValid();
            }
        } else {
            for (IElytraSpec.Upgrade upgrade : upgrades) {
                this.valid &= upgrade.isValid();
            }
        }
        INSTANCES.put(id, new WeakReference<UpgradeRecipe>(this));
    }

    public boolean reloadAbilities() {
        boolean res;
        boolean bl = res = !this.lenient;
        if (this.lenient) {
            for (IElytraSpec.Upgrade upgrade : this.upgrades) {
                res |= upgrade.reloadAbilities();
            }
        } else {
            for (IElytraSpec.Upgrade upgrade : this.upgrades) {
                res &= upgrade.reloadAbilities();
            }
        }
        this.valid = res;
        return this.valid;
    }

    public boolean matches(ItemStack elytra, ItemStack stack) {
        return this.valid && ItemSelector.any(this.ingredients, stack) && this.requirement.test(elytra);
    }

    @NotNull
    public Pair<ItemStack, Integer> getResult(ItemStack elytra, int maxUses) {
        int uses;
        ItemStack result = elytra.m_41777_();
        ItemStack prev = result.m_41777_();
        IElytraSpec origSpec = ElytraSpecCapability.getElytraSpecOrDefault(elytra);
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(result);
        for (uses = 0; uses < maxUses; ++uses) {
            boolean used = false;
            for (IElytraSpec.Upgrade upgrade : this.upgrades) {
                used |= upgrade.apply(spec);
            }
            if (!used) break;
            if (origSpec.areAbilitiesEqual(spec)) {
                result = prev;
                break;
            }
            prev = result.m_41777_();
        }
        return Pair.of((Object)result, (Object)uses);
    }

    @NotNull
    public ItemStack getResult(ItemStack elytra) {
        ItemStack result = elytra.m_41777_();
        for (IElytraSpec.Upgrade upgrade : this.upgrades) {
            upgrade.apply(ElytraSpecCapability.getElytraSpecOrDefault(result));
        }
        return result;
    }

    public void apply(Player player) {
        ItemStack stack;
        ItemStack elytra = player.m_6844_(EquipmentSlot.OFFHAND);
        if (!this.matches(elytra, stack = player.m_6844_(EquipmentSlot.MAINHAND))) {
            return;
        }
        Pair<ItemStack, Integer> result = this.getResult(elytra, stack.m_41613_());
        player.m_8061_(EquipmentSlot.OFFHAND, (ItemStack)result.getLeft());
        if (!player.m_7500_()) {
            stack.m_41774_(((Integer)result.getRight()).intValue());
        }
    }

    public static ItemStack apply(ItemStack elytra, ItemStack upgrade, Collection<UpgradeRecipe> recipes) {
        ItemStack original;
        ItemStack prev = original = elytra.m_41777_();
        IElytraSpec origSpec = ElytraSpecCapability.getElytraSpecOrDefault(original);
        while (upgrade.m_41613_() > 0) {
            boolean used = false;
            for (UpgradeRecipe recipe : recipes) {
                if (!recipe.matches(elytra, upgrade)) continue;
                Pair<ItemStack, Integer> result = recipe.getResult(elytra, 1);
                elytra = (ItemStack)result.getLeft();
                if ((Integer)result.getRight() <= 0) continue;
                used = true;
            }
            if (!used) break;
            IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(elytra);
            if (origSpec.areAbilitiesEqual(spec)) {
                elytra = prev;
                break;
            }
            upgrade.m_41774_(1);
            prev = elytra.m_41777_();
        }
        return elytra;
    }

    public static void apply(Player player, Collection<UpgradeRecipe> recipes) {
        ItemStack elytra = player.m_6844_(EquipmentSlot.OFFHAND);
        ItemStack stack = player.m_6844_(EquipmentSlot.MAINHAND);
        int n = stack.m_41613_();
        ItemStack result = UpgradeRecipe.apply(elytra, stack, recipes);
        player.m_8061_(EquipmentSlot.OFFHAND, result);
        if (player.m_7500_()) {
            stack.m_41764_(n);
        }
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Deprecated
    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Deprecated
    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level worldIn) {
        return false;
    }

    @Deprecated
    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess r) {
        return ItemStack.f_41583_;
    }

    public List<ItemSelector> getSelectors() {
        return this.ingredients;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        for (ItemSelector sel : this.ingredients) {
            list.add((Object)sel.similarIngredient());
        }
        return list;
    }

    public List<IElytraSpec.Upgrade> getUpgrades() {
        return this.upgrades;
    }

    public ElytraRequirement getRequirement() {
        return this.requirement;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess r) {
        return new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA);
    }

    public boolean isValid() {
        return this.valid;
    }

    public static class ElytraRequirement
    implements Predicate<ItemStack> {
        public static final ElytraRequirement NONE = new ElytraRequirement();

        @Override
        public boolean test(ItemStack stack) {
            return AerobaticElytraLogic.isAerobaticElytra(stack);
        }

        public static ElytraRequirement deserialize(JsonObject json) {
            return new ElytraRequirement();
        }

        public void write(FriendlyByteBuf buf) {
        }

        public static ElytraRequirement read(FriendlyByteBuf buf) {
            return new ElytraRequirement();
        }
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeRecipe> {
        @NotNull
        public UpgradeRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            List<ItemSelector> ing = ItemSelector.deserialize(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            List<IElytraSpec.Upgrade> upgrades = IElytraSpec.Upgrade.deserialize(GsonHelper.m_13933_((JsonObject)json, (String)"upgrades"));
            ElytraRequirement req = GsonHelper.m_13900_((JsonObject)json, (String)"requirement") ? ElytraRequirement.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"requirement")) : ElytraRequirement.NONE;
            boolean lenient = GsonHelper.m_13855_((JsonObject)json, (String)"lenient", (boolean)true);
            return new UpgradeRecipe(recipeId, category, ing, upgrades, req, lenient);
        }

        @Nullable
        public UpgradeRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            return new UpgradeRecipe(id, (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class), PacketBufferUtil.readList((FriendlyByteBuf)buf, ItemSelector::read), PacketBufferUtil.readList((FriendlyByteBuf)buf, IElytraSpec.Upgrade::read), ElytraRequirement.read(buf), buf.readBoolean());
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull UpgradeRecipe recipe) {
            buf.m_130068_((Enum)recipe.m_245232_());
            PacketBufferUtil.writeList(recipe.ingredients, (FriendlyByteBuf)buf, ItemSelector::write);
            PacketBufferUtil.writeList(recipe.upgrades, (FriendlyByteBuf)buf, IElytraSpec.Upgrade::write);
            recipe.requirement.write(buf);
            buf.writeBoolean(recipe.lenient);
        }
    }
}

