/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import endorh.aerobaticelytra.client.trail.AerobaticTrail;
import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.recipe.AerobaticRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TrailRecipe
extends CustomRecipe {
    public TrailRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level worldIn) {
        ItemStack elytra = null;
        int e = 0;
        int rockets = 0;
        for (int k = 0; k < inv.m_6643_(); ++k) {
            ItemStack item2 = inv.m_8020_(k);
            if (item2.m_41619_()) continue;
            if (AerobaticElytraLogic.isAerobaticElytra(item2)) {
                elytra = item2;
                e = k;
                continue;
            }
            if (item2.m_41720_() != Items.f_42688_) {
                return false;
            }
            ++rockets;
        }
        if (elytra == null || rockets == 0) {
            return false;
        }
        int w = inv.m_39347_();
        int h = inv.m_39346_();
        int i = e / w;
        int j = e % w;
        int count = 0;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (!(x != j - 1 && x != j + 1 || y != i && y != i + 1)) {
                    if (inv.m_8020_(y * w + x).m_41619_()) continue;
                    ++count;
                    continue;
                }
                if (x == j && y == i || inv.m_8020_(y * w + x).m_41619_()) continue;
                return false;
            }
        }
        return count > 0;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess r) {
        int k;
        ItemStack elytra = ItemStack.f_41583_;
        for (k = 0; k < inv.m_6643_(); ++k) {
            ItemStack item2 = inv.m_8020_(k);
            if (item2.m_41619_() || !AerobaticElytraLogic.isAerobaticElytra(item2)) continue;
            elytra = item2;
            break;
        }
        assert (!elytra.m_41619_());
        int w = inv.m_39347_();
        int h = inv.m_39346_();
        int i = k / w;
        int j = k % w;
        ItemStack[] rockets = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
        if (j > 0) {
            rockets[0] = inv.m_8020_(k - 1);
            if (i < h - 1) {
                rockets[2] = inv.m_8020_(k + w - 1);
            }
        }
        if (j < w - 1) {
            rockets[1] = inv.m_8020_(k + 1);
            if (i < h - 1) {
                rockets[3] = inv.m_8020_(k + w + 1);
            }
        }
        return TrailRecipe.apply(elytra, rockets);
    }

    public static ItemStack apply(ItemStack elytra, ItemStack[] rockets) {
        ItemStack result = elytra.m_41777_();
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(result);
        IElytraSpec.TrailData trailData = spec.getTrailData();
        for (int r = 0; r < 4; ++r) {
            if (rockets[r].m_41619_()) continue;
            trailData.readRocket(AerobaticTrail.RocketSide.values()[r], rockets[r]);
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 1;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AerobaticRecipes.TRAIL_RECIPE.get();
    }
}

