/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.lazulib.network.PacketBufferUtil;
import java.util.ArrayList;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class SplitRecipe
extends CustomRecipe {
    public static int MAX_WIDTH = 3;
    public static int MAX_HEIGHT = 3;
    public static final String TAG_SPLIT_ELYTRA = "SplitElytra";
    public static final String TAG_SPLIT_ELYTRA_CAPS = "SplitElytraCaps";
    public static final Serializer SERIALIZER = new Serializer();
    protected final NonNullList<Ingredient> recipeItems;
    public final NonNullList<Pair<Ingredient, LeaveData>> ingredients;

    public SplitRecipe(ResourceLocation id, CraftingBookCategory category, NonNullList<Pair<Ingredient, LeaveData>> recipeItems) {
        super(id, category);
        this.recipeItems = SplitRecipe.addElytra(recipeItems);
        this.ingredients = recipeItems;
        ItemStack elytra = new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA, 1);
        if (recipeItems.stream().anyMatch(p -> ((Ingredient)p.getLeft()).test(elytra))) {
            throw new JsonSyntaxException("An AerobaticElytraSplitRecipe cannot contain any aerobatic elytra ingredient");
        }
    }

    private static NonNullList<Ingredient> addElytra(NonNullList<Pair<Ingredient, LeaveData>> ingredients) {
        NonNullList res = NonNullList.m_122780_((int)(ingredients.size() + 1), (Object)Ingredient.f_43901_);
        res.set(0, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AerobaticElytraItems.AEROBATIC_ELYTRA}));
        int s = ingredients.size();
        for (int i = 0; i < s; ++i) {
            res.set(i + 1, (Object)((Ingredient)((Pair)ingredients.get(i)).getLeft()));
        }
        return res;
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        ItemStack elytra = ItemStack.f_41583_;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_()) continue;
            if (current.m_41720_() instanceof AerobaticElytraItem) {
                if (!elytra.m_41619_()) {
                    return false;
                }
                elytra = current;
            }
            inputs.add(current);
        }
        if (elytra.m_41619_()) {
            return false;
        }
        return RecipeMatcher.findMatches(inputs, this.recipeItems) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess r) {
        ItemStack elytra = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (!(current.m_41720_() instanceof AerobaticElytraItem)) continue;
            elytra = current;
            break;
        }
        assert (!elytra.m_41619_());
        return SplitRecipe.getWing(elytra, ElytraDyement.WingSide.RIGHT);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        NonNullList rem = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<Integer> inputMap = new ArrayList<Integer>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_()) continue;
            inputs.add(current);
            inputMap.add(i);
        }
        int[] map = RecipeMatcher.findMatches(inputs, this.m_7527_());
        if (map == null) {
            throw new IllegalStateException("Split recipe should not have matched");
        }
        for (int i = 0; i < inputMap.size(); ++i) {
            int j = (Integer)inputMap.get(i);
            ItemStack stack = inv.m_8020_(j);
            if (stack.m_41720_() instanceof AerobaticElytraItem) {
                rem.set(j, (Object)SplitRecipe.getWing(stack, ElytraDyement.WingSide.LEFT));
                continue;
            }
            LeaveData data = (LeaveData)((Pair)this.ingredients.get(map[i - 1])).getRight();
            if (data.leave) {
                ItemStack left = stack.m_41777_();
                left.m_41721_(left.m_41773_() + data.damage);
                rem.set(j, (Object)left);
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            rem.set(j, (Object)stack.getCraftingRemainingItem());
        }
        return rem;
    }

    public static ItemStack getWing(ItemStack elytra, ElytraDyement.WingSide side) {
        assert (elytra.m_41720_() instanceof AerobaticElytraItem);
        return ((AerobaticElytraItem)elytra.m_41720_()).getWing(elytra, side);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class LeaveData {
        public final boolean leave;
        public final int damage;
        public static final LeaveData DO_NOT_LEAVE = new LeaveData();

        public LeaveData() {
            this(false);
        }

        public LeaveData(boolean leave) {
            this(leave, 0);
        }

        public LeaveData(boolean leave, int damage) {
            this.leave = leave;
            this.damage = damage;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.leave);
            if (this.leave) {
                buf.m_130130_(this.damage);
            }
        }

        public static LeaveData read(FriendlyByteBuf buf) {
            boolean leave = buf.readBoolean();
            int damage = leave ? buf.m_130242_() : 0;
            return new LeaveData(leave, damage);
        }

        public static LeaveData from(JsonObject obj) {
            return new LeaveData(GsonHelper.m_13855_((JsonObject)obj, (String)"leave", (boolean)false), GsonHelper.m_13824_((JsonObject)obj, (String)"damage", (int)0));
        }
    }

    public static class Serializer
    extends SimpleCraftingRecipeSerializer<SplitRecipe> {
        public Serializer() {
            super((id, category) -> new SplitRecipe(id, category, (NonNullList<Pair<Ingredient, LeaveData>>)NonNullList.m_122779_()));
        }

        @NotNull
        public SplitRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Pair<Ingredient, LeaveData>> list = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (list.size() > MAX_WIDTH * MAX_HEIGHT - 1) {
                throw new JsonParseException("Too many ingredients for split recipe, the max is " + (MAX_WIDTH * MAX_HEIGHT - 1));
            }
            ItemStack elytra = new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA);
            if (list.stream().anyMatch(p -> ((Ingredient)p.getLeft()).test(elytra))) {
                throw new JsonParseException("Aerobatic elytra split recipes cannot contain any aerobatic elytra ingredient");
            }
            return new SplitRecipe(recipeId, category, list);
        }

        public static NonNullList<Pair<Ingredient, LeaveData>> readIngredients(JsonArray arr) {
            NonNullList list = NonNullList.m_122779_();
            for (JsonElement elem : arr) {
                if (elem.isJsonObject()) {
                    JsonObject obj = elem.getAsJsonObject();
                    if (!obj.has("ingredient")) {
                        list.add((Object)Pair.of((Object)Ingredient.m_43938_(Stream.of(Ingredient.m_43919_((JsonObject)obj))), (Object)LeaveData.from(obj)));
                        continue;
                    }
                    JsonElement ing = obj.get("ingredient");
                    LeaveData data = LeaveData.from(obj);
                    if (ing.isJsonObject()) {
                        list.add((Object)Pair.of((Object)Ingredient.m_43938_(Stream.of(Ingredient.m_43919_((JsonObject)ing.getAsJsonObject()))), (Object)data));
                        continue;
                    }
                    if (ing.isJsonArray()) {
                        list.add((Object)Pair.of((Object)Serializer.ingredientFromJsonArray(ing.getAsJsonArray()), (Object)data));
                        continue;
                    }
                    throw new JsonSyntaxException("Expected item to be object or array of objects");
                }
                if (elem.isJsonArray()) {
                    list.add((Object)Pair.of((Object)Serializer.ingredientFromJsonArray(elem.getAsJsonArray()), (Object)LeaveData.DO_NOT_LEAVE));
                    continue;
                }
                throw new JsonSyntaxException("Expected item to be object or array of objects");
            }
            return list;
        }

        public static Ingredient ingredientFromJsonArray(JsonArray arr) {
            if (arr.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            return Ingredient.m_43938_(StreamSupport.stream(arr.spliterator(), false).map(element -> Ingredient.m_43919_((JsonObject)GsonHelper.m_13918_((JsonElement)element, (String)"item"))));
        }

        public SplitRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buf) {
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            NonNullList ingredients = PacketBufferUtil.readNonNullList((FriendlyByteBuf)buf, b -> Pair.of((Object)Ingredient.m_43940_((FriendlyByteBuf)b), (Object)LeaveData.read(b)), (Object)Pair.of((Object)Ingredient.f_43901_, (Object)LeaveData.DO_NOT_LEAVE));
            return new SplitRecipe(recipeId, category, (NonNullList<Pair<Ingredient, LeaveData>>)ingredients);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull SplitRecipe recipe) {
            buf.m_130068_((Enum)recipe.m_245232_());
            PacketBufferUtil.writeList(recipe.ingredients, (FriendlyByteBuf)buf, (p, b) -> {
                ((Ingredient)p.getLeft()).m_43923_(b);
                ((LeaveData)p.getRight()).write((FriendlyByteBuf)b);
            });
        }
    }
}

