/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepairRecipe
extends CustomRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final Ingredient ingredient;
    public final int amount;

    public static List<RepairRecipe> getRepairRecipes() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_129894_().m_44051_().stream().map(r -> r instanceof RepairRecipe ? (RepairRecipe)((Object)r) : null).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public RepairRecipe(ResourceLocation id, CraftingBookCategory category, Ingredient ingredient, int amount) {
        super(id, category);
        this.ingredient = ingredient;
        this.amount = amount;
    }

    public boolean matches(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess r) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<RepairRecipe> {
        @NotNull
        public RepairRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            int amount = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)0);
            return new RepairRecipe(recipeId, category, ingredient, amount);
        }

        @Nullable
        public RepairRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buf) {
            return new RepairRecipe(recipeId, (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class), Ingredient.m_43940_((FriendlyByteBuf)buf), buf.m_130242_());
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull RepairRecipe recipe) {
            recipe.ingredient.m_43923_(buf);
            buf.m_130130_(recipe.amount);
        }
    }
}

