/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.AerobaticElytraWingItem;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.recipe.AerobaticRecipes;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class JoinRecipe
extends CustomRecipe {
    private static final ElytraDyement leftDyement = new ElytraDyement();
    private static final ElytraDyement rightDyement = new ElytraDyement();

    public JoinRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        ItemStack left = ItemStack.f_41583_;
        ItemStack right = ItemStack.f_41583_;
        boolean found = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_()) continue;
            if (found) {
                return false;
            }
            if (!(current.m_41720_() instanceof AerobaticElytraWingItem) || (i + 1) % inv.m_39347_() == 0 || !(inv.m_8020_(i + 1).m_41720_() instanceof AerobaticElytraWingItem)) {
                return false;
            }
            left = inv.m_8020_(i);
            right = inv.m_8020_(i + 1);
            ++i;
            found = true;
        }
        if (!found) {
            return false;
        }
        assert (!left.m_41619_() && !right.m_41619_());
        return JoinRecipe.matches(left, right);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess r) {
        ItemStack left = ItemStack.f_41583_;
        ItemStack right = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_()) continue;
            if (left.m_41619_()) {
                left = current;
                continue;
            }
            if (right.m_41619_()) {
                right = current;
                continue;
            }
            return ItemStack.f_41583_;
        }
        assert (left.m_41720_() instanceof AerobaticElytraWingItem && right.m_41720_() instanceof AerobaticElytraWingItem);
        assert (JoinRecipe.matches(left, right));
        return JoinRecipe.join(left, right);
    }

    public static boolean matches(ItemStack left, ItemStack right) {
        if (!(left.m_41720_() instanceof AerobaticElytraWingItem) || !(right.m_41720_() instanceof AerobaticElytraWingItem)) {
            return false;
        }
        if (((AerobaticElytraWingItem)left.m_41720_()).getElytraItem() != ((AerobaticElytraWingItem)right.m_41720_()).getElytraItem()) {
            return false;
        }
        return Objects.equals(left.m_41737_("SplitElytra"), right.m_41737_("SplitElytra")) && Objects.equals(left.m_41737_("SplitElytraCaps"), right.m_41737_("SplitElytraCaps"));
    }

    public static ItemStack join(ItemStack left, ItemStack right) {
        CompoundTag caps = left.m_41698_("SplitElytraCaps");
        CompoundTag tag = left.m_41698_("SplitElytra");
        ItemStack elytra = new ItemStack((ItemLike)((AerobaticElytraWingItem)left.m_41720_()).getElytraItem(), 1, caps.m_6426_());
        elytra.m_41751_(tag.m_6426_());
        leftDyement.read(left);
        rightDyement.read(right);
        if (leftDyement.getWing(ElytraDyement.WingSide.LEFT).equals(rightDyement.getWing(ElytraDyement.WingSide.RIGHT))) {
            leftDyement.getWing(ElytraDyement.WingSide.LEFT).write(elytra, null);
        } else {
            leftDyement.getWing(ElytraDyement.WingSide.LEFT).write(elytra, ElytraDyement.WingSide.LEFT);
            rightDyement.getWing(ElytraDyement.WingSide.RIGHT).write(elytra, ElytraDyement.WingSide.RIGHT);
        }
        ElytraSpecCapability.getElytraSpecOrDefault(elytra);
        IElytraSpec.TrailData trailData = ElytraSpecCapability.getElytraSpecOrDefault(elytra).getTrailData();
        IElytraSpec.TrailData leftData = ElytraSpecCapability.getElytraSpecOrDefault(left).getTrailData();
        IElytraSpec.TrailData rightData = ElytraSpecCapability.getElytraSpecOrDefault(right).getTrailData();
        trailData.set(ElytraDyement.WingSide.LEFT, leftData);
        trailData.set(ElytraDyement.WingSide.RIGHT, rightData);
        return elytra;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 1;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AerobaticRecipes.JOIN_RECIPE.get();
    }
}

