/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import endorh.lazulib.nbt.NBTPredicate;
import endorh.lazulib.network.PacketBufferUtil;
import endorh.lazulib.text.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ItemSelector
implements Predicate<ItemStack> {
    @Nullable
    private final Item item;
    @Nullable
    private final Map<TagKey<Item>, ResourceLocation> tags;
    @Nullable
    private final NBTPredicate nbtPredicate;
    private static final Pattern item_selector_pattern = Pattern.compile("\\s*(?:(?<tags>(?:\\[(?:[\\w.-]++:)?[\\w/.-]++]\\s*+)+)|(?<name>(?:[\\w.-]++:)?[\\w/.-]++)\\s*+)(?<nbt>\\{.+})?\\s*+");
    private static final Pattern tag_selector_pattern = Pattern.compile("\\[(?<name>\\w+:[\\w/.-]++)}");

    public static ItemSelector fromString(String str) {
        Matcher m = item_selector_pattern.matcher(str);
        if (m.matches()) {
            String nbt = m.group("nbt");
            NBTPredicate nbtPredicate = null;
            try {
                if (nbt != null && !nbt.isEmpty()) {
                    nbtPredicate = (NBTPredicate)NBTPredicate.parse((String)nbt).orElseThrow(() -> new IllegalArgumentException("Malformed NBT predicate: \"" + nbt + "\""));
                }
            }
            catch (NBTPredicate.NBTPredicateParseException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage(), e);
            }
            String tagsString = m.group("tags");
            if (tagsString != null) {
                Matcher tag_matcher = tag_selector_pattern.matcher(tagsString);
                ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
                while (tag_matcher.find()) {
                    tags.add(new ResourceLocation(tag_matcher.group("name")));
                }
                return new ItemSelector(tags, nbtPredicate);
            }
            String itemName = m.group("name");
            Item item2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            return new ItemSelector(item2, nbtPredicate);
        }
        throw new IllegalArgumentException("Malformed item selector: \"" + str + "\"");
    }

    public ItemSelector(List<ResourceLocation> tags, @Nullable NBTPredicate nbtPredicate) {
        this.item = null;
        this.tags = tags.stream().collect(Collectors.toMap(r -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)r), r -> r));
        this.nbtPredicate = nbtPredicate;
    }

    public ItemSelector(@Nullable Item item2, @Nullable NBTPredicate nbtPredicate) {
        this.item = item2;
        this.tags = null;
        this.nbtPredicate = nbtPredicate;
    }

    public boolean isItemBased() {
        return this.item != null;
    }

    public boolean isTagBased() {
        return this.item == null;
    }

    public boolean isSimple() {
        return this.nbtPredicate == null;
    }

    public boolean testIgnoringNBT(ItemStack stack) {
        if (this.item != null) {
            return this.item.equals(stack.m_41720_());
        }
        if (this.tags != null) {
            for (TagKey<Item> tag : this.tags.keySet()) {
                for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(tag)) {
                    if (!holder.m_203633_() || !((Item)holder.m_203334_()).equals(stack.m_41720_())) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (!this.testIgnoringNBT(stack)) {
            return false;
        }
        return this.nbtPredicate == null || this.nbtPredicate.test(stack);
    }

    public static List<ItemSelector> deserialize(JsonArray arr) {
        ArrayList<ItemSelector> result = new ArrayList<ItemSelector>();
        try {
            for (int i = 0; i < arr.size(); ++i) {
                String sel = GsonHelper.m_13805_((JsonElement)arr.get(i), (String)("ingredients[" + i + "]"));
                result.add(ItemSelector.fromString(sel));
            }
        }
        catch (IllegalArgumentException e) {
            throw new JsonSyntaxException(e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public static ItemSelector read(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            Item item2 = buf.m_130267_().m_41720_();
            NBTPredicate nbtPredicate = buf.readBoolean() ? (NBTPredicate)NBTPredicate.parse((String)buf.m_130277_()).orElse(null) : null;
            return new ItemSelector(item2, nbtPredicate);
        }
        List tagNames = PacketBufferUtil.readList((FriendlyByteBuf)buf, FriendlyByteBuf::m_130281_);
        NBTPredicate nbtPredicate = buf.readBoolean() ? (NBTPredicate)NBTPredicate.parse((String)buf.m_130277_()).orElse(null) : null;
        return new ItemSelector(tagNames, nbtPredicate);
    }

    public void write(FriendlyByteBuf buf) {
        if (this.item != null) {
            buf.writeBoolean(true);
            buf.m_130055_(new ItemStack((ItemLike)this.item));
        } else if (this.tags != null) {
            buf.writeBoolean(false);
            PacketBufferUtil.writeList((FriendlyByteBuf)buf, this.tags.values(), FriendlyByteBuf::m_130085_);
        }
        buf.writeBoolean(this.nbtPredicate != null);
        if (this.nbtPredicate != null) {
            this.nbtPredicate.write(buf);
        }
    }

    public static boolean any(List<ItemSelector> selectors, ItemStack stack) {
        for (ItemSelector sel : selectors) {
            if (!sel.test(stack)) continue;
            return true;
        }
        return false;
    }

    public Ingredient similarIngredient() {
        if (this.tags != null && !this.tags.isEmpty()) {
            ArrayList<Item> list = new ArrayList<Item>();
            for (TagKey<Item> tag : this.tags.keySet()) {
                for (Holder h : BuiltInRegistries.f_257033_.m_206058_(tag)) {
                    if (!h.m_203633_()) continue;
                    list.add((Item)h.m_203334_());
                }
            }
            return Ingredient.m_43929_((ItemLike[])((ItemLike[])list.toArray(Item[]::new)));
        }
        if (this.item != null) {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.item});
        }
        return Ingredient.f_43901_;
    }

    public Optional<CompoundTag> matchingNBT() {
        if (this.nbtPredicate != null) {
            return this.nbtPredicate.generateValid();
        }
        return Optional.empty();
    }

    public Component getDisplay() {
        MutableComponent d = TextUtil.stc((String)"");
        if (this.tags != null) {
            for (ResourceLocation tagName : this.tags.values()) {
                d = d.m_7220_((Component)TextUtil.stc((String)"{").m_7220_((Component)TextUtil.stc((Object)tagName).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)TextUtil.stc((String)"}")).m_130940_(ChatFormatting.DARK_GREEN));
            }
        }
        if (this.item != null) {
            d = d.m_7220_(new ItemStack((ItemLike)this.item).m_41786_());
        }
        if (this.nbtPredicate != null) {
            d = d.m_7220_((Component)this.nbtPredicate.getDisplay());
        }
        return d;
    }

    @Nullable
    public Item getItem() {
        return this.item;
    }

    @Nullable
    public Map<TagKey<Item>, ResourceLocation> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Nullable
    public NBTPredicate getNbtPredicate() {
        return this.nbtPredicate;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.tags != null) {
            for (ResourceLocation tagName : this.tags.values()) {
                res.append('{').append(tagName).append('}');
            }
        }
        if (this.item != null) {
            res.append(ForgeRegistries.ITEMS.getKey((Object)this.item));
        }
        if (this.nbtPredicate != null) {
            res.append(this.nbtPredicate);
        }
        return res.toString();
    }
}

