/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import com.mojang.datafixers.util.Pair;
import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import endorh.aerobaticelytra.common.item.AerobaticElytraWingItem;
import endorh.aerobaticelytra.common.item.ElytraDyement;
import endorh.aerobaticelytra.common.recipe.AerobaticRecipes;
import endorh.lazulib.common.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.NotNull;

public class DyeRecipe
extends CustomRecipe {
    private static final ElytraDyement dyement = new ElytraDyement();

    public DyeRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, @NotNull Level worldIn) {
        boolean found = false;
        int tints = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_()) continue;
            Item item2 = current.m_41720_();
            if (item2 instanceof AerobaticElytraItem || item2 instanceof AerobaticElytraWingItem) {
                if (found) {
                    return false;
                }
                found = true;
                continue;
            }
            if (!(item2 instanceof DyeItem)) {
                return false;
            }
            ++tints;
        }
        return found && tints > 0;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, @NotNull RegistryAccess r) {
        ItemStack elytra = ItemStack.f_41583_;
        ArrayList<DyeItem> dyeList = new ArrayList<DyeItem>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_()) continue;
            Item item2 = current.m_41720_();
            if (item2 instanceof AerobaticElytraItem || item2 instanceof AerobaticElytraWingItem) {
                if (!elytra.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                elytra = current.m_41777_();
                continue;
            }
            if (!(item2 instanceof DyeItem)) {
                return ItemStack.f_41583_;
            }
            dyeList.add((DyeItem)item2);
        }
        if (elytra.m_41619_() || dyeList.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return DyeRecipe.dye(elytra, dyeList);
    }

    public static ItemStack dye(ItemStack elytra, List<DyeItem> dyes) {
        ItemStack res = elytra.m_41777_();
        dyement.read(res);
        res.m_41749_("WingInfo");
        res.m_41749_("BlockEntityTag");
        ArrayList<Integer> colors = new ArrayList<Integer>();
        if (DyeRecipe.dyement.hasWingDyement) {
            for (ElytraDyement.WingSide side : ElytraDyement.WingSide.values()) {
                ElytraDyement.WingDyement wing = dyement.getWing(side);
                if (wing.hasPattern) {
                    for (Pair<BannerPattern, DyeColor> pair : wing.patternColorData) {
                        colors.add(((DyeColor)pair.getSecond()).m_41071_());
                    }
                    continue;
                }
                if (!wing.hasColor) continue;
                colors.add(wing.color);
            }
        } else {
            ElytraDyement.WingDyement wing = dyement.getFirst();
            if (wing.hasPattern) {
                for (Pair<BannerPattern, DyeColor> pair : wing.patternColorData) {
                    colors.add(((DyeColor)pair.getSecond()).m_41071_());
                }
            } else if (wing.hasColor) {
                colors.add(wing.color);
            }
        }
        if (!colors.isEmpty()) {
            int color = ColorUtil.mix(colors);
            res.m_41698_("display").m_128405_("color", color);
        } else {
            res.m_41698_("display").m_128473_("color");
        }
        res = DyeableLeatherItem.m_41118_((ItemStack)res, dyes);
        ElytraDyement.hideDyedFlag(res);
        return res;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AerobaticRecipes.DYE_RECIPE.get();
    }
}

