/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.AerobaticElytraItems;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.aerobaticelytra.common.recipe.AbilityNBTInheritingShapedRecipe;
import endorh.lazulib.nbt.JsonToNBTUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class CreativeTabAbilitySetRecipe
extends CustomRecipe
implements Comparable<CreativeTabAbilitySetRecipe> {
    public static final Serializer SERIALIZER = new Serializer();
    public final ItemStack stack;
    public final String group;
    public final CreativeModeTab.TabVisibility visibility;
    public final int order;

    public CreativeTabAbilitySetRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack stackIn, CreativeModeTab.TabVisibility visibility2, int order) {
        super(id, category);
        this.group = group;
        this.stack = stackIn;
        this.visibility = visibility2;
        this.order = order;
    }

    public boolean matchesTab(CreativeModeTab tab) {
        String name = CreativeTabAbilitySetRecipe.getTabName(tab);
        if (name.startsWith("itemGroup.") && !this.group.startsWith("itemGroup.")) {
            return name.equals("itemGroup." + this.group);
        }
        return name.equals(this.group);
    }

    private static String getTabName(CreativeModeTab tab) {
        Component name = tab.m_40786_();
        ComponentContents componentContents = name.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            return tc.m_237508_();
        }
        return name.getString();
    }

    public ItemStack getElytraStack() {
        return this.stack;
    }

    public ItemStack getWingStack() {
        ItemStack wing = new ItemStack((ItemLike)AerobaticElytraItems.AEROBATIC_ELYTRA_WING);
        CompoundTag tag = this.stack.m_41783_();
        if (tag != null) {
            wing.m_41751_(tag.m_6426_());
        }
        return wing;
    }

    public CreativeModeTab.TabVisibility getVisibility() {
        return this.visibility;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess r) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public int compareTo(@NotNull CreativeTabAbilitySetRecipe other) {
        return Integer.compare(this.order, other.order);
    }

    public static class Serializer
    extends SimpleCraftingRecipeSerializer<CreativeTabAbilitySetRecipe> {
        public Serializer() {
            super((id, cat) -> null);
        }

        @NotNull
        public CreativeTabAbilitySetRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            CreativeModeTab.TabVisibility visibility2;
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            String group = GsonHelper.m_13906_((JsonObject)json, (String)"group");
            String itemName = GsonHelper.m_13906_((JsonObject)json, (String)"item");
            ItemStack stack = new ItemStack((Holder)ForgeRegistries.ITEMS.getHolder(new ResourceLocation(itemName)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + itemName + "'")));
            Pair<Map<IAbility, Float>, Map<String, Float>> pair = AbilityNBTInheritingShapedRecipe.Serializer.abilitiesFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"abilities"));
            if (json.has("tag")) {
                CompoundTag tag = JsonToNBTUtil.getTagFromJson((JsonElement)json.getAsJsonObject("tag"));
                stack.m_41751_(tag);
            }
            IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(stack);
            Map<String, Float> specUnknown = spec.getUnknownAbilities();
            spec.setAbilities((Map)pair.getLeft());
            specUnknown.clear();
            specUnknown.putAll((Map)pair.getRight());
            String visibilityName = GsonHelper.m_13851_((JsonObject)json, (String)"visibility", (String)"parent_and_search_tabs");
            try {
                visibility2 = CreativeModeTab.TabVisibility.valueOf((String)visibilityName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new JsonSyntaxException("Unknown visibility type '" + visibilityName + "' (Must be one of " + Arrays.stream(CreativeModeTab.TabVisibility.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ")) + ")");
            }
            int order = GsonHelper.m_13824_((JsonObject)json, (String)"order", (int)0);
            return new CreativeTabAbilitySetRecipe(recipeId, group, category, stack, visibility2, order);
        }

        public CreativeTabAbilitySetRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buf) {
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            String group = buf.m_130277_();
            ItemStack stack = buf.m_130267_();
            CreativeModeTab.TabVisibility visibility2 = (CreativeModeTab.TabVisibility)buf.m_130066_(CreativeModeTab.TabVisibility.class);
            int order = buf.m_130242_();
            return new CreativeTabAbilitySetRecipe(recipeId, group, category, stack, visibility2, order);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull CreativeTabAbilitySetRecipe recipe) {
            buf.m_130068_((Enum)recipe.m_245232_());
            buf.m_130070_(recipe.group);
            buf.m_130055_(recipe.stack);
            buf.m_130068_((Enum)recipe.visibility);
            buf.m_130130_(recipe.order);
        }
    }
}

