/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import endorh.aerobaticelytra.common.AerobaticElytraLogic;
import endorh.aerobaticelytra.common.recipe.AerobaticRecipes;
import endorh.aerobaticelytra.common.recipe.UpgradeRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CraftedUpgradeRecipe
extends CustomRecipe {
    private Collection<UpgradeRecipe> recipes = new ArrayList<UpgradeRecipe>();

    public CraftedUpgradeRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        ItemStack upgrade = ItemStack.f_41583_;
        ItemStack elytra = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            int j;
            ItemStack cur = inv.m_8020_(i);
            if (cur.m_41619_()) continue;
            upgrade = cur;
            for (j = 1; j < inv.m_39347_() && i + j < inv.m_6643_(); ++j) {
                if (inv.m_8020_(i + j).m_41619_()) continue;
                return false;
            }
            if (i + j < inv.m_6643_() && !AerobaticElytraLogic.isAerobaticElytra(elytra = inv.m_8020_(i + j))) {
                return false;
            }
            i += j + 1;
            while (i < inv.m_6643_()) {
                if (!inv.m_8020_(i).m_41619_()) {
                    return false;
                }
                ++i;
            }
        }
        if (upgrade.m_41619_() || elytra.m_41619_()) {
            return false;
        }
        this.recipes = UpgradeRecipe.getUpgradeRecipes();
        return !UpgradeRecipe.getUpgradeRecipes(elytra, upgrade).isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess r) {
        ItemStack upgrade = ItemStack.f_41583_;
        ItemStack elytra = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack cur = inv.m_8020_(i);
            if (cur.m_41619_()) continue;
            upgrade = cur;
            elytra = inv.m_8020_(i + inv.m_39347_());
            break;
        }
        ItemStack elytraStack = elytra;
        ItemStack upgradeStack = upgrade.m_41777_();
        upgradeStack.m_41764_(1);
        return UpgradeRecipe.apply(elytra, upgradeStack, this.recipes.stream().filter(u -> u.matches(elytraStack, upgradeStack)).collect(Collectors.toList()));
    }

    public boolean m_8004_(int width, int height) {
        return width >= 1 && height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AerobaticRecipes.CRAFTED_UPGRADE_RECIPE.get();
    }
}

