/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import endorh.aerobaticelytra.common.item.AerobaticElytraItem;
import endorh.aerobaticelytra.common.item.AerobaticElytraWingItem;
import endorh.aerobaticelytra.common.recipe.AerobaticRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BannerRecipe
extends CustomRecipe {
    public BannerRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, @NotNull Level world) {
        boolean foundElytra = false;
        boolean foundBanner = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_()) continue;
            Item item2 = current.m_41720_();
            if (item2 instanceof BannerItem) {
                if (foundBanner) {
                    return false;
                }
                foundBanner = true;
                continue;
            }
            if (!(item2 instanceof AerobaticElytraItem) && !(item2 instanceof AerobaticElytraWingItem)) continue;
            if (foundElytra) {
                return false;
            }
            foundElytra = true;
        }
        return foundElytra && foundBanner;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, @NotNull RegistryAccess r) {
        ItemStack elytra = ItemStack.f_41583_;
        ItemStack banner = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_()) continue;
            Item item2 = current.m_41720_();
            if (item2 instanceof BannerItem) {
                banner = current.m_41777_();
                continue;
            }
            if (!(item2 instanceof AerobaticElytraItem) && !(item2 instanceof AerobaticElytraWingItem)) continue;
            elytra = current;
        }
        assert (!elytra.m_41619_() && !banner.m_41619_());
        return BannerRecipe.apply(elytra, banner);
    }

    public static ItemStack apply(ItemStack elytra, ItemStack banner) {
        ItemStack result = elytra.m_41777_();
        result.m_41764_(1);
        CompoundTag source = banner.m_41737_("BlockEntityTag");
        CompoundTag tag = source == null ? new CompoundTag() : source.m_6426_();
        tag.m_128405_("Base", ((BannerItem)banner.m_41720_()).m_40545_().m_41060_());
        result.m_41700_("BlockEntityTag", (Tag)tag);
        result.m_41749_("display");
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AerobaticRecipes.BANNER_RECIPE.get();
    }
}

