/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import endorh.aerobaticelytra.common.capability.ElytraSpecCapability;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.item.IAbility;
import endorh.lazulib.network.PacketBufferUtil;
import endorh.lazulib.recipe.NBTInheritingShapedRecipe;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityNBTInheritingShapedRecipe
extends NBTInheritingShapedRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final Map<IAbility, Float> abilities;
    public final Map<String, Float> unknown;

    public AbilityNBTInheritingShapedRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<int[]> nbtSourcesIn, NonNullList<Ingredient> items, ItemStack output, CompoundTag outputTagIn, Map<IAbility, Float> upgradesIn, Map<String, Float> unknownIn) {
        super(id, group, category, width, height, nbtSourcesIn, items, output, outputTagIn);
        this.abilities = upgradesIn;
        this.unknown = unknownIn;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer inv, @NotNull RegistryAccess r) {
        ItemStack result = super.m_5874_(inv, r);
        IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(result);
        spec.setAbilities(this.abilities);
        spec.getUnknownAbilities().clear();
        spec.getUnknownAbilities().putAll(this.unknown);
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<AbilityNBTInheritingShapedRecipe> {
        private static final Logger LOGGER = LogManager.getLogger();

        @NotNull
        public AbilityNBTInheritingShapedRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            boolean allowUnknown = GsonHelper.m_13855_((JsonObject)json, (String)"allow_unknown_items", (boolean)false);
            Map map = NBTInheritingShapedRecipe.Serializer.deserializeKey((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"), (boolean)allowUnknown);
            String[] pat = NBTInheritingShapedRecipe.Serializer.shrink((String[])NBTInheritingShapedRecipe.Serializer.patternFromJson((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int w = pat[0].length();
            int h = pat.length;
            NonNullList nbtSources = NBTInheritingShapedRecipe.Serializer.nbtSourcesFromPattern((String[])pat);
            NonNullList list = NBTInheritingShapedRecipe.Serializer.deserializeIngredients((String[])pat, (Map)map, (int)w, (int)h);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            CompoundTag outputTag = NBTInheritingShapedRecipe.Serializer.nbtFromJson((JsonObject)json);
            Pair<Map<IAbility, Float>, Map<String, Float>> abilities = Serializer.abilitiesFromJson(GsonHelper.m_13930_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (String)"abilities"));
            output.m_41751_(outputTag);
            IElytraSpec spec = ElytraSpecCapability.getElytraSpecOrDefault(output);
            spec.setAbilities((Map)abilities.getLeft());
            spec.getUnknownAbilities().putAll((Map)abilities.getRight());
            return new AbilityNBTInheritingShapedRecipe(recipeId, group, category, w, h, (NonNullList<int[]>)nbtSources, (NonNullList<Ingredient>)list, output, outputTag, (Map)abilities.getLeft(), (Map)abilities.getRight());
        }

        @Nullable
        public AbilityNBTInheritingShapedRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            int w = buf.m_130242_();
            int h = buf.m_130242_();
            String group = buf.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            NonNullList list = NonNullList.m_122780_((int)(w * h), (Object)Ingredient.f_43901_);
            list.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack output = buf.m_130267_();
            int l = buf.m_130242_();
            NonNullList nbtSources = NonNullList.m_122780_((int)l, (Object)new int[]{0, 0});
            for (int i = 0; i < l; ++i) {
                nbtSources.set(i, (Object)buf.m_130100_());
            }
            CompoundTag outputTag = buf.m_130260_();
            Map upgrades = PacketBufferUtil.readMap((FriendlyByteBuf)buf, IAbility::read, FriendlyByteBuf::readFloat);
            Map unknown = PacketBufferUtil.readMap((FriendlyByteBuf)buf, FriendlyByteBuf::m_130277_, FriendlyByteBuf::readFloat);
            return new AbilityNBTInheritingShapedRecipe(id, group, category, w, h, (NonNullList<int[]>)nbtSources, (NonNullList<Ingredient>)list, output, outputTag, upgrades, unknown);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull AbilityNBTInheritingShapedRecipe recipe) {
            buf.m_130130_(recipe.recipeWidth);
            buf.m_130130_(recipe.recipeHeight);
            buf.m_130070_(recipe.m_6076_());
            buf.m_130068_((Enum)recipe.m_245232_());
            for (Ingredient ing : recipe.recipeItems) {
                ing.m_43923_(buf);
            }
            buf.m_130055_(recipe.result);
            buf.m_130130_(recipe.nbtSources.size());
            for (int[] nbtSource : recipe.nbtSources) {
                buf.m_130089_(nbtSource);
            }
            buf.m_130079_(recipe.outputTag);
            PacketBufferUtil.writeMap2((FriendlyByteBuf)buf, recipe.abilities, IAbility::write, FriendlyByteBuf::writeFloat);
            PacketBufferUtil.writeMap((FriendlyByteBuf)buf, recipe.unknown, FriendlyByteBuf::m_130070_, FriendlyByteBuf::writeFloat);
        }

        public static Pair<Map<IAbility, Float>, Map<String, Float>> abilitiesFromJson(JsonObject abilities) {
            HashMap<IAbility, Float> map = new HashMap<IAbility, Float>();
            HashMap<String, Float> unknown = new HashMap<String, Float>();
            for (Map.Entry entry : abilities.entrySet()) {
                float value;
                String typeError = "Ability values must be numbers";
                if (!((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    throw new JsonSyntaxException("Ability values must be numbers");
                }
                JsonPrimitive val = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                if (val.isBoolean()) {
                    value = val.getAsBoolean() ? 1.0f : 0.0f;
                } else if (val.isNumber()) {
                    value = val.getAsFloat();
                } else {
                    throw new JsonSyntaxException("Ability values must be numbers");
                }
                String jsonName = (String)entry.getKey();
                if (IAbility.isDefined(jsonName)) {
                    map.put(IAbility.fromName(jsonName), Float.valueOf(value));
                    continue;
                }
                unknown.put(jsonName, Float.valueOf(value));
            }
            if (!unknown.isEmpty()) {
                LOGGER.warn("Unknown abilities found in recipe:" + unknown.keySet().stream().map(name -> "\n\t" + name).collect(Collectors.joining("")) + "\nThis could be caused by missing mods or a typo in the recipes.");
            }
            return Pair.of(map, unknown);
        }
    }
}

