/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.particle;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import endorh.aerobaticelytra.client.trail.AerobaticTrail;
import endorh.aerobaticelytra.common.capability.IElytraSpec;
import endorh.aerobaticelytra.common.particle.AerobaticElytraParticles;
import endorh.lazulib.math.Vec3f;
import endorh.lazulib.network.PacketBufferUtil;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrailParticleData
implements ParticleOptions {
    public final float size;
    public final int life;
    public final float partialTick;
    public final boolean ownPlayer;
    public final Color color;
    public final Color fadeColor;
    public final boolean flicker;
    public final boolean trail;
    public final byte type;
    public final AerobaticTrail.RocketSide side;
    public final Vec3f rollVec;
    public final IElytraSpec.TrailData trailData;
    public static final Codec<TrailParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(d -> d.color.getRGB()), (App)Codec.INT.fieldOf("fadeColor").forGetter(d -> d.fadeColor.getRGB()), (App)Codec.BYTE.fieldOf("type").forGetter(d -> d.type), (App)Codec.BOOL.fieldOf("flicker").forGetter(d -> d.flicker), (App)Codec.BOOL.fieldOf("trail").forGetter(d -> d.trail), (App)Codec.INT.fieldOf("life").forGetter(d -> d.life), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.BOOL.fieldOf("ownPlayer").forGetter(d -> d.ownPlayer), (App)Codec.list((Codec)Codec.FLOAT).fieldOf("rollVec").forGetter(d -> d.rollVec.asList()), (App)Codec.INT.fieldOf("side").forGetter(d -> d.side.ordinal())).apply((Applicative)instance, TrailParticleData::new));
    public static final ParticleOptions.Deserializer<TrailParticleData> DESERIALIZER = new ParticleOptions.Deserializer<TrailParticleData>(){

        @NotNull
        public TrailParticleData fromCommand(@NotNull ParticleType<TrailParticleData> type, @NotNull StringReader reader) throws CommandSyntaxException {
            AerobaticTrail.RocketSide side;
            reader.expect(' ');
            int red = reader.readInt() & 0xFF;
            reader.expect(' ');
            int green = reader.readInt() & 0xFF;
            reader.expect(' ');
            int blue = reader.readInt() & 0xFF;
            reader.expect(' ');
            Color color = new Color(red, green, blue);
            red = reader.readInt() & 0xFF;
            reader.expect(' ');
            green = reader.readInt() & 0xFF;
            reader.expect(' ');
            blue = reader.readInt() & 0xFF;
            reader.expect(' ');
            Color fadeColor = new Color(red, green, blue);
            byte typ = (byte)(reader.readInt() & 0xFF);
            reader.expect(' ');
            boolean flicker = reader.readBoolean();
            reader.expect(' ');
            boolean trail = reader.readBoolean();
            reader.expect(' ');
            float size = Mth.m_14036_((float)reader.readFloat(), (float)0.0f, (float)1.0f);
            reader.expect(' ');
            int life = reader.readInt();
            reader.expect(' ');
            float partialTick = reader.readFloat();
            reader.expect(' ');
            boolean ownPlayer = reader.readBoolean();
            reader.expect(' ');
            float x = reader.readFloat();
            reader.expect(' ');
            float y = reader.readFloat();
            reader.expect(' ');
            float z = reader.readFloat();
            reader.expect(' ');
            Vec3f rollVec = new Vec3f(x, y, z);
            int s = reader.readInt();
            try {
                side = AerobaticTrail.RocketSide.values()[s];
            }
            catch (IndexOutOfBoundsException e) {
                MutableComponent msg = Component.m_237113_((String)("Unknown rocket side: " + s + ", Valid sides are 0-" + AerobaticTrail.RocketSide.values().length));
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)msg), (Message)msg);
            }
            return new TrailParticleData(color, fadeColor, typ, flicker, trail, life, size, partialTick, ownPlayer, rollVec, side, null);
        }

        @NotNull
        public TrailParticleData fromNetwork(@NotNull ParticleType<TrailParticleData> type, FriendlyByteBuf buf) {
            int rgb = buf.readInt();
            int fadeRGB = buf.readInt();
            byte typ = buf.readByte();
            boolean flicker = buf.readBoolean();
            boolean trail = buf.readBoolean();
            int life = buf.readInt();
            float size = buf.readFloat();
            float partialTick = buf.readFloat();
            boolean ownPlayer = buf.readBoolean();
            Vec3f rollVec = Vec3f.read((FriendlyByteBuf)buf);
            AerobaticTrail.RocketSide side = (AerobaticTrail.RocketSide)buf.m_130066_(AerobaticTrail.RocketSide.class);
            IElytraSpec.TrailData trailData = (IElytraSpec.TrailData)PacketBufferUtil.readNullable((FriendlyByteBuf)buf, IElytraSpec.TrailData::read);
            return new TrailParticleData(new Color(rgb), new Color(fadeRGB), typ, flicker, trail, life, size, partialTick, ownPlayer, rollVec, side, trailData);
        }
    };
    public static boolean ALWAYS_SHOW_TRAIL = true;

    private TrailParticleData(int colorIn, int fadeColorIn, byte typeIn, boolean flickerIn, boolean trailIn, int lifeIn, float sizeIn, boolean ownPlayerIn, List<Float> rollVecIn, int sideIn) {
        this(new Color(colorIn), new Color(fadeColorIn), typeIn, flickerIn, trailIn, lifeIn, sizeIn, 0.0f, ownPlayerIn, new Vec3f(rollVecIn), AerobaticTrail.RocketSide.values()[sideIn], null);
    }

    public TrailParticleData(Color colorIn, Color fadeColorIn, byte typeIn, boolean flickerIn, boolean trailIn, int lifeIn, float sizeIn, float partialTickIn, boolean ownPlayerIn, @Nullable Vec3f rollVecIn, @Nullable AerobaticTrail.RocketSide sideIn, @Nullable IElytraSpec.TrailData trailDataIn) {
        this.color = colorIn;
        this.fadeColor = fadeColorIn;
        this.type = typeIn;
        this.flicker = flickerIn;
        this.trail = trailIn;
        this.life = lifeIn;
        this.size = Mth.m_14036_((float)sizeIn, (float)0.0f, (float)1.0f);
        this.partialTick = partialTickIn;
        this.ownPlayer = ownPlayerIn;
        this.rollVec = rollVecIn != null ? rollVecIn.copy() : null;
        this.side = sideIn;
        this.trailData = trailDataIn;
    }

    @NotNull
    public ParticleType<TrailParticleData> m_6012_() {
        return AerobaticElytraParticles.TRAIL_PARTICLES.get(this.type);
    }

    public void m_7711_(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.color.getRGB());
        buf.writeInt(this.fadeColor.getRGB());
        buf.writeByte((int)this.type);
        buf.writeBoolean(this.flicker);
        buf.writeBoolean(this.trail);
        buf.writeInt(this.life);
        buf.writeFloat(this.size);
        buf.writeFloat(this.partialTick);
        buf.writeBoolean(this.ownPlayer);
        this.rollVec.write(buf);
        buf.m_130068_((Enum)this.side);
        PacketBufferUtil.writeNullable((Object)this.trailData, (FriendlyByteBuf)buf, IElytraSpec.TrailData::write);
    }

    @NotNull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d %d %d %d %d %d %b %b %f %f %b %f %f %f %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.fadeColor.getRed(), this.fadeColor.getGreen(), this.fadeColor.getBlue(), this.type, this.flicker, this.trail, Float.valueOf(this.size), Float.valueOf(this.partialTick), this.ownPlayer, Float.valueOf(this.rollVec.x), Float.valueOf(this.rollVec.y), Float.valueOf(this.rollVec.z), this.side.ordinal());
    }

    public static class BubbleTrailParticleType
    extends TrailParticleType {
    }

    public static class BurstTrailParticleType
    extends TrailParticleType {
    }

    public static class CreeperTrailParticleType
    extends TrailParticleType {
    }

    public static class StarTrailParticleType
    extends TrailParticleType {
    }

    public static class TrailParticleType
    extends ParticleType<TrailParticleData> {
        public TrailParticleType() {
            this(ALWAYS_SHOW_TRAIL);
        }

        public TrailParticleType(boolean alwaysShow) {
            super(alwaysShow, DESERIALIZER);
        }

        @NotNull
        public Codec<TrailParticleData> m_7652_() {
            return CODEC;
        }
    }
}

