/*
 * Decompiled with CFR 0.152.
 */
package endorh.aerobaticelytra.common.particle;

import com.google.common.collect.ImmutableList;
import endorh.aerobaticelytra.AerobaticElytra;
import endorh.aerobaticelytra.client.particle.TrailParticle;
import endorh.aerobaticelytra.common.particle.TrailParticleData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
public class AerobaticElytraParticles {
    public static TrailParticleData.TrailParticleType TRAIL_PARTICLE;
    public static TrailParticleData.StarTrailParticleType STAR_TRAIL_PARTICLE;
    public static TrailParticleData.CreeperTrailParticleType CREEPER_TRAIL_PARTICLE;
    public static TrailParticleData.BurstTrailParticleType BURST_TRAIL_PARTICLE;
    public static TrailParticleData.BubbleTrailParticleType BUBBLE_TRAIL_PARTICLE;
    public static List<TrailParticleData.TrailParticleType> TRAIL_PARTICLES;

    @SubscribeEvent
    public static void onParticleTypeRegistration(RegisterEvent event) {
        event.register(ForgeRegistries.PARTICLE_TYPES.getRegistryKey(), r -> {
            TRAIL_PARTICLE = AerobaticElytraParticles.reg(r, TrailParticleData.TrailParticleType::new, "trail_particle");
            STAR_TRAIL_PARTICLE = AerobaticElytraParticles.reg(r, TrailParticleData.StarTrailParticleType::new, "star_trail_particle");
            CREEPER_TRAIL_PARTICLE = AerobaticElytraParticles.reg(r, TrailParticleData.CreeperTrailParticleType::new, "creeper_trail_particle");
            BURST_TRAIL_PARTICLE = AerobaticElytraParticles.reg(r, TrailParticleData.BurstTrailParticleType::new, "burst_trail_particle");
            BUBBLE_TRAIL_PARTICLE = AerobaticElytraParticles.reg(r, TrailParticleData.BubbleTrailParticleType::new, "bubble_trail_particle");
            TRAIL_PARTICLES = ImmutableList.of((Object)((Object)TRAIL_PARTICLE), (Object)((Object)TRAIL_PARTICLE), (Object)((Object)STAR_TRAIL_PARTICLE), (Object)((Object)CREEPER_TRAIL_PARTICLE), (Object)((Object)BURST_TRAIL_PARTICLE), (Object)((Object)BUBBLE_TRAIL_PARTICLE));
            AerobaticElytra.logRegistered("Particles");
        });
    }

    private static <T extends ParticleType<?>> T reg(RegisterEvent.RegisterHelper<ParticleType<?>> registry, Supplier<T> constructor, String name) {
        ParticleType particleType = (ParticleType)constructor.get();
        registry.register(AerobaticElytra.prefix(name), (Object)particleType);
        return (T)particleType;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="aerobaticelytra")
    @OnlyIn(value=Dist.CLIENT)
    public static class ClientRegistrar {
        @SubscribeEvent
        public static void onParticleFactoryRegistration(RegisterParticleProvidersEvent e) {
            e.registerSpriteSet((ParticleType)TRAIL_PARTICLE, TrailParticle.Factory::new);
            e.registerSpriteSet((ParticleType)STAR_TRAIL_PARTICLE, TrailParticle.Factory::new);
            e.registerSpriteSet((ParticleType)CREEPER_TRAIL_PARTICLE, TrailParticle.Factory::new);
            e.registerSpriteSet((ParticleType)BURST_TRAIL_PARTICLE, TrailParticle.Factory::new);
            e.registerSpriteSet((ParticleType)BUBBLE_TRAIL_PARTICLE, TrailParticle.Factory::new);
            AerobaticElytra.logRegistered("Particle Factories");
        }
    }
}

